/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.runtime.interceptor;

import io.quarkus.security.runtime.interceptor.SecurityConstrainer;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.interceptor.InvocationContext;

@Singleton
public class SecurityHandler {
    private static final String HANDLER_NAME = SecurityHandler.class.getName();
    private static final String EXECUTED = "executed";
    @Inject
    SecurityConstrainer constrainer;

    public Object handle(InvocationContext ic) throws Exception {
        if (this.alreadyHandled(ic)) {
            return ic.proceed();
        }
        this.constrainer.checkRoles(ic.getMethod());
        return ic.proceed();
    }

    private boolean alreadyHandled(InvocationContext ic) {
        return ic.getContextData().put(HANDLER_NAME, EXECUTED) != null;
    }
}

