/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.Converters;
import io.smallrye.config.ImplicitConverters;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.IntFunction;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;

public class SmallRyeConfig
implements Config,
Serializable {
    private static final long serialVersionUID = 8138651532357898263L;
    static final Comparator<ConfigSource> CONFIG_SOURCE_COMPARATOR = new Comparator<ConfigSource>(){

        @Override
        public int compare(ConfigSource o1, ConfigSource o2) {
            int res = Long.signum((long)o2.getOrdinal() - (long)o1.getOrdinal());
            return res != 0 ? res : o2.getName().compareTo(o1.getName());
        }
    };
    private final AtomicReference<List<ConfigSource>> configSourcesRef;
    private final Map<Type, Converter<?>> converters;

    protected SmallRyeConfig(List<ConfigSource> configSources, Map<Type, Converter<?>> converters) {
        this.configSourcesRef = new AtomicReference<List<ConfigSource>>(Collections.unmodifiableList(configSources));
        this.converters = new HashMap(Converters.ALL_CONVERTERS);
        this.converters.putAll(converters);
    }

    public <T, C extends Collection<T>> C getValues(String name, Class<T> itemClass, IntFunction<C> collectionFactory) {
        return this.getValues(name, this.getConverter(itemClass), collectionFactory);
    }

    public <T, C extends Collection<T>> C getValues(String name, Converter<T> converter, IntFunction<C> collectionFactory) {
        for (ConfigSource configSource : this.getConfigSources()) {
            String value = configSource.getValue(name);
            if (value == null) continue;
            Collection collection = (Collection)Converters.newCollectionConverter(converter, collectionFactory).convert(value);
            if (collection == null) break;
            return (C)collection;
        }
        throw SmallRyeConfig.propertyNotFound(name);
    }

    @Override
    public <T> T getValue(String name, Class<T> aClass) {
        for (ConfigSource configSource : this.getConfigSources()) {
            String value = configSource.getValue(name);
            if (value == null) continue;
            if (value.isEmpty()) break;
            return this.convert(value, aClass);
        }
        if (aClass.isAssignableFrom(OptionalInt.class)) {
            return aClass.cast(OptionalInt.empty());
        }
        if (aClass.isAssignableFrom(OptionalLong.class)) {
            return aClass.cast(OptionalLong.empty());
        }
        if (aClass.isAssignableFrom(OptionalDouble.class)) {
            return aClass.cast(OptionalDouble.empty());
        }
        throw SmallRyeConfig.propertyNotFound(name);
    }

    public <T> T getValue(String name, Converter<T> converter) {
        for (ConfigSource configSource : this.getConfigSources()) {
            String value = configSource.getValue(name);
            if (value == null) continue;
            if (value.isEmpty()) break;
            return converter.convert(value);
        }
        throw SmallRyeConfig.propertyNotFound(name);
    }

    @Override
    public <T> Optional<T> getOptionalValue(String name, Class<T> aClass) {
        return this.getOptionalValue(name, this.getConverter(aClass));
    }

    public <T> Optional<T> getOptionalValue(String name, Converter<T> converter) {
        for (ConfigSource configSource : this.getConfigSources()) {
            String value = configSource.getValue(name);
            if (value == null) continue;
            return value.isEmpty() ? Optional.empty() : Optional.of(converter.convert(value));
        }
        return Optional.empty();
    }

    public <T, C extends Collection<T>> Optional<C> getOptionalValues(String name, Class<T> itemClass, IntFunction<C> collectionFactory) {
        return this.getOptionalValues(name, this.getConverter(itemClass), collectionFactory);
    }

    public <T, C extends Collection<T>> Optional<C> getOptionalValues(String name, Converter<T> converter, IntFunction<C> collectionFactory) {
        for (ConfigSource configSource : this.getConfigSources()) {
            String value = configSource.getValue(name);
            if (value == null) continue;
            Collection collection = (Collection)Converters.newCollectionConverter(converter, collectionFactory).convert(value);
            return Optional.ofNullable(collection);
        }
        return Optional.empty();
    }

    @Override
    public Iterable<String> getPropertyNames() {
        HashSet<String> names = new HashSet<String>();
        for (ConfigSource configSource : this.getConfigSources()) {
            names.addAll(configSource.getProperties().keySet());
        }
        return names;
    }

    @Override
    public Iterable<ConfigSource> getConfigSources() {
        return this.configSourcesRef.get();
    }

    public void addConfigSource(ConfigSource configSource) {
        List<ConfigSource> newVal;
        List<ConfigSource> oldVal;
        do {
            oldVal = this.configSourcesRef.get();
            int oldSize = oldVal.size();
            newVal = Arrays.asList(oldVal.toArray(new ConfigSource[oldSize + 1]));
            newVal.set(oldSize, configSource);
            newVal.sort(CONFIG_SOURCE_COMPARATOR);
        } while (!this.configSourcesRef.compareAndSet(oldVal, Collections.unmodifiableList(newVal)));
    }

    public <T> T convert(String value, Class<T> asType) {
        return value != null ? (T)this.getConverter(asType).convert(value) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Converter<T> getConverter(Class<T> asType) {
        if (asType.isArray()) {
            return Converters.newArrayConverter(this.getConverter(asType.getComponentType()), asType);
        }
        Converter<Object> converter = this.converters.get(asType);
        if (converter == null) {
            Map<Type, Converter<?>> map = this.converters;
            synchronized (map) {
                converter = ImplicitConverters.getConverter(asType);
                this.converters.putIfAbsent(asType, converter);
            }
        }
        if (converter == null) {
            throw new IllegalArgumentException("No Converter registered for class " + asType);
        }
        return converter;
    }

    private static NoSuchElementException propertyNotFound(String name) {
        return new NoSuchElementException("Property " + name + " not found");
    }
}

