/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context.propagators.rxjava2;

import io.reactivex.Flowable;
import io.reactivex.functions.Function;
import java.util.concurrent.Executor;
import org.eclipse.microprofile.context.ThreadContext;
import org.reactivestreams.Subscriber;

public class ContextPropagatorOnFlowableAssemblyAction
implements Function<Flowable, Flowable> {
    private ThreadContext threadContext;

    public ContextPropagatorOnFlowableAssemblyAction(ThreadContext threadContext) {
        this.threadContext = threadContext;
    }

    @Override
    public Flowable apply(Flowable t) throws Exception {
        return new ContextPropagatorFlowable(t, this.threadContext.currentContextExecutor());
    }

    public class ContextPropagatorFlowable<T>
    extends Flowable<T> {
        private Flowable<T> source;
        private final Executor contextExecutor;

        public ContextPropagatorFlowable(Flowable<T> t, Executor contextExecutor) {
            this.source = t;
            this.contextExecutor = contextExecutor;
        }

        @Override
        protected void subscribeActual(Subscriber<? super T> observer) {
            this.contextExecutor.execute(() -> this.source.subscribe(observer));
        }
    }
}

