/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context.propagators.rxjava2;

import io.reactivex.Maybe;
import io.reactivex.MaybeObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.BiFunction;
import java.util.concurrent.Executor;
import org.eclipse.microprofile.context.ThreadContext;

public class ContextPropagatorOnMaybeCreateAction
implements BiFunction<Maybe, MaybeObserver, MaybeObserver> {
    private ThreadContext threadContext;

    public ContextPropagatorOnMaybeCreateAction(ThreadContext threadContext) {
        this.threadContext = threadContext;
    }

    @Override
    public MaybeObserver apply(Maybe maybe, MaybeObserver observer) throws Exception {
        return new ContextCapturerMaybe(maybe, observer, this.threadContext.currentContextExecutor());
    }

    public class ContextCapturerMaybe<T>
    implements MaybeObserver<T> {
        private final MaybeObserver<T> source;
        private final Executor contextExecutor;

        public ContextCapturerMaybe(Maybe<T> observable, MaybeObserver<T> observer, Executor contextExecutor) {
            this.source = observer;
            this.contextExecutor = contextExecutor;
        }

        @Override
        public void onComplete() {
            this.contextExecutor.execute(() -> this.source.onComplete());
        }

        @Override
        public void onError(Throwable t) {
            this.contextExecutor.execute(() -> this.source.onError(t));
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.contextExecutor.execute(() -> this.source.onSubscribe(d));
        }

        @Override
        public void onSuccess(T v) {
            this.contextExecutor.execute(() -> this.source.onSuccess(v));
        }
    }
}

