/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.extension;

import io.reactivex.Flowable;
import io.smallrye.reactive.messaging.ChannelRegistry;
import io.smallrye.reactive.messaging.annotations.Channel;
import io.smallrye.reactive.messaging.annotations.Emitter;
import io.smallrye.reactive.messaging.annotations.Stream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.eclipse.microprofile.reactive.streams.operators.SubscriberBuilder;
import org.reactivestreams.Publisher;

@ApplicationScoped
public class ChannelProducer {
    @Inject
    ChannelRegistry channelRegistry;

    @Produces
    @Channel(value="")
    <T> Flowable<T> producePublisher(InjectionPoint injectionPoint) {
        Type first = this.getFirstParameter(injectionPoint.getType());
        if (TypeUtils.isAssignable(first, Message.class)) {
            return (Flowable)ChannelProducer.cast(Flowable.fromPublisher(this.getPublisher(injectionPoint)));
        }
        return (Flowable)ChannelProducer.cast(Flowable.fromPublisher(this.getPublisher(injectionPoint)).map(Message::getPayload));
    }

    @Produces
    @Stream(value="")
    <T> Flowable<T> producePublisherLegacy(InjectionPoint injectionPoint) {
        return this.producePublisher(injectionPoint);
    }

    @Produces
    @Channel(value="")
    <T> PublisherBuilder<T> producePublisherBuilder(InjectionPoint injectionPoint) {
        Type first = this.getFirstParameter(injectionPoint.getType());
        if (TypeUtils.isAssignable(first, Message.class)) {
            return (PublisherBuilder)ChannelProducer.cast(ReactiveStreams.fromPublisher(this.getPublisher(injectionPoint)));
        }
        return (PublisherBuilder)ChannelProducer.cast(ReactiveStreams.fromPublisher(this.getPublisher(injectionPoint)).map(Message::getPayload));
    }

    @Produces
    @Stream(value="")
    <T> PublisherBuilder<T> producePublisherBuilderLegacy(InjectionPoint injectionPoint) {
        return this.producePublisherBuilder(injectionPoint);
    }

    @Produces
    @Channel(value="")
    <T> Emitter<T> produceEmitter(InjectionPoint injectionPoint) {
        Emitter emitter = this.getEmitter(injectionPoint);
        return (Emitter)ChannelProducer.cast(emitter);
    }

    @Produces
    @Stream(value="")
    <T> Emitter<T> produceEmitterLegacy(InjectionPoint injectionPoint) {
        return this.produceEmitter(injectionPoint);
    }

    private Publisher<? extends Message> getPublisher(InjectionPoint injectionPoint) {
        String name = ChannelProducer.getChannelName(injectionPoint);
        List<PublisherBuilder<? extends Message>> list = this.channelRegistry.getPublishers(name);
        if (list.isEmpty()) {
            throw new IllegalStateException("Unable to find a stream with the name " + name + ", available streams are: " + this.channelRegistry.getIncomingNames());
        }
        return list.get(0).buildRs();
    }

    private SubscriberBuilder<? extends Message, Void> getSubscriberBuilder(InjectionPoint injectionPoint) {
        String name = ChannelProducer.getChannelName(injectionPoint);
        List<SubscriberBuilder<? extends Message, Void>> list = this.channelRegistry.getSubscribers(name);
        if (list.isEmpty()) {
            throw new IllegalStateException("Unable to find a stream with the name " + name + ", available streams are: " + this.channelRegistry.getOutgoingNames());
        }
        return list.get(0);
    }

    private Emitter getEmitter(InjectionPoint injectionPoint) {
        String name = ChannelProducer.getChannelName(injectionPoint);
        Emitter<?> emitter = this.channelRegistry.getEmitter(name);
        if (emitter == null) {
            throw new IllegalStateException("Unable to find a emitter with the name " + name + ", available emitters are: " + this.channelRegistry.getEmitterNames());
        }
        return emitter;
    }

    private Type getFirstParameter(Type type) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return null;
    }

    static String getChannelName(InjectionPoint injectionPoint) {
        for (Annotation qualifier : injectionPoint.getQualifiers()) {
            if (qualifier.annotationType().equals(Channel.class)) {
                return ((Channel)qualifier).value();
            }
            if (!qualifier.annotationType().equals(Stream.class)) continue;
            return ((Stream)qualifier).value();
        }
        throw new IllegalStateException("@Channel qualifier not found on + " + injectionPoint);
    }

    static Channel getChannelQualifier(InjectionPoint injectionPoint) {
        for (final Annotation qualifier : injectionPoint.getQualifiers()) {
            if (qualifier.annotationType().equals(Channel.class)) {
                return (Channel)qualifier;
            }
            if (!qualifier.annotationType().equals(Stream.class)) continue;
            return new Channel(){

                @Override
                public Class<? extends Annotation> annotationType() {
                    return Channel.class;
                }

                @Override
                public String value() {
                    return ((Stream)qualifier).value();
                }
            };
        }
        return null;
    }

    private static <T> T cast(Object obj) {
        return (T)obj;
    }
}

