/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.extension;

import io.reactivex.Flowable;
import io.smallrye.reactive.messaging.ChannelRegistry;
import io.smallrye.reactive.messaging.annotations.Merge;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.slf4j.Logger;

class LazySource
implements Publisher<Message> {
    private PublisherBuilder<? extends Message> delegate;
    private String source;
    private Merge.Mode mode;

    LazySource(String source, Merge.Mode mode) {
        this.source = source;
        this.mode = mode;
    }

    public void configure(ChannelRegistry registry, Logger logger2) {
        List<PublisherBuilder<? extends Message>> list = registry.getPublishers(this.source);
        if (!list.isEmpty()) {
            switch (this.mode) {
                case MERGE: {
                    this.merge(list);
                    break;
                }
                case ONE: {
                    this.delegate = list.get(0);
                    if (list.size() <= 1) break;
                    logger2.warn("Multiple publisher found for {}, using the merge policy `ONE` takes the first found", (Object)this.source);
                    break;
                }
                case CONCAT: {
                    this.concat(list);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown merge policy for " + this.source + ": " + (Object)((Object)this.mode));
                }
            }
        }
    }

    private void merge(List<PublisherBuilder<? extends Message>> list) {
        this.delegate = ReactiveStreams.fromPublisher(Flowable.merge(list.stream().map(PublisherBuilder::buildRs).map(Flowable::fromPublisher).collect(Collectors.toList())));
    }

    private void concat(List<PublisherBuilder<? extends Message>> list) {
        this.delegate = ReactiveStreams.fromPublisher(Flowable.concat(list.stream().map(PublisherBuilder::buildRs).map(Flowable::fromPublisher).collect(Collectors.toList())));
    }

    @Override
    public void subscribe(Subscriber<? super Message> s) {
        this.delegate.to(s).run();
    }
}

