/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;

public class MessageHeaders {
    private final Headers headers;

    protected MessageHeaders(Headers headers) {
        this.headers = headers;
    }

    public MessageHeaders() {
        this.headers = new RecordHeaders();
    }

    public MessageHeaders put(String key, byte[] value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        this.headers.add(new RecordHeader(key, value));
        return this;
    }

    public MessageHeaders put(String key, ByteBuffer value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        this.headers.add(new RecordHeader(key, value));
        return this;
    }

    public MessageHeaders put(String key, String value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        this.headers.add(new RecordHeader(key, value.getBytes()));
        return this;
    }

    public MessageHeaders put(String key, String value, Charset enc) {
        Objects.requireNonNull(enc);
        return this.put(key, value.getBytes(enc));
    }

    public MessageHeaders remove(String key) {
        this.headers.remove(Objects.requireNonNull(key));
        return this;
    }

    public Optional<byte[]> getOneAsBytes(String key) {
        Header header = this.headers.lastHeader(Objects.requireNonNull(key, "The `key` must not be `null`"));
        return Optional.ofNullable(header).map(Header::value);
    }

    public Optional<String> getOneAsString(String key) {
        return this.getOneAsString(key, StandardCharsets.UTF_8);
    }

    public Optional<String> getOneAsString(String key, Charset enc) {
        return this.getOneAsBytes(key).map(bytes -> {
            Charset t = Objects.requireNonNull(enc, "The `enc` must not be `null`");
            return new String((byte[])bytes, t);
        });
    }

    public List<byte[]> getAllAsBytes(String key) {
        Iterable<Header> list = this.headers.headers(Objects.requireNonNull(key, "The `key` must not be `null`"));
        return StreamSupport.stream(list.spliterator(), false).map(Header::value).collect(Collectors.toList());
    }

    public List<String> getAllAsStrings(String key) {
        return this.getAllAsStrings(key, StandardCharsets.UTF_8);
    }

    public List<String> getAllAsStrings(String key, Charset enc) {
        return this.getAllAsBytes(key).stream().map(bytes -> new String((byte[])bytes, Objects.requireNonNull(enc, "`enc` must not be `null`"))).collect(Collectors.toList());
    }

    public Iterable<Header> unwrap() {
        return this.headers;
    }

    public MessageHeaders clone() {
        return new MessageHeaders(this.headers);
    }
}

