/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.graphql.impl;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.graphql.ApolloWSHandler;
import io.vertx.ext.web.handler.graphql.ApolloWSMessage;
import io.vertx.ext.web.handler.graphql.ApolloWSMessageType;
import io.vertx.ext.web.handler.graphql.ApolloWSOptions;
import io.vertx.ext.web.handler.graphql.impl.ApolloWSMessageImpl;
import io.vertx.ext.web.handler.graphql.impl.GraphQLQuery;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.dataloader.DataLoaderRegistry;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class ApolloWSHandlerImpl
implements ApolloWSHandler {
    private static final Function<ApolloWSMessage, Object> DEFAULT_QUERY_CONTEXT_FACTORY = context -> context;
    private static final Function<ApolloWSMessage, DataLoaderRegistry> DEFAULT_DATA_LOADER_REGISTRY_FACTORY = rc -> null;
    private static final String HEADER_CONNECTION_UPGRADE_VALUE = "upgrade";
    private final GraphQL graphQL;
    private final long keepAlive;
    private Function<ApolloWSMessage, Object> queryContextFactory = DEFAULT_QUERY_CONTEXT_FACTORY;
    private Function<ApolloWSMessage, DataLoaderRegistry> dataLoaderRegistryFactory = DEFAULT_DATA_LOADER_REGISTRY_FACTORY;
    private Handler<ServerWebSocket> connectionHandler;
    private Handler<ServerWebSocket> endHandler;
    private Handler<ApolloWSMessage> messageHandler;

    public ApolloWSHandlerImpl(GraphQL graphQL, ApolloWSOptions options) {
        Objects.requireNonNull(graphQL, "graphQL");
        Objects.requireNonNull(options, "options");
        this.graphQL = graphQL;
        this.keepAlive = options.getKeepAlive();
    }

    @Override
    public synchronized ApolloWSHandler connectionHandler(Handler<ServerWebSocket> connectionHandler) {
        this.connectionHandler = connectionHandler;
        return this;
    }

    @Override
    public synchronized ApolloWSHandler messageHandler(Handler<ApolloWSMessage> messageHandler) {
        this.messageHandler = messageHandler;
        return this;
    }

    @Override
    public synchronized ApolloWSHandler endHandler(Handler<ServerWebSocket> endHandler) {
        this.endHandler = endHandler;
        return this;
    }

    @Override
    public synchronized ApolloWSHandler queryContext(Function<ApolloWSMessage, Object> factory) {
        this.queryContextFactory = factory != null ? factory : DEFAULT_QUERY_CONTEXT_FACTORY;
        return this;
    }

    @Override
    public synchronized ApolloWSHandler dataLoaderRegistry(Function<ApolloWSMessage, DataLoaderRegistry> factory) {
        this.dataLoaderRegistryFactory = factory != null ? factory : DEFAULT_DATA_LOADER_REGISTRY_FACTORY;
        return this;
    }

    @Override
    public void handle(RoutingContext routingContext) {
        MultiMap headers = routingContext.request().headers();
        if (headers.contains(HttpHeaders.CONNECTION) && headers.contains(HttpHeaders.UPGRADE, HttpHeaders.WEBSOCKET, true)) {
            ServerWebSocket serverWebSocket = routingContext.request().upgrade();
            this.handleConnection(routingContext.vertx(), serverWebSocket);
        } else {
            routingContext.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleConnection(Vertx vertx, ServerWebSocket serverWebSocket) {
        Handler<ServerWebSocket> ch;
        ConcurrentHashMap subscriptions = new ConcurrentHashMap();
        ApolloWSHandlerImpl apolloWSHandlerImpl = this;
        synchronized (apolloWSHandlerImpl) {
            ch = this.connectionHandler;
        }
        if (ch != null) {
            ch.handle(serverWebSocket);
        }
        serverWebSocket.handler(buffer -> {
            Handler<ApolloWSMessage> mh;
            JsonObject content = buffer.toJsonObject();
            String opId = content.getString("id");
            ApolloWSMessageType type = ApolloWSMessageType.from(content.getString("type"));
            if (type == null) {
                this.sendMessage(serverWebSocket, opId, ApolloWSMessageType.ERROR, "Unknown message type: " + content.getString("type"));
                return;
            }
            ApolloWSMessageImpl message = new ApolloWSMessageImpl(serverWebSocket, type, content);
            ApolloWSHandlerImpl apolloWSHandlerImpl = this;
            synchronized (apolloWSHandlerImpl) {
                mh = this.messageHandler;
            }
            if (mh != null) {
                mh.handle(message);
            }
            switch (type) {
                case CONNECTION_INIT: {
                    this.connect(vertx, serverWebSocket);
                    break;
                }
                case CONNECTION_TERMINATE: {
                    serverWebSocket.close();
                    break;
                }
                case START: {
                    this.start(serverWebSocket, subscriptions, message);
                    break;
                }
                case STOP: {
                    this.stop(serverWebSocket, subscriptions, opId);
                    break;
                }
                default: {
                    this.sendMessage(serverWebSocket, opId, ApolloWSMessageType.ERROR, "Unsupported message type: " + (Object)((Object)type));
                }
            }
        });
        serverWebSocket.endHandler(v -> {
            Handler<ServerWebSocket> eh;
            subscriptions.values().forEach(Subscription::cancel);
            ApolloWSHandlerImpl apolloWSHandlerImpl = this;
            synchronized (apolloWSHandlerImpl) {
                eh = this.endHandler;
            }
            if (eh != null) {
                eh.handle(serverWebSocket);
            }
        });
    }

    private void connect(Vertx vertx, ServerWebSocket serverWebSocket) {
        this.sendMessage(serverWebSocket, null, ApolloWSMessageType.CONNECTION_ACK, null);
        if (this.keepAlive > 0L) {
            this.sendMessage(serverWebSocket, null, ApolloWSMessageType.CONNECTION_KEEP_ALIVE, null);
            vertx.setPeriodic(this.keepAlive, timerId -> {
                if (serverWebSocket.isClosed()) {
                    vertx.cancelTimer((long)timerId);
                } else {
                    this.sendMessage(serverWebSocket, null, ApolloWSMessageType.CONNECTION_KEEP_ALIVE, null);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(ServerWebSocket serverWebSocket, Map<String, Subscription> subscriptions, ApolloWSMessage message) {
        Map<String, Object> variables;
        String operationName;
        Function<ApolloWSMessage, DataLoaderRegistry> dlr;
        Function<ApolloWSMessage, Object> qc;
        String opId = message.content().getString("id");
        if (subscriptions.containsKey(opId)) {
            this.stop(serverWebSocket, subscriptions, opId);
        }
        GraphQLQuery payload = message.content().getJsonObject("payload").mapTo(GraphQLQuery.class);
        ExecutionInput.Builder builder = ExecutionInput.newExecutionInput();
        builder.query(payload.getQuery());
        ApolloWSHandlerImpl apolloWSHandlerImpl = this;
        synchronized (apolloWSHandlerImpl) {
            qc = this.queryContextFactory;
        }
        builder.context(qc.apply(message));
        ApolloWSHandlerImpl apolloWSHandlerImpl2 = this;
        synchronized (apolloWSHandlerImpl2) {
            dlr = this.dataLoaderRegistryFactory;
        }
        DataLoaderRegistry registry = dlr.apply(message);
        if (registry != null) {
            builder.dataLoaderRegistry(registry);
        }
        if ((operationName = payload.getOperationName()) != null) {
            builder.operationName(operationName);
        }
        if ((variables = payload.getVariables()) != null) {
            builder.variables(variables);
        }
        this.graphQL.executeAsync(builder).thenAccept(executionResult -> {
            if (executionResult.getData() instanceof Publisher) {
                this.subscribe(serverWebSocket, subscriptions, opId, (ExecutionResult)executionResult);
            } else {
                this.sendMessage(serverWebSocket, opId, ApolloWSMessageType.DATA, new JsonObject(executionResult.toSpecification()));
            }
        });
    }

    private void subscribe(final ServerWebSocket serverWebSocket, final Map<String, Subscription> subscriptions, final String opId, ExecutionResult executionResult) {
        Publisher publisher = (Publisher)executionResult.getData();
        final AtomicReference subscriptionRef = new AtomicReference();
        publisher.subscribe(new Subscriber<ExecutionResult>(){

            @Override
            public void onSubscribe(Subscription s) {
                subscriptionRef.set(s);
                subscriptions.put(opId, s);
                s.request(1L);
            }

            @Override
            public void onNext(ExecutionResult er) {
                ApolloWSHandlerImpl.this.sendMessage(serverWebSocket, opId, ApolloWSMessageType.DATA, new JsonObject(er.toSpecification()));
                ((Subscription)subscriptionRef.get()).request(1L);
            }

            @Override
            public void onError(Throwable t) {
                ApolloWSHandlerImpl.this.sendMessage(serverWebSocket, opId, ApolloWSMessageType.ERROR, new JsonObject().put("message", t.getMessage()));
                subscriptions.remove(opId);
            }

            @Override
            public void onComplete() {
                ApolloWSHandlerImpl.this.sendMessage(serverWebSocket, opId, ApolloWSMessageType.COMPLETE, null);
                subscriptions.remove(opId);
            }
        });
    }

    private void stop(ServerWebSocket serverWebSocket, Map<String, Subscription> subscriptions, String opId) {
        Subscription subscription = subscriptions.get(opId);
        if (subscription != null) {
            subscription.cancel();
            subscriptions.remove(opId);
        }
    }

    private void sendMessage(ServerWebSocket serverWebSocket, String opId, ApolloWSMessageType type, Object payload) {
        Objects.requireNonNull(type, "type is null");
        JsonObject message = new JsonObject();
        if (opId != null) {
            message.put("id", opId);
        }
        message.put("type", type.getText());
        if (payload != null) {
            message.put("payload", payload);
        }
        serverWebSocket.writeTextMessage(message.toString());
    }
}

