/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Broker;
import kafka.controller.ControllerBrokerStateInfo;
import kafka.controller.ControllerChannelManager$;
import kafka.controller.ControllerContext;
import kafka.controller.QueueItem;
import kafka.controller.RequestSendThread;
import kafka.controller.StateChangeLogger;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.HashMap;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\u0005Mx!\u0002\u0010 \u0011\u0003!c!\u0002\u0014 \u0011\u00039\u0003\"\u0002\u0018\u0002\t\u0003y\u0003b\u0002\u0019\u0002\u0005\u0004%\t!\r\u0005\u0007u\u0005\u0001\u000b\u0011\u0002\u001a\t\u000fm\n!\u0019!C\u0001c!1A(\u0001Q\u0001\nIBq!P\u0001\u0012\u0002\u0013\u0005aH\u0002\u0003'?\u00011\u0006\u0002C2\t\u0005\u0003\u0005\u000b\u0011\u00023\t\u0011\u001dD!\u0011!Q\u0001\n!D\u0001B\u001c\u0005\u0003\u0002\u0003\u0006Ia\u001c\u0005\tA\"\u0011\t\u0011)A\u0005w\"Q\u0011\u0011\u0001\u0005\u0003\u0002\u0003\u0006I!a\u0001\t\u0013\u0005%\u0001B!A!\u0002\u0013\u0001\u0005B\u0002\u0018\t\t\u0003\tY\u0001C\u0005\u0002\u001c!\u0011\r\u0011\"\u0005\u0002\u001e!A\u00111\b\u0005!\u0002\u0013\ty\u0002C\u0005\u0002>!\u0011\r\u0011\"\u0003\u0002@!A\u0011q\t\u0005!\u0002\u0013\t\t\u0005C\u0004\u0002J!!\t!a\u0013\t\u000f\u0005M\u0003\u0002\"\u0001\u0002L!9\u0011Q\u000b\u0005\u0005\u0002\u0005]\u0003\"CAW\u0011E\u0005I\u0011AAX\u0011\u001d\t\u0019\f\u0003C\u0001\u0003kCq!a2\t\t\u0003\tI\rC\u0004\u0002N\"!I!a4\t\u000f\u0005M\u0007\u0002\"\u0003\u0002V\"9\u0011Q\u001d\u0005\u0005\n\u0005\u001d\bbBAw\u0011\u0011E\u0011q^\u0001\u0019\u0007>tGO]8mY\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014(B\u0001\u0011\"\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0002E\u0005)1.\u00194lC\u000e\u0001\u0001CA\u0013\u0002\u001b\u0005y\"\u0001G\"p]R\u0014x\u000e\u001c7fe\u000eC\u0017M\u001c8fY6\u000bg.Y4feN\u0011\u0011\u0001\u000b\t\u0003S1j\u0011A\u000b\u0006\u0002W\u0005)1oY1mC&\u0011QF\u000b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005!\u0013aE)vKV,7+\u001b>f\u001b\u0016$(/[2OC6,W#\u0001\u001a\u0011\u0005MBT\"\u0001\u001b\u000b\u0005U2\u0014\u0001\u00027b]\u001eT\u0011aN\u0001\u0005U\u00064\u0018-\u0003\u0002:i\t11\u000b\u001e:j]\u001e\fA#U;fk\u0016\u001c\u0016N_3NKR\u0014\u0018n\u0019(b[\u0016\u0004\u0013!\t*fcV,7\u000f\u001e*bi\u0016\fe\u000eZ)vKV,G+[7f\u001b\u0016$(/[2OC6,\u0017A\t*fcV,7\u000f\u001e*bi\u0016\fe\u000eZ)vKV,G+[7f\u001b\u0016$(/[2OC6,\u0007%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEN\u000b\u0002\u007f)\u0012\u0001)\u0014\t\u0004S\u0005\u001b\u0015B\u0001\"+\u0005\u0019y\u0005\u000f^5p]B\u0011Ai\u0013\b\u0003\u000b&\u0003\"A\u0012\u0016\u000e\u0003\u001dS!\u0001S\u0012\u0002\rq\u0012xn\u001c;?\u0013\tQ%&\u0001\u0004Qe\u0016$WMZ\u0005\u0003s1S!A\u0013\u0016,\u00039\u0003\"a\u0014+\u000e\u0003AS!!\u0015*\u0002\u0013Ut7\r[3dW\u0016$'BA*+\u0003)\tgN\\8uCRLwN\\\u0005\u0003+B\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f'\u0011A\u0001fV/\u0011\u0005a[V\"A-\u000b\u0005i\u000b\u0013!B;uS2\u001c\u0018B\u0001/Z\u0005\u001daunZ4j]\u001e\u0004\"AX1\u000e\u0003}S!\u0001Y\u0011\u0002\u000f5,GO]5dg&\u0011!m\u0018\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\u0018!E2p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yiB\u0011Q%Z\u0005\u0003M~\u0011\u0011cQ8oiJ|G\u000e\\3s\u0007>tG/\u001a=u\u0003\u0019\u0019wN\u001c4jOB\u0011\u0011\u000e\\\u0007\u0002U*\u00111.I\u0001\u0007g\u0016\u0014h/\u001a:\n\u00055T'aC&bM.\f7i\u001c8gS\u001e\fA\u0001^5nKB\u0011\u0001/_\u0007\u0002c*\u0011!L\u001d\u0006\u0003gR\faaY8n[>t'B\u0001\u0012v\u0015\t1x/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002q\u0006\u0019qN]4\n\u0005i\f(\u0001\u0002+j[\u0016\u0004\"\u0001 @\u000e\u0003uT!\u0001\u0019:\n\u0005}l(aB'fiJL7m]\u0001\u0012gR\fG/Z\"iC:<W\rT8hO\u0016\u0014\bcA\u0013\u0002\u0006%\u0019\u0011qA\u0010\u0003#M#\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'/\u0001\tuQJ,\u0017\r\u001a(b[\u0016\u0004&/\u001a4jqRq\u0011QBA\b\u0003#\t\u0019\"!\u0006\u0002\u0018\u0005e\u0001CA\u0013\t\u0011\u0015\u0019w\u00021\u0001e\u0011\u00159w\u00021\u0001i\u0011\u0015qw\u00021\u0001p\u0011\u0015\u0001w\u00021\u0001|\u0011\u001d\t\ta\u0004a\u0001\u0003\u0007A\u0001\"!\u0003\u0010!\u0003\u0005\r\u0001Q\u0001\u0010EJ|7.\u001a:Ti\u0006$X-\u00138g_V\u0011\u0011q\u0004\t\t\u0003C\tY#a\f\u000265\u0011\u00111\u0005\u0006\u0005\u0003K\t9#A\u0004nkR\f'\r\\3\u000b\u0007\u0005%\"&\u0001\u0006d_2dWm\u0019;j_:LA!!\f\u0002$\t9\u0001*Y:i\u001b\u0006\u0004\bcA\u0015\u00022%\u0019\u00111\u0007\u0016\u0003\u0007%sG\u000fE\u0002&\u0003oI1!!\u000f \u0005e\u0019uN\u001c;s_2dWM\u001d\"s_.,'o\u0015;bi\u0016LeNZ8\u0002!\t\u0014xn[3s'R\fG/Z%oM>\u0004\u0013A\u00032s_.,'\u000fT8dWV\u0011\u0011\u0011\t\t\u0004g\u0005\r\u0013bAA#i\t1qJ\u00196fGR\f1B\u0019:pW\u0016\u0014Hj\\2lA\u000591\u000f^1siV\u0004HCAA'!\rI\u0013qJ\u0005\u0004\u0003#R#\u0001B+oSR\f\u0001b\u001d5vi\u0012|wO\\\u0001\fg\u0016tGMU3rk\u0016\u001cH\u000f\u0006\u0006\u0002N\u0005e\u0013QLA7\u0003;Cq!a\u0017\u0017\u0001\u0004\ty#\u0001\u0005ce>\\WM]%e\u0011\u001d\tyF\u0006a\u0001\u0003C\na!\u00199j\u0017\u0016L\b\u0003BA2\u0003Sj!!!\u001a\u000b\u0007\u0005\u001d$/\u0001\u0005qe>$xnY8m\u0013\u0011\tY'!\u001a\u0003\u000f\u0005\u0003\u0018nS3zg\"9\u0011q\u000e\fA\u0002\u0005E\u0014a\u0002:fcV,7\u000f\u001e\u0019\u0005\u0003g\nY\t\u0005\u0004\u0002v\u0005\u0005\u0015q\u0011\b\u0005\u0003o\ni(\u0004\u0002\u0002z)\u0019\u00111\u0010:\u0002\u0011I,\u0017/^3tiNLA!a \u0002z\u00051\u0012IY:ue\u0006\u001cGoQ8oiJ|GNU3rk\u0016\u001cH/\u0003\u0003\u0002\u0004\u0006\u0015%a\u0002\"vS2$WM\u001d\u0006\u0005\u0003\u007f\nI\b\u0005\u0003\u0002\n\u0006-E\u0002\u0001\u0003\r\u0003\u001b\u000bi'!A\u0001\u0002\u000b\u0005\u0011q\u0012\u0002\u0004?\u0012\n\u0014\u0003BAI\u0003/\u00032!KAJ\u0013\r\t)J\u000b\u0002\b\u001d>$\b.\u001b8h!\u0011\t9(!'\n\t\u0005m\u0015\u0011\u0010\u0002\u0017\u0003\n\u001cHO]1di\u000e{g\u000e\u001e:pYJ+\u0017/^3ti\"I\u0011q\u0014\f\u0011\u0002\u0003\u0007\u0011\u0011U\u0001\tG\u0006dGNY1dWB9\u0011&a)\u0002(\u00065\u0013bAASU\tIa)\u001e8di&|g.\r\t\u0005\u0003o\nI+\u0003\u0003\u0002,\u0006e$\u0001E!cgR\u0014\u0018m\u0019;SKN\u0004xN\\:f\u0003U\u0019XM\u001c3SKF,Xm\u001d;%I\u00164\u0017-\u001e7uIQ*\"!!-+\u0007\u0005\u0005V*A\u0005bI\u0012\u0014%o\\6feR!\u0011QJA\\\u0011\u001d\tI\f\u0007a\u0001\u0003w\u000baA\u0019:pW\u0016\u0014\b\u0003BA_\u0003\u0007l!!a0\u000b\u0007\u0005\u0005\u0017%A\u0004dYV\u001cH/\u001a:\n\t\u0005\u0015\u0017q\u0018\u0002\u0007\u0005J|7.\u001a:\u0002\u0019I,Wn\u001c<f\u0005J|7.\u001a:\u0015\t\u00055\u00131\u001a\u0005\b\u00037J\u0002\u0019AA\u0018\u00031\tG\r\u001a(fo\n\u0013xn[3s)\u0011\ti%!5\t\u000f\u0005e&\u00041\u0001\u0002<\u0006\u0001\"M]8lKJlU\r\u001e:jGR\u000bwm\u001d\u000b\u0005\u0003/\f\u0019\u000f\u0005\u0004\u0002Z\u0006}'GM\u0007\u0003\u00037TA!!8\u0002(\u0005I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0005\u0003C\fYNA\u0002NCBDq!a\u0017\u001c\u0001\u0004\ty#\u0001\u000bsK6|g/Z#ySN$\u0018N\\4Ce>\\WM\u001d\u000b\u0005\u0003\u001b\nI\u000fC\u0004\u0002lr\u0001\r!!\u000e\u0002\u0017\t\u0014xn[3s'R\fG/Z\u0001\u0017gR\f'\u000f\u001e*fcV,7\u000f^*f]\u0012$\u0006N]3bIR!\u0011QJAy\u0011\u001d\tY&\ba\u0001\u0003_\u0001")
public class ControllerChannelManager
implements KafkaMetricsGroup {
    private final ControllerContext controllerContext;
    private final KafkaConfig config;
    private final Time time;
    private final Metrics metrics;
    private final StateChangeLogger stateChangeLogger;
    private final Option<String> threadNamePrefix;
    private final HashMap<Object, ControllerBrokerStateInfo> brokerStateInfo;
    private final Object kafka$controller$ControllerChannelManager$$brokerLock;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$6() {
        return ControllerChannelManager$.MODULE$.$lessinit$greater$default$6();
    }

    public static String RequestRateAndQueueTimeMetricName() {
        return ControllerChannelManager$.MODULE$.RequestRateAndQueueTimeMetricName();
    }

    public static String QueueSizeMetricName() {
        return ControllerChannelManager$.MODULE$.QueueSizeMetricName();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ControllerChannelManager controllerChannelManager = this;
        synchronized (controllerChannelManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public HashMap<Object, ControllerBrokerStateInfo> brokerStateInfo() {
        return this.brokerStateInfo;
    }

    public Object kafka$controller$ControllerChannelManager$$brokerLock() {
        return this.kafka$controller$ControllerChannelManager$$brokerLock;
    }

    public void startup() {
        Object object = this.kafka$controller$ControllerChannelManager$$brokerLock();
        synchronized (object) {
            this.brokerStateInfo().foreach((Function1 & Serializable & scala.Serializable)brokerState -> {
                this.startRequestSendThread(brokerState._1$mcI$sp());
                return BoxedUnit.UNIT;
            });
        }
    }

    public void shutdown() {
        Object object = this.kafka$controller$ControllerChannelManager$$brokerLock();
        synchronized (object) {
            this.brokerStateInfo().values().foreach((Function1 & Serializable & scala.Serializable)brokerState -> {
                this.removeExistingBroker(brokerState);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void sendRequest(int brokerId, ApiKeys apiKey, AbstractControlRequest.Builder<? extends AbstractControlRequest> request, Function1<AbstractResponse, BoxedUnit> callback) {
        Object object = this.kafka$controller$ControllerChannelManager$$brokerLock();
        synchronized (object) {
            Option stateInfoOpt;
            Option option = stateInfoOpt = this.brokerStateInfo().get((Object)BoxesRunTime.boxToInteger((int)brokerId));
            if (option instanceof Some) {
                Some some = (Some)option;
                ControllerBrokerStateInfo stateInfo = (ControllerBrokerStateInfo)some.value();
                stateInfo.messageQueue().put(new QueueItem(apiKey, request, callback, this.time.milliseconds()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Not sending request ").append(request).append(" to broker ").append(brokerId).append(", since it is offline.").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
        }
    }

    public Function1<AbstractResponse, BoxedUnit> sendRequest$default$4() {
        return null;
    }

    public void addBroker(Broker broker) {
        Object object = this.kafka$controller$ControllerChannelManager$$brokerLock();
        synchronized (object) {
            if (!this.brokerStateInfo().contains((Object)BoxesRunTime.boxToInteger((int)broker.id()))) {
                this.addNewBroker(broker);
                this.startRequestSendThread(broker.id());
            }
        }
    }

    public void removeBroker(int brokerId) {
        Object object = this.kafka$controller$ControllerChannelManager$$brokerLock();
        synchronized (object) {
            this.removeExistingBroker((ControllerBrokerStateInfo)this.brokerStateInfo().apply((Object)BoxesRunTime.boxToInteger((int)brokerId)));
        }
    }

    private void addNewBroker(Broker broker) {
        String string;
        LinkedBlockingQueue<QueueItem> messageQueue = new LinkedBlockingQueue<QueueItem>();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Controller ").append($this.config.brokerId()).append(" trying to connect to broker ").append(broker.id()).toString());
        ListenerName controllerToBrokerListenerName = (ListenerName)this.config.controlPlaneListenerName().getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.config.interBrokerListenerName());
        SecurityProtocol controllerToBrokerSecurityProtocol = (SecurityProtocol)((Object)this.config.controlPlaneSecurityProtocol().getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.config.interBrokerSecurityProtocol()));
        Node brokerNode = broker.node(controllerToBrokerListenerName);
        LogContext logContext = new LogContext(new StringBuilder(34).append("[Controller id=").append(this.config.brokerId()).append(", targetBrokerId=").append(brokerNode.idString()).append("] ").toString());
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder(controllerToBrokerSecurityProtocol, JaasContext.Type.SERVER, this.config, controllerToBrokerListenerName, this.config.saslMechanismInterBrokerProtocol(), this.time, this.config.saslInterBrokerHandshakeRequestEnable());
        Selector selector = new Selector(-1, -1L, this.metrics, this.time, "controller-channel", (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker-id"), (Object)brokerNode.idString())}))).asJava(), false, channelBuilder, logContext);
        NetworkClient networkClient = new NetworkClient((Selectable)selector, new ManualMetadataUpdater((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{brokerNode}))).asJava()), ((Object)BoxesRunTime.boxToInteger((int)this.config.brokerId())).toString(), 1, 0L, 0L, -1, -1, Predef$.MODULE$.Integer2int(this.config.requestTimeoutMs()), ClientDnsLookup.DEFAULT, this.time, false, new ApiVersions(), logContext);
        Option<String> option = this.threadNamePrefix;
        if (None$.MODULE$.equals(option)) {
            string = new StringBuilder(34).append("Controller-").append(this.config.brokerId()).append("-to-broker-").append(broker.id()).append("-send-thread").toString();
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String name = (String)some.value();
            string = new StringBuilder(35).append(name).append(":Controller-").append(this.config.brokerId()).append("-to-broker-").append(broker.id()).append("-send-thread").toString();
        } else {
            throw new MatchError(option);
        }
        String threadName = string;
        Timer requestRateAndQueueTimeMetrics = this.newTimer(ControllerChannelManager$.MODULE$.RequestRateAndQueueTimeMetricName(), TimeUnit.MILLISECONDS, TimeUnit.SECONDS, (Map<String, String>)this.brokerMetricTags(broker.id()));
        RequestSendThread requestThread = new RequestSendThread(this.config.brokerId(), this.controllerContext, messageQueue, networkClient, brokerNode, this.config, this.time, requestRateAndQueueTimeMetrics, this.stateChangeLogger, threadName);
        requestThread.setDaemon(false);
        Gauge<Object> queueSizeGauge = this.newGauge(ControllerChannelManager$.MODULE$.QueueSizeMetricName(), new Gauge<Object>(null, messageQueue){
            private final LinkedBlockingQueue messageQueue$1;

            public int value() {
                return this.messageQueue$1.size();
            }
            {
                this.messageQueue$1 = messageQueue$1;
            }
        }, (Map<String, String>)this.brokerMetricTags(broker.id()));
        this.brokerStateInfo().put((Object)BoxesRunTime.boxToInteger((int)broker.id()), (Object)new ControllerBrokerStateInfo(networkClient, brokerNode, messageQueue, requestThread, queueSizeGauge, requestRateAndQueueTimeMetrics));
    }

    private scala.collection.immutable.Map<String, String> brokerMetricTags(int brokerId) {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker-id"), (Object)((Object)BoxesRunTime.boxToInteger((int)brokerId)).toString())}));
    }

    private void removeExistingBroker(ControllerBrokerStateInfo brokerState) {
        try {
            brokerState.requestSendThread().shutdown();
            brokerState.networkClient().close();
            brokerState.messageQueue().clear();
            this.removeMetric(ControllerChannelManager$.MODULE$.QueueSizeMetricName(), (Map<String, String>)this.brokerMetricTags(brokerState.brokerNode().id()));
            this.removeMetric(ControllerChannelManager$.MODULE$.RequestRateAndQueueTimeMetricName(), (Map<String, String>)this.brokerMetricTags(brokerState.brokerNode().id()));
            this.brokerStateInfo().remove((Object)BoxesRunTime.boxToInteger((int)brokerState.brokerNode().id()));
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while removing broker by the controller", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
        }
    }

    public void startRequestSendThread(int brokerId) {
        block0: {
            RequestSendThread requestThread = ((ControllerBrokerStateInfo)this.brokerStateInfo().apply((Object)BoxesRunTime.boxToInteger((int)brokerId))).requestSendThread();
            Thread.State state = requestThread.getState();
            Thread.State state2 = Thread.State.NEW;
            if (state != null ? !((Object)((Object)state)).equals((Object)state2) : state2 != null) break block0;
            requestThread.start();
        }
    }

    public ControllerChannelManager(ControllerContext controllerContext, KafkaConfig config, Time time, Metrics metrics, StateChangeLogger stateChangeLogger, Option<String> threadNamePrefix) {
        this.controllerContext = controllerContext;
        this.config = config;
        this.time = time;
        this.metrics = metrics;
        this.stateChangeLogger = stateChangeLogger;
        this.threadNamePrefix = threadNamePrefix;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.brokerStateInfo = new HashMap();
        this.kafka$controller$ControllerChannelManager$$brokerLock = new Object();
        this.logIdent_$eq(new StringBuilder(34).append("[Channel manager on controller ").append(config.brokerId()).append("]: ").toString());
        this.newGauge("TotalQueueSize", new Gauge<Object>(this){
            private final /* synthetic */ ControllerChannelManager $outer;

            public int value() {
                int n;
                Object object = this.$outer.kafka$controller$ControllerChannelManager$$brokerLock();
                synchronized (object) {
                    n = BoxesRunTime.unboxToInt((Object)this.$outer.brokerStateInfo().values().iterator().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)$anon$1.$anonfun$value$1(x$1))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                }
                return n;
            }

            public static final /* synthetic */ int $anonfun$value$1(ControllerBrokerStateInfo x$1) {
                return x$1.messageQueue().size();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1$adapted(kafka.controller.ControllerBrokerStateInfo )}, serializedLambda);
            }
        }, this.newGauge$default$3());
        controllerContext.liveBrokers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
            this.addNewBroker(broker);
            return BoxedUnit.UNIT;
        });
    }
}

