/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.common.OffsetAndMetadata;
import kafka.coordinator.group.BaseKey;
import kafka.coordinator.group.GroupMetadata;
import kafka.coordinator.group.GroupMetadataKey;
import kafka.coordinator.group.GroupMetadataManager$;
import kafka.coordinator.group.OffsetKey;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TxnKey;
import kafka.log.Log$;
import kafka.serializer.Decoder;
import kafka.tools.DumpLogSegments$;
import kafka.utils.CommandDefaultOptions;
import kafka.utils.CommandDefaultOptions$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.VerifiableProperties;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.clients.consumer.internals.PartitionAssignor;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r\rs!\u0002!B\u0011\u00031e!\u0002%B\u0011\u0003I\u0005\"\u0002)\u0002\t\u0003\t\u0006\u0002\u0003*\u0002\u0005\u0004%\t!Q*\t\rq\u000b\u0001\u0015!\u0003U\u0011\u0015i\u0016\u0001\"\u0001_\u0011\u0015\t\u0018\u0001\"\u0003s\u0011\u0015Y\u0018\u0001\"\u0003}\u0011\u0015q\u0018\u0001\"\u0003\u0000\u0011\u001d\ti%\u0001C\u0005\u0003\u001f2\u0011\"!+\u0002!\u0003\rJ!a+\t\u000f\u0005=&B\"\u0001\u00022\u001a1\u0011Q_\u0001\u0005\u0003oD!B!\u0002\r\u0005\u0003\u0005\u000b\u0011\u0002B\u0004\u0011)\u0011\u0019\u0002\u0004B\u0001B\u0003%!Q\u0003\u0005\u0007!2!\tAa\u0006\t\u000f\u0005=F\u0002\"\u0011\u0003 \u00191!\u0011F\u0001\u0005\u0005WAa\u0001U\t\u0005\u0002\t=\u0002bBAX#\u0011\u0005#1\u0007\u0004\u0007\u0005w\tAA!\u0010\t\rA#B\u0011\u0001B \u0011\u001d\u0011\u0019\u0005\u0006C\u0005\u0005\u000bBqAa\u0015\u0015\t\u0013\u0011)\u0006C\u0004\u0003\u0006R!IAa\"\t\u000f\u0005=F\u0003\"\u0011\u0003\u0018\"9!1T\u0001\u0005\n\tu\u0005b\u0002Bb\u0003\u0011%!Q\u0019\u0004\u0007\u0003?\n\u0001!!\u0019\t\rAcB\u0011AA2\u0011%\t)\u0007\bb\u0001\n\u0003\t9\u0007\u0003\u0005\u0002rq\u0001\u000b\u0011BA5\u0011%\t\u0019\b\bb\u0001\n\u0003\t9\u0007\u0003\u0005\u0002vq\u0001\u000b\u0011BA5\u0011%\t9\b\bb\u0001\n\u0003\t9\u0007\u0003\u0005\u0002zq\u0001\u000b\u0011BA5\u0011\u001d\tY\b\bC\u0001\u0003{Bq!!#\u001d\t\u0003\tY\tC\u0004\u0002\u0016r!\t!a&\t\u000f\u0005\rF\u0004\"\u0001\u0002&\u001a1!Q\\\u0001\u0001\u0005?D!b\u0019\u0015\u0003\u0002\u0003\u0006I\u0001\u001aBw\u0011\u0019\u0001\u0006\u0006\"\u0001\u0003p\"I!Q\u001f\u0015C\u0002\u0013\u0005!q\u001f\u0005\t\u0007\u000bA\u0003\u0015!\u0003\u0003z\"I1q\u0001\u0015C\u0002\u0013\u0005!q\u001f\u0005\t\u0007\u0013A\u0003\u0015!\u0003\u0003z\"I11\u0002\u0015C\u0002\u0013\u0005!q\u001f\u0005\t\u0007\u001bA\u0003\u0015!\u0003\u0003z\"I1q\u0002\u0015C\u0002\u0013\u00051\u0011\u0003\u0005\t\u00073A\u0003\u0015!\u0003\u0004\u0014!I11\u0004\u0015C\u0002\u0013\u00051Q\u0004\u0005\t\u0007OA\u0003\u0015!\u0003\u0004 !I1\u0011\u0006\u0015C\u0002\u0013\u0005!q\u001f\u0005\t\u0007WA\u0003\u0015!\u0003\u0003z\"I1Q\u0006\u0015C\u0002\u0013\u00051q\u0006\u0005\t\u0007gA\u0003\u0015!\u0003\u00042!I1Q\u0007\u0015C\u0002\u0013\u00051q\u0006\u0005\t\u0007oA\u0003\u0015!\u0003\u00042!I1\u0011\b\u0015C\u0002\u0013\u0005!q\u001f\u0005\t\u0007wA\u0003\u0015!\u0003\u0003z\"I1Q\b\u0015C\u0002\u0013\u0005!q\u001f\u0005\t\u0007\u007fA\u0003\u0015!\u0003\u0003z\"91\u0011\t\u0015\u0005\u0002\u0005\u0015\u0016a\u0004#v[BdunZ*fO6,g\u000e^:\u000b\u0005\t\u001b\u0015!\u0002;p_2\u001c(\"\u0001#\u0002\u000b-\fgm[1\u0004\u0001A\u0011q)A\u0007\u0002\u0003\nyA)^7q\u0019><7+Z4nK:$8o\u0005\u0002\u0002\u0015B\u00111JT\u0007\u0002\u0019*\tQ*A\u0003tG\u0006d\u0017-\u0003\u0002P\u0019\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001$\u0002\u001bI+5i\u0014*E?&sE)\u0012(U+\u0005!\u0006CA+[\u001b\u00051&BA,Y\u0003\u0011a\u0017M\\4\u000b\u0003e\u000bAA[1wC&\u00111L\u0016\u0002\u0007'R\u0014\u0018N\\4\u0002\u001dI+5i\u0014*E?&sE)\u0012(UA\u0005!Q.Y5o)\ty&\r\u0005\u0002LA&\u0011\u0011\r\u0014\u0002\u0005+:LG\u000fC\u0003d\u000b\u0001\u0007A-\u0001\u0003be\u001e\u001c\bcA&fO&\u0011a\r\u0014\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003Q>t!![7\u0011\u0005)dU\"A6\u000b\u00051,\u0015A\u0002\u001fs_>$h(\u0003\u0002o\u0019\u00061\u0001K]3eK\u001aL!a\u00179\u000b\u00059d\u0015\u0001\u00043v[B$\u0006P\\%oI\u0016DHCA0t\u0011\u0015!h\u00011\u0001v\u0003\u00111\u0017\u000e\\3\u0011\u0005YLX\"A<\u000b\u0005aD\u0016AA5p\u0013\tQxO\u0001\u0003GS2,\u0017A\u00063v[B\u0004&o\u001c3vG\u0016\u0014\u0018\nZ*oCB\u001c\bn\u001c;\u0015\u0005}k\b\"\u0002;\b\u0001\u0004)\u0018!\u00033v[BLe\u000eZ3y)-y\u0016\u0011AA\u0002\u0003\u001b\t\t\"a\u0011\t\u000bQD\u0001\u0019A;\t\u000f\u0005\u0015\u0001\u00021\u0001\u0002\b\u0005y\u0011N\u001c3fqN\u000bg.\u001b;z\u001f:d\u0017\u0010E\u0002L\u0003\u0013I1!a\u0003M\u0005\u001d\u0011un\u001c7fC:Dq!a\u0004\t\u0001\u0004\t9!\u0001\u0006wKJLg-_(oYfDq!a\u0005\t\u0001\u0004\t)\"\u0001\u000enSNl\u0015\r^2iKN4uN]%oI\u0016Dh)\u001b7fg6\u000b\u0007\u000fE\u0004\u0002\u0018\u0005\u0005r-!\n\u000e\u0005\u0005e!\u0002BA\u000e\u0003;\tq!\\;uC\ndWMC\u0002\u0002 1\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019#!\u0007\u0003\u000f!\u000b7\u000f['baB1\u0011qEA\u0019\u0003oqA!!\u000b\u0002.9\u0019!.a\u000b\n\u00035K1!a\fM\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\r\u00026\t!A*[:u\u0015\r\ty\u0003\u0014\t\b\u0017\u0006e\u0012QHA\u001f\u0013\r\tY\u0004\u0014\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007-\u000by$C\u0002\u0002B1\u0013A\u0001T8oO\"9\u0011Q\t\u0005A\u0002\u0005\u001d\u0013AD7bq6+7o]1hKNK'0\u001a\t\u0004\u0017\u0006%\u0013bAA&\u0019\n\u0019\u0011J\u001c;\u0002\u001b\u0011,X\u000e\u001d+j[\u0016Le\u000eZ3y)-y\u0016\u0011KA*\u0003+\n9&a*\t\u000bQL\u0001\u0019A;\t\u000f\u0005\u0015\u0011\u00021\u0001\u0002\b!9\u0011qB\u0005A\u0002\u0005\u001d\u0001bBA-\u0013\u0001\u0007\u00111L\u0001\u0014i&lW-\u00138eKb$U/\u001c9FeJ|'o\u001d\t\u0004\u0003;bR\"A\u0001\u0003'QKW.Z%oI\u0016DH)^7q\u000bJ\u0014xN]:\u0014\u0005qQECAA.\u0003yi\u0017n]'bi\u000eDWm\u001d$peRKW.Z%oI\u0016Dh)\u001b7fg6\u000b\u0007/\u0006\u0002\u0002jA9\u0011qCA\u0011O\u0006-\u0004CBA\f\u0003[\n9$\u0003\u0003\u0002p\u0005e!aC!se\u0006L()\u001e4gKJ\fq$\\5t\u001b\u0006$8\r[3t\r>\u0014H+[7f\u0013:$W\r\u001f$jY\u0016\u001cX*\u00199!\u0003MyW\u000f^(g\u001fJ$WM\u001d+j[\u0016\u001cH/Y7q\u0003QyW\u000f^(g\u001fJ$WM\u001d+j[\u0016\u001cH/Y7qA\u0005)2\u000f[1mY><xJ\u001a4tKRtu\u000e\u001e$pk:$\u0017AF:iC2dwn^(gMN,GOT8u\r>,h\u000e\u001a\u0011\u0002/I,7m\u001c:e\u001b&\u001cX.\u0019;dQRKW.Z%oI\u0016DHcB0\u0002\u0000\u0005\u0005\u0015Q\u0011\u0005\u0006i\u0012\u0002\r!\u001e\u0005\b\u0003\u0007#\u0003\u0019AA\u001f\u00039Ig\u000eZ3y)&lWm\u001d;b[BDq!a\"%\u0001\u0004\ti$\u0001\u0007m_\u001e$\u0016.\\3ti\u0006l\u0007/\u0001\u0010sK\u000e|'\u000fZ(vi>3wJ\u001d3fe&sG-\u001a=US6,7\u000f^1naR9q,!$\u0002\u0010\u0006E\u0005\"\u0002;&\u0001\u0004)\bbBABK\u0001\u0007\u0011Q\b\u0005\b\u0003'+\u0003\u0019AA\u001f\u0003I\u0001(/\u001a<J]\u0012,\u0007\u0010V5nKN$\u0018-\u001c9\u00027I,7m\u001c:e'\"\fG\u000e\\8x\u001f\u001a47/\u001a;O_R4u.\u001e8e)\u001dy\u0016\u0011TAN\u0003?CQ\u0001\u001e\u0014A\u0002UDq!!('\u0001\u0004\ti$A\u0006j]\u0012,\u0007p\u00144gg\u0016$\bbBAQM\u0001\u0007\u0011QH\u0001\nY><wJ\u001a4tKR\f1\u0002\u001d:j]R,%O]8sgR\tq\fC\u0004\u0002F%\u0001\r!a\u0012\u0003\u001b5+7o]1hKB\u000b'o]3s+\u0019\ti+a0\u0002VN\u0011!BS\u0001\u0006a\u0006\u00148/\u001a\u000b\u0005\u0003g\u000bI\u000eE\u0004L\u0003s\t),!5\u0011\u000b-\u000b9,a/\n\u0007\u0005eFJ\u0001\u0004PaRLwN\u001c\t\u0005\u0003{\u000by\f\u0004\u0001\u0005\u000f\u0005\u0005'B1\u0001\u0002D\n\t1*\u0005\u0003\u0002F\u0006-\u0007cA&\u0002H&\u0019\u0011\u0011\u001a'\u0003\u000f9{G\u000f[5oOB\u00191*!4\n\u0007\u0005=GJA\u0002B]f\u0004RaSA\\\u0003'\u0004B!!0\u0002V\u00129\u0011q\u001b\u0006C\u0002\u0005\r'!\u0001,\t\u000f\u0005m7\u00021\u0001\u0002^\u00061!/Z2pe\u0012\u0004B!a8\u0002r6\u0011\u0011\u0011\u001d\u0006\u0005\u00037\f\u0019O\u0003\u0003\u0002f\u0006\u001d\u0018AB2p[6|gNC\u0002E\u0003STA!a;\u0002n\u00061\u0011\r]1dQ\u0016T!!a<\u0002\u0007=\u0014x-\u0003\u0003\u0002t\u0006\u0005(A\u0002*fG>\u0014HM\u0001\u000bEK\u000e|G-\u001a:NKN\u001c\u0018mZ3QCJ\u001cXM]\u000b\u0007\u0003s\fyPa\u0001\u0014\t1Q\u00151 \t\b\u0003;R\u0011Q B\u0001!\u0011\ti,a@\u0005\u000f\u0005\u0005GB1\u0001\u0002DB!\u0011Q\u0018B\u0002\t\u001d\t9\u000e\u0004b\u0001\u0003\u0007\f!b[3z\t\u0016\u001cw\u000eZ3s!\u0019\u0011IAa\u0004\u0002~6\u0011!1\u0002\u0006\u0004\u0005\u001b\u0019\u0015AC:fe&\fG.\u001b>fe&!!\u0011\u0003B\u0006\u0005\u001d!UmY8eKJ\fAB^1mk\u0016$UmY8eKJ\u0004bA!\u0003\u0003\u0010\t\u0005AC\u0002B\r\u00057\u0011i\u0002E\u0004\u0002^1\tiP!\u0001\t\u000f\t\u0015q\u00021\u0001\u0003\b!9!1C\bA\u0002\tUA\u0003\u0002B\u0011\u0005O\u0001raSA\u001d\u0005G\u0011)\u0003E\u0003L\u0003o\u000bi\u0010E\u0003L\u0003o\u0013\t\u0001C\u0004\u0002\\B\u0001\r!!8\u00037Q\u0013\u0018M\\:bGRLwN\u001c'pO6+7o]1hKB\u000b'o]3s'\u0011\t\"J!\f\u0011\u000b\u0005u#bZ4\u0015\u0005\tE\u0002cAA/#Q!!Q\u0007B\u001d!\u001dY\u0015\u0011\bB\u001c\u0005o\u0001BaSA\\O\"9\u00111\\\nA\u0002\u0005u'\u0001F(gMN,Go]'fgN\fw-\u001a)beN,'o\u0005\u0003\u0015\u0015\n5BC\u0001B!!\r\ti\u0006F\u0001\u0004Q\u0016DHcA4\u0003H!9!\u0011\n\fA\u0002\t-\u0013!\u00022zi\u0016\u001c\b\u0003B&f\u0005\u001b\u00022a\u0013B(\u0013\r\u0011\t\u0006\u0014\u0002\u0005\u0005f$X-\u0001\u0007qCJ\u001cXm\u00144gg\u0016$8\u000f\u0006\u0004\u0003X\t\u0005$Q\u000f\t\b\u0017\u0006e\"\u0011\fB0!\u0011Y%1L4\n\u0007\tuCJ\u0001\u0003T_6,\u0007\u0003B&\u0003\\QCqAa\u0019\u0018\u0001\u0004\u0011)'A\u0005pM\u001a\u001cX\r^&fsB!!q\rB9\u001b\t\u0011IG\u0003\u0003\u0003l\t5\u0014!B4s_V\u0004(b\u0001B8\u0007\u0006Y1m\\8sI&t\u0017\r^8s\u0013\u0011\u0011\u0019H!\u001b\u0003\u0013=3gm]3u\u0017\u0016L\bb\u0002B</\u0001\u0007!\u0011P\u0001\ba\u0006LHn\\1e!\u0011\u0011YH!!\u000e\u0005\tu$b\u0001B@1\u0006\u0019a.[8\n\t\t\r%Q\u0010\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\u0018A\u00059beN,wI]8va6+G/\u00193bi\u0006$bA!#\u0003\f\nU\u0005cB&\u0002:\te#\u0011\f\u0005\b\u0005\u001bC\u0002\u0019\u0001BH\u0003A9'o\\;q\u001b\u0016$\u0018\rZ1uC.+\u0017\u0010\u0005\u0003\u0003h\tE\u0015\u0002\u0002BJ\u0005S\u0012\u0001c\u0012:pkBlU\r^1eCR\f7*Z=\t\u000f\t]\u0004\u00041\u0001\u0003zQ!!Q\u0007BM\u0011\u001d\tY.\u0007a\u0001\u0003;\fq\u0001Z;na2{w\rF\u0007`\u0005?\u0013\tK!*\u0003*\n5&q\u0016\u0005\u0006ij\u0001\r!\u001e\u0005\b\u0005GS\u0002\u0019AA\u0004\u00035\u0001(/\u001b8u\u0007>tG/\u001a8ug\"9!q\u0015\u000eA\u0002\u0005U\u0011!\t8p]\u000e{gn]3dkRLg/\u001a)bSJ\u001chi\u001c:M_\u001e4\u0015\u000e\\3t\u001b\u0006\u0004\bb\u0002BV5\u0001\u0007\u0011qA\u0001\u0010SN$U-\u001a9Ji\u0016\u0014\u0018\r^5p]\"9\u0011Q\t\u000eA\u0002\u0005\u001d\u0003b\u0002BY5\u0001\u0007!1W\u0001\u0007a\u0006\u00148/\u001a:1\r\tU&\u0011\u0018B`!\u001d\tiF\u0003B\\\u0005{\u0003B!!0\u0003:\u0012a!1\u0018BX\u0003\u0003\u0005\tQ!\u0001\u0002D\n\u0019q\fJ\u0019\u0011\t\u0005u&q\u0018\u0003\r\u0005\u0003\u0014y+!A\u0001\u0002\u000b\u0005\u00111\u0019\u0002\u0004?\u0012\u0012\u0014a\u00049sS:$()\u0019;dQ2+g/\u001a7\u0015\u000b}\u00139M!7\t\u000f\t%7\u00041\u0001\u0003L\u0006)!-\u0019;dQB!!Q\u001aBj\u001d\u0011\tyNa4\n\t\tE\u0017\u0011]\u0001\u0013\r&dW\rT8h\u0013:\u0004X\u000f^*ue\u0016\fW.\u0003\u0003\u0003V\n]'A\u0006$jY\u0016\u001c\u0005.\u00198oK2\u0014VmY8sI\n\u000bGo\u00195\u000b\t\tE\u0017\u0011\u001d\u0005\b\u00057\\\u0002\u0019AA\u001f\u0003E\t7mY;nk2\fG/\u001b<f\u0005f$Xm\u001d\u0002\u0017\tVl\u0007\u000fT8h'\u0016<W.\u001a8ug>\u0003H/[8ogN\u0019\u0001F!9\u0011\t\t\r(\u0011^\u0007\u0003\u0005KT1Aa:D\u0003\u0015)H/\u001b7t\u0013\u0011\u0011YO!:\u0003+\r{W.\\1oI\u0012+g-Y;mi>\u0003H/[8og&\u00191M!;\u0015\t\tE(1\u001f\t\u0004\u0003;B\u0003\"B2+\u0001\u0004!\u0017\u0001\u00039sS:$x\n\u001d;\u0016\u0005\te\b\u0003\u0002B~\u0007\u0003i!A!@\u000b\u0005\t}\u0018A\u00036paR\u001c\u0018.\u001c9mK&!11\u0001B\u007f\u0005Ey\u0005\u000f^5p]N\u0003Xm\u0019\"vS2$WM]\u0001\naJLg\u000e^(qi\u0002\n\u0011B^3sS\u001aLx\n\u001d;\u0002\u0015Y,'/\u001b4z\u001fB$\b%\u0001\bj]\u0012,\u0007pU1oSRLx\n\u001d;\u0002\u001f%tG-\u001a=TC:LG/_(qi\u0002\n\u0001BZ5mKN|\u0005\u000f^\u000b\u0003\u0007'\u0001RAa?\u0004\u0016\u001dLAaa\u0006\u0003~\nY\u0012I]4v[\u0016tG/Q2dKB$\u0018N\\4PaRLwN\\*qK\u000e\f\u0011BZ5mKN|\u0005\u000f\u001e\u0011\u0002#5\f\u00070T3tg\u0006<WmU5{K>\u0003H/\u0006\u0002\u0004 A1!1`B\u000b\u0007C\u00012!VB\u0012\u0013\r\u0019)C\u0016\u0002\b\u0013:$XmZ3s\u0003Ii\u0017\r_'fgN\fw-Z*ju\u0016|\u0005\u000f\u001e\u0011\u0002!\u0011,W\r]%uKJ\fG/[8o\u001fB$\u0018!\u00053fKBLE/\u001a:bi&|gn\u00149uA\u0005ya/\u00197vK\u0012+7m\u001c3fe>\u0003H/\u0006\u0002\u00042A)!1`B\u000b)\u0006\u0001b/\u00197vK\u0012+7m\u001c3fe>\u0003H\u000fI\u0001\u000eW\u0016LH)Z2pI\u0016\u0014x\n\u001d;\u0002\u001d-,\u0017\u0010R3d_\u0012,'o\u00149uA\u0005QqN\u001a4tKR\u001cx\n\u001d;\u0002\u0017=4gm]3ug>\u0003H\u000fI\u0001\u0012iJ\fgn]1di&|g\u000eT8h\u001fB$\u0018A\u0005;sC:\u001c\u0018m\u0019;j_:dunZ(qi\u0002\n\u0011b\u00195fG.\f%oZ:")
public final class DumpLogSegments {
    public static void main(String[] stringArray) {
        DumpLogSegments$.MODULE$.main(stringArray);
    }

    public static class DecoderMessageParser<K, V>
    implements MessageParser<K, V> {
        private final Decoder<K> keyDecoder;
        private final Decoder<V> valueDecoder;

        @Override
        public Tuple2<Option<K>, Option<V>> parse(Record record) {
            Tuple2 tuple2;
            if (!record.hasValue()) {
                tuple2 = new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
            } else {
                None$ key = record.hasKey() ? new Some(this.keyDecoder.fromBytes(Utils.readBytes(record.key()))) : None$.MODULE$;
                Some payload = new Some(this.valueDecoder.fromBytes(Utils.readBytes(record.value())));
                tuple2 = new Tuple2((Object)key, (Object)payload);
            }
            return tuple2;
        }

        public DecoderMessageParser(Decoder<K> keyDecoder, Decoder<V> valueDecoder) {
            this.keyDecoder = keyDecoder;
            this.valueDecoder = valueDecoder;
        }
    }

    public static class DumpLogSegmentsOptions
    extends CommandDefaultOptions {
        private final OptionSpecBuilder printOpt = this.parser().accepts("print-data-log", "if set, printing the messages content when dumping data logs. Automatically set if any decoder option is specified.");
        private final OptionSpecBuilder verifyOpt = this.parser().accepts("verify-index-only", "if set, just verify the index log without printing its content.");
        private final OptionSpecBuilder indexSanityOpt = this.parser().accepts("index-sanity-check", "if set, just checks the index sanity without printing its content. This is the same check that is executed on broker startup to determine if an index needs rebuilding or not.");
        private final ArgumentAcceptingOptionSpec<String> filesOpt = this.parser().accepts("files", "REQUIRED: The comma separated list of data and index log files to be dumped.").withRequiredArg().describedAs("file1, file2, ...").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<Integer> maxMessageSizeOpt = this.parser().accepts("max-message-size", "Size of largest message.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(0x500000), (Integer[])((Object[])new Integer[0]));
        private final OptionSpecBuilder deepIterationOpt = this.parser().accepts("deep-iteration", "if set, uses deep instead of shallow iteration. Automatically set if print-data-log is enabled.");
        private final ArgumentAcceptingOptionSpec<String> valueDecoderOpt = this.parser().accepts("value-decoder-class", "if set, used to deserialize the messages. This class should implement kafka.serializer.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo("kafka.serializer.StringDecoder", (String[])((Object[])new String[0]));
        private final ArgumentAcceptingOptionSpec<String> keyDecoderOpt = this.parser().accepts("key-decoder-class", "if set, used to deserialize the keys. This class should implement kafka.serializer.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo("kafka.serializer.StringDecoder", (String[])((Object[])new String[0]));
        private final OptionSpecBuilder offsetsOpt = this.parser().accepts("offsets-decoder", "if set, log data will be parsed as offset data from the __consumer_offsets topic.");
        private final OptionSpecBuilder transactionLogOpt = this.parser().accepts("transaction-log-decoder", "if set, log data will be parsed as transaction metadata from the __transaction_state topic.");

        public OptionSpecBuilder printOpt() {
            return this.printOpt;
        }

        public OptionSpecBuilder verifyOpt() {
            return this.verifyOpt;
        }

        public OptionSpecBuilder indexSanityOpt() {
            return this.indexSanityOpt;
        }

        public ArgumentAcceptingOptionSpec<String> filesOpt() {
            return this.filesOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> maxMessageSizeOpt() {
            return this.maxMessageSizeOpt;
        }

        public OptionSpecBuilder deepIterationOpt() {
            return this.deepIterationOpt;
        }

        public ArgumentAcceptingOptionSpec<String> valueDecoderOpt() {
            return this.valueDecoderOpt;
        }

        public ArgumentAcceptingOptionSpec<String> keyDecoderOpt() {
            return this.keyDecoderOpt;
        }

        public OptionSpecBuilder offsetsOpt() {
            return this.offsetsOpt;
        }

        public OptionSpecBuilder transactionLogOpt() {
            return this.transactionLogOpt;
        }

        public void checkArgs() {
            MessageParser<String, String> messageParser;
            boolean isDeepIteration;
            CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.filesOpt()}));
            boolean printDataLog = this.options().has(this.printOpt()) || this.options().has(this.offsetsOpt()) || this.options().has(this.transactionLogOpt()) || this.options().has(this.valueDecoderOpt()) || this.options().has(this.keyDecoderOpt());
            boolean verifyOnly = this.options().has(this.verifyOpt());
            boolean indexSanityOnly = this.options().has(this.indexSanityOpt());
            String[] files = this.options().valueOf(this.filesOpt()).split(",");
            int maxMessageSize = this.options().valueOf(this.maxMessageSizeOpt());
            boolean bl = isDeepIteration = this.options().has(this.deepIterationOpt()) || printDataLog;
            if (this.options().has(this.offsetsOpt())) {
                messageParser = new OffsetsMessageParser();
            } else if (this.options().has(this.transactionLogOpt())) {
                messageParser = new TransactionLogMessageParser();
            } else {
                Decoder valueDecoder = (Decoder)CoreUtils$.MODULE$.createObject(this.options().valueOf(this.valueDecoderOpt()), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new VerifiableProperties()}));
                Decoder keyDecoder = (Decoder)CoreUtils$.MODULE$.createObject(this.options().valueOf(this.keyDecoderOpt()), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new VerifiableProperties()}));
                messageParser = new DecoderMessageParser(keyDecoder, valueDecoder);
            }
            OffsetsMessageParser messageParser2 = messageParser;
            HashMap misMatchesForIndexFilesMap = new HashMap();
            TimeIndexDumpErrors timeIndexDumpErrors = new TimeIndexDumpErrors();
            HashMap nonConsecutivePairsForLogFilesMap = new HashMap();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).foreach((Function1 & Serializable & scala.Serializable)arg -> {
                DumpLogSegmentsOptions.$anonfun$checkArgs$1(printDataLog, nonConsecutivePairsForLogFilesMap, isDeepIteration, maxMessageSize, messageParser2, indexSanityOnly, verifyOnly, misMatchesForIndexFilesMap, timeIndexDumpErrors, arg);
                return BoxedUnit.UNIT;
            });
            misMatchesForIndexFilesMap.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DumpLogSegmentsOptions.$anonfun$checkArgs$2(x0$1);
                return BoxedUnit.UNIT;
            });
            timeIndexDumpErrors.printErrors();
            nonConsecutivePairsForLogFilesMap.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                DumpLogSegmentsOptions.$anonfun$checkArgs$4(x0$2);
                return BoxedUnit.UNIT;
            });
        }

        public static final /* synthetic */ void $anonfun$checkArgs$1(boolean printDataLog$1, HashMap nonConsecutivePairsForLogFilesMap$2, boolean isDeepIteration$2, int maxMessageSize$2, MessageParser messageParser$1, boolean indexSanityOnly$1, boolean verifyOnly$3, HashMap misMatchesForIndexFilesMap$2, TimeIndexDumpErrors timeIndexDumpErrors$2, String arg) {
            String suffix;
            File file = new File(arg);
            Predef$.MODULE$.println((Object)new StringBuilder(8).append("Dumping ").append(file).toString());
            String filename = file.getName();
            String string = suffix = filename.substring(filename.lastIndexOf("."));
            String string2 = Log$.MODULE$.LogFileSuffix();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$dumpLog(file, printDataLog$1, (HashMap<String, List<Tuple2<Object, Object>>>)nonConsecutivePairsForLogFilesMap$2, isDeepIteration$2, maxMessageSize$2, messageParser$1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                String string4 = Log$.MODULE$.IndexFileSuffix();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$dumpIndex(file, indexSanityOnly$1, verifyOnly$3, (HashMap<String, List<Tuple2<Object, Object>>>)misMatchesForIndexFilesMap$2, maxMessageSize$2);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    String string6 = Log$.MODULE$.TimeIndexFileSuffix();
                    String string7 = string;
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$dumpTimeIndex(file, indexSanityOnly$1, verifyOnly$3, timeIndexDumpErrors$2, maxMessageSize$2);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        String string8 = Log$.MODULE$.ProducerSnapshotFileSuffix();
                        String string9 = string;
                        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                            DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$dumpProducerIdSnapshot(file);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            String string10 = Log$.MODULE$.TxnIndexFileSuffix();
                            String string11 = string;
                            if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                                DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$dumpTxnIndex(file);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                System.err.println(new StringBuilder(22).append("Ignoring unknown file ").append(file).toString());
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                        }
                    }
                }
            }
        }

        public static final /* synthetic */ void $anonfun$checkArgs$2(Tuple2 x0$1) {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String fileName = (String)tuple2._1();
            List listOfMismatches = (List)tuple2._2();
            System.err.println(new StringBuilder(15).append("Mismatches in :").append(fileName).toString());
            listOfMismatches.foreach((Function1 & Serializable & scala.Serializable)m -> {
                System.err.println(new StringOps(Predef$.MODULE$.augmentString("  Index offset: %d, log offset: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }

        public static final /* synthetic */ void $anonfun$checkArgs$4(Tuple2 x0$2) {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String fileName = (String)tuple2._1();
            List listOfNonConsecutivePairs = (List)tuple2._2();
            System.err.println(new StringBuilder(28).append("Non-consecutive offsets in :").append(fileName).toString());
            listOfNonConsecutivePairs.foreach((Function1 & Serializable & scala.Serializable)m -> {
                System.err.println(new StringOps(Predef$.MODULE$.augmentString("  %d is followed by %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }

        public DumpLogSegmentsOptions(String[] args) {
            super(args, CommandDefaultOptions$.MODULE$.$lessinit$greater$default$2());
            this.options_$eq(this.parser().parse(super.args()));
        }
    }

    public static interface MessageParser<K, V> {
        public Tuple2<Option<K>, Option<V>> parse(Record var1);
    }

    public static class OffsetsMessageParser
    implements MessageParser<String, String> {
        private String hex(byte[] bytes) {
            return new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).isEmpty() ? "" : new StringOps(Predef$.MODULE$.augmentString("%X")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.BigInt().apply(1, bytes)}));
        }

        private Tuple2<Some<String>, Some<String>> parseOffsets(OffsetKey offsetKey, ByteBuffer payload) {
            String group = offsetKey.key().group();
            TopicPartition topicPartition = offsetKey.key().topicPartition();
            OffsetAndMetadata offset = GroupMetadataManager$.MODULE$.readOffsetMessageValue(payload);
            String keyString = new StringBuilder(10).append("offset::").append(group).append(":").append(topicPartition.topic()).append(":").append(topicPartition.partition()).toString();
            String valueString = offset.metadata().isEmpty() ? String.valueOf(offset.offset()) : new StringBuilder(1).append(offset.offset()).append(":").append(offset.metadata()).toString();
            return new Tuple2((Object)new Some((Object)keyString), (Object)new Some((Object)valueString));
        }

        private Tuple2<Some<String>, Some<String>> parseGroupMetadata(GroupMetadataKey groupMetadataKey, ByteBuffer payload) {
            String groupId = groupMetadataKey.key();
            GroupMetadata group = GroupMetadataManager$.MODULE$.readGroupMessageValue(groupId, payload, Time.SYSTEM);
            String protocolType = (String)group.protocolType().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            String assignment = ((TraversableOnce)group.allMemberMetadata().map((Function1 & Serializable & scala.Serializable)member -> {
                PartitionAssignor.Assignment partitionAssignment;
                String userData;
                String string = protocolType;
                String string2 = "consumer";
                return !(string != null ? !string.equals(string2) : string2 != null) ? ((userData = this.hex(Utils.toArray((partitionAssignment = ConsumerProtocol.deserializeAssignment(ByteBuffer.wrap(member.assignment()))).userData()))).isEmpty() ? new StringBuilder(1).append(member.memberId()).append("=").append(partitionAssignment.partitions()).toString() : new StringBuilder(2).append(member.memberId()).append("=").append(partitionAssignment.partitions()).append(":").append(userData).toString()) : new StringBuilder(1).append(member.memberId()).append("=").append(this.hex(member.assignment())).toString();
            }, List$.MODULE$.canBuildFrom())).mkString("{", ",", "}");
            String keyString = Json$.MODULE$.encodeAsString(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata"), (Object)groupId)}))).asJava());
            String valueString = Json$.MODULE$.encodeAsString(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"protocolType"), (Object)protocolType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"protocol"), (Object)group.protocolOrNull()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"generationId"), (Object)BoxesRunTime.boxToInteger((int)group.generationId())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"assignment"), (Object)assignment)}))).asJava());
            return new Tuple2((Object)new Some((Object)keyString), (Object)new Some((Object)valueString));
        }

        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record) {
            Tuple2<Some<String>, Some<String>> tuple2;
            if (!record.hasValue()) {
                tuple2 = new Tuple2<Some<String>, Some<String>>((Object)None$.MODULE$, (Object)None$.MODULE$);
            } else {
                Tuple2<Some<String>, Some<String>> tuple22;
                if (!record.hasKey()) {
                    throw new KafkaException("Failed to decode message using offset topic decoder (message had a missing key)");
                }
                BaseKey baseKey = GroupMetadataManager$.MODULE$.readMessageKey(record.key());
                if (baseKey instanceof OffsetKey) {
                    OffsetKey offsetKey = (OffsetKey)baseKey;
                    tuple22 = this.parseOffsets(offsetKey, record.value());
                } else if (baseKey instanceof GroupMetadataKey) {
                    GroupMetadataKey groupMetadataKey = (GroupMetadataKey)baseKey;
                    tuple22 = this.parseGroupMetadata(groupMetadataKey, record.value());
                } else {
                    throw new KafkaException("Failed to decode message using offset topic decoder (message had an invalid key)");
                }
                tuple2 = tuple22;
            }
            return tuple2;
        }
    }

    public static class TimeIndexDumpErrors {
        private final HashMap<String, ArrayBuffer<Tuple2<Object, Object>>> misMatchesForTimeIndexFilesMap = new HashMap();
        private final HashMap<String, ArrayBuffer<Tuple2<Object, Object>>> outOfOrderTimestamp = new HashMap();
        private final HashMap<String, ArrayBuffer<Tuple2<Object, Object>>> shallowOffsetNotFound = new HashMap();

        public HashMap<String, ArrayBuffer<Tuple2<Object, Object>>> misMatchesForTimeIndexFilesMap() {
            return this.misMatchesForTimeIndexFilesMap;
        }

        public HashMap<String, ArrayBuffer<Tuple2<Object, Object>>> outOfOrderTimestamp() {
            return this.outOfOrderTimestamp;
        }

        public HashMap<String, ArrayBuffer<Tuple2<Object, Object>>> shallowOffsetNotFound() {
            return this.shallowOffsetNotFound;
        }

        public void recordMismatchTimeIndex(File file, long indexTimestamp, long logTimestamp) {
            ArrayBuffer misMatchesSeq = (ArrayBuffer)this.misMatchesForTimeIndexFilesMap().getOrElse((Object)file.getAbsolutePath(), (Function0 & Serializable & scala.Serializable)() -> new ArrayBuffer());
            Object object = misMatchesSeq.isEmpty() ? this.misMatchesForTimeIndexFilesMap().put((Object)file.getAbsolutePath(), (Object)misMatchesSeq) : BoxedUnit.UNIT;
            misMatchesSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexTimestamp, logTimestamp));
        }

        public void recordOutOfOrderIndexTimestamp(File file, long indexTimestamp, long prevIndexTimestamp) {
            ArrayBuffer outOfOrderSeq = (ArrayBuffer)this.outOfOrderTimestamp().getOrElse((Object)file.getAbsolutePath(), (Function0 & Serializable & scala.Serializable)() -> new ArrayBuffer());
            Object object = outOfOrderSeq.isEmpty() ? this.outOfOrderTimestamp().put((Object)file.getAbsolutePath(), (Object)outOfOrderSeq) : BoxedUnit.UNIT;
            outOfOrderSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexTimestamp, prevIndexTimestamp));
        }

        public void recordShallowOffsetNotFound(File file, long indexOffset, long logOffset) {
            ArrayBuffer shallowOffsetNotFoundSeq = (ArrayBuffer)this.shallowOffsetNotFound().getOrElse((Object)file.getAbsolutePath(), (Function0 & Serializable & scala.Serializable)() -> new ArrayBuffer());
            Object object = shallowOffsetNotFoundSeq.isEmpty() ? this.shallowOffsetNotFound().put((Object)file.getAbsolutePath(), (Object)shallowOffsetNotFoundSeq) : BoxedUnit.UNIT;
            shallowOffsetNotFoundSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexOffset, logOffset));
        }

        public void printErrors() {
            this.misMatchesForTimeIndexFilesMap().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                TimeIndexDumpErrors.$anonfun$printErrors$1(x0$1);
                return BoxedUnit.UNIT;
            });
            this.outOfOrderTimestamp().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                TimeIndexDumpErrors.$anonfun$printErrors$3(x0$2);
                return BoxedUnit.UNIT;
            });
            this.shallowOffsetNotFound().values().foreach((Function1 & Serializable & scala.Serializable)listOfShallowOffsetNotFound -> {
                TimeIndexDumpErrors.$anonfun$printErrors$5(listOfShallowOffsetNotFound);
                return BoxedUnit.UNIT;
            });
        }

        public static final /* synthetic */ void $anonfun$printErrors$1(Tuple2 x0$1) {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String fileName = (String)tuple2._1();
            ArrayBuffer listOfMismatches = (ArrayBuffer)tuple2._2();
            System.err.println(new StringBuilder(29).append("Found timestamp mismatch in :").append(fileName).toString());
            listOfMismatches.foreach((Function1 & Serializable & scala.Serializable)m -> {
                System.err.println(new StringOps(Predef$.MODULE$.augmentString("  Index timestamp: %d, log timestamp: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }

        public static final /* synthetic */ void $anonfun$printErrors$3(Tuple2 x0$2) {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String fileName = (String)tuple2._1();
            ArrayBuffer outOfOrderTimestamps = (ArrayBuffer)tuple2._2();
            System.err.println(new StringBuilder(33).append("Found out of order timestamp in :").append(fileName).toString());
            outOfOrderTimestamps.foreach((Function1 & Serializable & scala.Serializable)m -> {
                System.err.println(new StringOps(Predef$.MODULE$.augmentString("  Index timestamp: %d, Previously indexed timestamp: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }

        public static final /* synthetic */ void $anonfun$printErrors$6(Tuple2 x0$3) {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long indexedOffset = tuple2._1$mcJ$sp();
            long logOffset = tuple2._2$mcJ$sp();
            System.err.println(new StringBuilder(36).append("Indexed offset: ").append(indexedOffset).append(", found log offset: ").append(logOffset).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }

        public static final /* synthetic */ void $anonfun$printErrors$5(ArrayBuffer listOfShallowOffsetNotFound) {
            System.err.println("The following indexed offsets are not found in the log.");
            listOfShallowOffsetNotFound.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                TimeIndexDumpErrors.$anonfun$printErrors$6(x0$3);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static class TransactionLogMessageParser
    implements MessageParser<String, String> {
        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record) {
            TxnKey txnKey = TransactionLog$.MODULE$.readTxnRecordKey(record.key());
            TransactionMetadata txnMetadata = TransactionLog$.MODULE$.readTxnRecordValue(txnKey.transactionalId(), record.value());
            String keyString = new StringBuilder(16).append("transactionalId=").append(txnKey.transactionalId()).toString();
            String valueString = new StringBuilder(12).append("producerId:").append(txnMetadata.producerId()).append(",").append(new StringBuilder(15).append("producerEpoch:").append(txnMetadata.producerEpoch()).append(",").toString()).append(new StringBuilder(7).append("state=").append(txnMetadata.state()).append(",").toString()).append(new StringBuilder(12).append("partitions=").append(txnMetadata.topicPartitions()).append(",").toString()).append(new StringBuilder(24).append("txnLastUpdateTimestamp=").append(txnMetadata.txnLastUpdateTimestamp()).append(",").toString()).append(new StringBuilder(13).append("txnTimeoutMs=").append(txnMetadata.txnTimeoutMs()).toString()).toString();
            return new Tuple2((Object)new Some((Object)keyString), (Object)new Some((Object)valueString));
        }
    }
}

