/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.ToolsUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class GetOffsetShell$ {
    public static GetOffsetShell$ MODULE$;

    static {
        new GetOffsetShell$();
    }

    public void main(String[] args) {
        Map map;
        Seq p2;
        OptionParser parser = new OptionParser(false);
        ArgumentAcceptingOptionSpec<String> brokerListOpt = parser.accepts("broker-list", "REQUIRED: The list of hostname and port of the server to connect to.").withRequiredArg().describedAs("hostname:port,...,hostname:port").ofType(String.class);
        ArgumentAcceptingOptionSpec<String> topicOpt = parser.accepts("topic", "REQUIRED: The topic to get offset from.").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec<String> partitionOpt = parser.accepts("partitions", "comma separated list of partition ids. If not specified, it will find offsets for all partitions").withRequiredArg().describedAs("partition ids").ofType(String.class).defaultsTo("", (String[])((Object[])new String[0]));
        ArgumentAcceptingOptionSpec<Long> timeOpt = parser.accepts("time", "timestamp of the offsets before that").withRequiredArg().describedAs("timestamp/-1(latest)/-2(earliest)").ofType(Long.class).defaultsTo(Predef$.MODULE$.long2Long(-1L), (Long[])((Object[])new Long[0]));
        parser.accepts("offsets", "DEPRECATED AND IGNORED: number of offsets returned").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(1), (Integer[])((Object[])new Integer[0]));
        parser.accepts("max-wait-ms", "DEPRECATED AND IGNORED: The max amount of time each fetch request waits.").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(1000), (Integer[])((Object[])new Integer[0]));
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "An interactive shell for getting topic offsets.");
        }
        OptionSet options = parser.parse(args);
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{brokerListOpt, topicOpt}));
        String clientId = "GetOffsetShell";
        String brokerList = options.valueOf(brokerListOpt);
        ToolsUtils$.MODULE$.validatePortOrDie(parser, brokerList);
        String topic = options.valueOf(topicOpt);
        String partitionsString = options.valueOf(partitionOpt);
        Set partitionIdsRequested = partitionsString.isEmpty() ? Predef$.MODULE$.Set().empty() : new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionsString.split(","))).map((Function1 & Serializable & scala.Serializable)partitionString -> BoxesRunTime.boxToInteger((int)GetOffsetShell$.$anonfun$main$1(partitionsString, partitionString)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).toSet();
        long listOffsetsTimestamp = options.valueOf(timeOpt);
        Properties config = new Properties();
        config.setProperty("bootstrap.servers", brokerList);
        config.setProperty("client.id", clientId);
        KafkaConsumer<byte[], byte[]> consumer = new KafkaConsumer<byte[], byte[]>(config, (Deserializer<byte[]>)new ByteArrayDeserializer(), (Deserializer<byte[]>)new ByteArrayDeserializer());
        boolean bl = false;
        Some some = null;
        Option<Seq<PartitionInfo>> option = this.listPartitionInfos(consumer, topic, (Set<Object>)partitionIdsRequested);
        if (None$.MODULE$.equals(option)) {
            System.err.println(new StringBuilder(21).append("Topic ").append(topic).append(" does not exist").toString());
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Seq p3 = (Seq)some.value();
            if (p3.isEmpty()) {
                if (partitionIdsRequested.isEmpty()) {
                    System.err.println(new StringBuilder(23).append("Topic ").append(topic).append(" has 0 partitions").toString());
                } else {
                    System.err.println(new StringBuilder(53).append("Topic ").append(topic).append(" does not have any of the requested partitions ").append(partitionIdsRequested.mkString(",")).toString());
                }
                throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
            }
        }
        if (!bl) {
            throw new MatchError(option);
        }
        Seq seq = p2 = (Seq)some.value();
        Seq partitionInfos = seq;
        if (partitionIdsRequested.nonEmpty()) {
            ((IterableLike)partitionIdsRequested.$minus$minus((GenTraversableOnce)partitionInfos.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.partition()), Seq$.MODULE$.canBuildFrom()))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> System.err.println(new StringBuilder(32).append("Error: partition ").append(partitionId).append(" does not exist").toString()));
        }
        Seq topicPartitions = (Seq)((TraversableLike)partitionInfos.sortBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.partition()), (Ordering)Ordering.Int$.MODULE$)).flatMap((Function1 & Serializable & scala.Serializable)p -> {
            Iterable iterable;
            if (p.leader() == null) {
                System.err.println(new StringBuilder(62).append("Error: partition ").append(p.partition()).append(" does not have a leader. Skip getting offsets").toString());
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            } else {
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)new TopicPartition(p.topic(), p.partition())));
            }
            return iterable;
        }, Seq$.MODULE$.canBuildFrom());
        long l = listOffsetsTimestamp;
        if (-2L == l) {
            map = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(consumer.beginningOffsets((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topicPartitions).asJava())).asScala();
        } else if (-1L == l) {
            map = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(consumer.endOffsets((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topicPartitions).asJava())).asScala();
        } else {
            java.util.Map timestampsToSearch = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)topicPartitions.map((Function1 & Serializable & scala.Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)Predef$.MODULE$.long2Long(listOffsetsTimestamp)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
            map = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(consumer.offsetsForTimes(timestampsToSearch)).asScala()).mapValues((Function1 & Serializable & scala.Serializable)x -> x == null ? null : Predef$.MODULE$.long2Long(x.offset()));
        }
        Map partitionOffsets = map;
        ((IterableLike)partitionOffsets.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)GetOffsetShell$.$anonfun$main$8(x0$1)), (Ordering)Ordering.Int$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            GetOffsetShell$.$anonfun$main$9(topic, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    private Option<Seq<PartitionInfo>> listPartitionInfos(KafkaConsumer<?, ?> consumer, String topic, Set<Object> partitionIds) {
        Buffer partitionInfos = ((TraversableOnce)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(consumer.listTopics()).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)GetOffsetShell$.$anonfun$listPartitionInfos$1(topic, x$3))).values().flatMap((Function1 & Serializable & scala.Serializable)x$4 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$4).asScala(), Iterable$.MODULE$.canBuildFrom())).toBuffer();
        return partitionInfos.isEmpty() ? None$.MODULE$ : (partitionIds.isEmpty() ? new Some((Object)partitionInfos) : new Some(partitionInfos.filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)partitionIds.contains((Object)BoxesRunTime.boxToInteger((int)p.partition()))))));
    }

    public static final /* synthetic */ int $anonfun$main$1(String partitionsString$1, String partitionString) {
        int n;
        try {
            n = new StringOps(Predef$.MODULE$.augmentString(partitionString)).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println(new StringBuilder(84).append("--partitions expects a comma separated list of numeric partition ids, but received: ").append(partitionsString$1).toString());
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
        return n;
    }

    public static final /* synthetic */ int $anonfun$main$8(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        int n = tp.partition();
        return n;
    }

    public static final /* synthetic */ void $anonfun$main$9(String topic$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        Long offset = (Long)tuple2._2();
        Predef$.MODULE$.println((Object)new StringBuilder(2).append(topic$1).append(":").append(tp.partition()).append(":").append(Option$.MODULE$.apply((Object)offset).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$listPartitionInfos$1(String topic$2, String x$3) {
        String string = x$3;
        String string2 = topic$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private GetOffsetShell$() {
        MODULE$ = this;
    }
}

