/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.audit;

import org.drools.core.audit.ThreadedWorkingMemoryFileLogger;
import org.drools.core.audit.WorkingMemoryConsoleLogger;
import org.drools.core.audit.WorkingMemoryFileLogger;
import org.drools.core.impl.AbstractRuntime;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.logger.KieLoggers;
import org.kie.api.logger.KieRuntimeLogger;

public class KnowledgeRuntimeLoggerProviderImpl
implements KieLoggers {
    @Override
    public KieRuntimeLogger newFileLogger(KieRuntimeEventManager session, String fileName) {
        return this.newFileLogger(session, fileName, 1000);
    }

    @Override
    public KieRuntimeLogger newFileLogger(KieRuntimeEventManager session, String fileName, int maxEventsInMemory) {
        WorkingMemoryFileLogger logger2 = new WorkingMemoryFileLogger(session);
        logger2.setMaxEventsInMemory(maxEventsInMemory);
        if (fileName != null) {
            logger2.setFileName(fileName);
        }
        return this.registerRuntimeLogger(session, logger2);
    }

    @Override
    public KieRuntimeLogger newThreadedFileLogger(KieRuntimeEventManager session, String fileName, int interval) {
        ThreadedWorkingMemoryFileLogger logger2 = new ThreadedWorkingMemoryFileLogger(session);
        if (fileName != null) {
            logger2.setFileName(fileName);
        }
        logger2.start(interval);
        return this.registerRuntimeLogger(session, logger2);
    }

    @Override
    public KieRuntimeLogger newConsoleLogger(KieRuntimeEventManager session) {
        WorkingMemoryConsoleLogger logger2 = new WorkingMemoryConsoleLogger(session);
        return this.registerRuntimeLogger(session, logger2);
    }

    private KieRuntimeLogger registerRuntimeLogger(KieRuntimeEventManager session, KieRuntimeLogger logger2) {
        if (session instanceof AbstractRuntime) {
            ((AbstractRuntime)session).setLogger(logger2);
        }
        return logger2;
    }
}

