/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.core.base.AccessorKey;
import org.drools.core.base.BaseClassFieldReader;
import org.drools.core.base.BaseClassFieldWriter;
import org.drools.core.base.ClassFieldAccessor;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ClassFieldAccessorFactory;
import org.drools.core.base.ClassFieldReader;
import org.drools.core.base.ClassFieldWriter;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.extractors.MVELDateClassFieldReader;
import org.drools.core.base.extractors.MVELNumberClassFieldReader;
import org.drools.core.base.extractors.MVELObjectClassFieldReader;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.spi.AcceptsClassObjectType;
import org.drools.core.spi.AcceptsReadAccessor;
import org.drools.core.spi.ClassWireable;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.ObjectType;
import org.drools.core.util.asm.ClassFieldInspector;
import org.kie.api.definition.type.FactField;
import org.kie.internal.builder.KnowledgeBuilderResult;

public class ClassFieldAccessorStore
implements Externalizable {
    private static final long serialVersionUID = 510L;
    private Map<AccessorKey, BaseLookupEntry> lookup = new ConcurrentHashMap<AccessorKey, BaseLookupEntry>();
    private ClassFieldAccessorCache cache;
    private boolean eagerWire = true;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.lookup);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.lookup = (Map)in.readObject();
    }

    public void setEagerWire(boolean eagerWire) {
        this.eagerWire = eagerWire;
    }

    public void setClassFieldAccessorCache(ClassFieldAccessorCache cache) {
        this.cache = cache;
    }

    public ClassFieldReader getReader(Class cls, String fieldName) {
        return this.getReader(cls.getName(), fieldName, null, AccessorKey.AccessorType.FieldAccessor);
    }

    public ClassFieldReader getReader(String className, String fieldName, AcceptsReadAccessor target) {
        return this.getReader(className, fieldName, target, AccessorKey.AccessorType.FieldAccessor);
    }

    public synchronized ClassFieldReader getReader(String className, String fieldName, AcceptsReadAccessor target, AccessorKey.AccessorType accessorType) {
        boolean exists;
        AccessorKey key = new AccessorKey(className, fieldName, accessorType);
        FieldLookupEntry entry = (FieldLookupEntry)this.lookup.get(key);
        boolean bl = exists = entry != null;
        if (!exists) {
            entry = new FieldLookupEntry(new ClassFieldReader(className, fieldName));
        }
        if (this.eagerWire) {
            this.wire(entry.getClassFieldReader());
            ClassFieldReader reader = (ClassFieldReader)entry.getClassFieldReader();
            if (!reader.hasReadAccessor()) {
                return null;
            }
        }
        if (target != null) {
            target.setReadAccessor(entry.getClassFieldReader());
        }
        if (!exists) {
            this.lookup.put(key, entry);
        }
        return (ClassFieldReader)entry.getClassFieldReader();
    }

    public ClassFieldReader getReader(AccessorKey key) {
        FieldLookupEntry entry = (FieldLookupEntry)this.lookup.get(key);
        return entry != null ? (ClassFieldReader)entry.getClassFieldReader() : null;
    }

    public InternalReadAccessor getMVELReader(String pkgName, String className, String expr, boolean typesafe, Class returnType) {
        AccessorKey key = new AccessorKey(pkgName + className, expr, AccessorKey.AccessorType.FieldAccessor);
        FieldLookupEntry entry = (FieldLookupEntry)this.lookup.computeIfAbsent(key, k -> new FieldLookupEntry(ClassFieldAccessorStore.getReadAcessor(className, expr, typesafe, returnType)));
        return entry.getClassFieldReader();
    }

    public static InternalReadAccessor getReadAcessor(String className, String expr, boolean typesafe, Class returnType) {
        if (Number.class.isAssignableFrom(returnType) || returnType == Byte.TYPE || returnType == Short.TYPE || returnType == Integer.TYPE || returnType == Long.TYPE || returnType == Float.TYPE || returnType == Double.TYPE) {
            return new MVELNumberClassFieldReader(className, expr, typesafe);
        }
        if (Date.class.isAssignableFrom(returnType)) {
            return new MVELDateClassFieldReader(className, expr, typesafe);
        }
        return new MVELObjectClassFieldReader(className, expr, typesafe);
    }

    public ClassFieldAccessor getAccessor(Class cls, String fieldName) {
        return this.getAccessor(cls.getName(), fieldName);
    }

    public ClassFieldAccessor getAccessor(String className, String fieldName) {
        AccessorKey key = new AccessorKey(className, fieldName, AccessorKey.AccessorType.FieldAccessor);
        FieldLookupEntry entry = (FieldLookupEntry)this.lookup.computeIfAbsent(key, k -> new FieldLookupEntry(new ClassFieldReader(className, fieldName), new ClassFieldWriter(className, fieldName)));
        ClassFieldAccessor accessor2 = new ClassFieldAccessor((ClassFieldReader)entry.getClassFieldReader(), entry.getClassFieldWriter());
        if (this.eagerWire) {
            this.wire(entry.getClassFieldReader());
            this.wire(entry.getClassFieldWriter());
        }
        return accessor2;
    }

    public ObjectType wireObjectType(ObjectType objectType, AcceptsClassObjectType target) {
        if (!(objectType instanceof ClassObjectType)) {
            return objectType;
        }
        AccessorKey key = new AccessorKey(objectType.getClassName(), objectType.isEvent() ? "$$DROOLS__isEvent__" : null, AccessorKey.AccessorType.ClassObjectType);
        ClassObjectTypeLookupEntry entry = (ClassObjectTypeLookupEntry)this.lookup.computeIfAbsent(key, k -> new ClassObjectTypeLookupEntry(this.cache.getClassObjectType((ClassObjectType)objectType, false)));
        if (target != null) {
            target.setClassObjectType(entry.getClassObjectType());
        }
        return entry.getClassObjectType();
    }

    public void removeType(TypeDeclaration type) {
        this.lookup.remove(new AccessorKey(type.getTypeClassName(), null, AccessorKey.AccessorType.ClassObjectType));
        for (FactField field : type.getTypeClassDef().getFields()) {
            this.lookup.remove(new AccessorKey(type.getTypeClassName(), field.getName(), AccessorKey.AccessorType.FieldAccessor));
        }
    }

    public void removeClass(Class<?> clazz) {
        this.lookup.remove(new AccessorKey(clazz.getName(), null, AccessorKey.AccessorType.ClassObjectType));
        for (Field field : clazz.getDeclaredFields()) {
            this.lookup.remove(new AccessorKey(clazz.getName(), field.getName(), AccessorKey.AccessorType.FieldAccessor));
        }
    }

    public void merge(ClassFieldAccessorStore other) {
        block4: for (Map.Entry<AccessorKey, BaseLookupEntry> entry : other.lookup.entrySet()) {
            switch (entry.getValue().getAccessorType()) {
                case FieldAccessor: {
                    Externalizable accessor2;
                    FieldLookupEntry lookupEntry = (FieldLookupEntry)this.lookup.computeIfAbsent(entry.getKey(), e -> (BaseLookupEntry)entry.getValue());
                    if (lookupEntry.getClassFieldReader() != null) {
                        InternalReadAccessor reader = ((FieldLookupEntry)entry.getValue()).getClassFieldReader();
                        accessor2 = this.wire(reader);
                        if (other.cache != null && reader instanceof ClassFieldReader) {
                            other.cache.setReadAcessor((ClassFieldReader)reader, (BaseClassFieldReader)accessor2);
                        }
                    }
                    if (lookupEntry.getClassFieldWriter() == null) break;
                    ClassFieldWriter writer = ((FieldLookupEntry)entry.getValue()).getClassFieldWriter();
                    accessor2 = this.wire(writer);
                    if (other.cache == null) continue block4;
                    other.cache.setWriteAcessor(writer, (BaseClassFieldWriter)accessor2);
                    break;
                }
                case ClassObjectType: {
                    ClassObjectTypeLookupEntry classObjectTypeLookupEntry = (ClassObjectTypeLookupEntry)this.lookup.computeIfAbsent(entry.getKey(), e -> {
                        ClassObjectType oldObjectType = ((ClassObjectTypeLookupEntry)entry.getValue()).getClassObjectType();
                        ClassObjectType newObjectType = this.cache.getClassObjectType(oldObjectType, true);
                        oldObjectType.setClassType(newObjectType.getClassType());
                        return new ClassObjectTypeLookupEntry(newObjectType);
                    });
                }
            }
        }
    }

    public void wire() {
        for (Map.Entry<AccessorKey, BaseLookupEntry> entry : this.lookup.entrySet()) {
            switch (entry.getValue().getAccessorType()) {
                case FieldAccessor: {
                    ClassFieldWriter writer;
                    InternalReadAccessor reader = ((FieldLookupEntry)entry.getValue()).getClassFieldReader();
                    if (reader != null) {
                        this.wire(reader);
                    }
                    if ((writer = ((FieldLookupEntry)entry.getValue()).getClassFieldWriter()) == null) break;
                    this.wire(writer);
                    break;
                }
                case ClassObjectType: {
                    ClassObjectType classObjectType = ((ClassObjectTypeLookupEntry)entry.getValue()).getClassObjectType();
                    this.wire(classObjectType);
                    break;
                }
            }
        }
    }

    public BaseClassFieldReader wire(InternalReadAccessor reader) {
        if (reader instanceof ClassFieldReader) {
            BaseClassFieldReader accessor2 = this.cache.getReadAcessor((ClassFieldReader)reader);
            ((ClassFieldReader)reader).setReadAccessor(accessor2);
            return accessor2;
        }
        return null;
    }

    public Class<?> getFieldType(Class<?> clazz, String fieldName) {
        return ClassFieldAccessorFactory.getFieldType(clazz, fieldName, this.cache.getCacheEntry(clazz));
    }

    public BaseClassFieldWriter wire(ClassFieldWriter writer) {
        BaseClassFieldWriter accessor2 = this.cache.getWriteAcessor(writer);
        writer.setWriteAccessor(accessor2);
        return accessor2;
    }

    public void wire(ClassWireable wireable) {
        try {
            if (wireable.getClassType() == null || !wireable.getClassType().isPrimitive()) {
                Class<?> cls = this.cache.getClassLoader().loadClass(wireable.getClassName());
                wireable.wire(cls);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load ClassObjectType class '" + wireable.getClassName() + "'");
        }
    }

    public Collection<KnowledgeBuilderResult> getWiringResults(Class klass, String fieldName) {
        if (this.cache == null) {
            return Collections.EMPTY_LIST;
        }
        Map<Class<?>, ClassFieldInspector> inspectors = this.cache.getCacheEntry(klass).getInspectors();
        return inspectors.containsKey(klass) ? inspectors.get(klass).getInspectionResults(fieldName) : Collections.EMPTY_LIST;
    }

    public static class FieldLookupEntry
    implements BaseLookupEntry {
        private InternalReadAccessor reader;
        private ClassFieldWriter writer;

        public FieldLookupEntry() {
        }

        public FieldLookupEntry(InternalReadAccessor reader) {
            this.reader = reader;
        }

        public FieldLookupEntry(ClassFieldWriter writer) {
            this.writer = writer;
        }

        public FieldLookupEntry(ClassFieldReader reader, ClassFieldWriter writer) {
            this.writer = writer;
            this.reader = reader;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.reader);
            out.writeObject(this.writer);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.reader = (InternalReadAccessor)in.readObject();
            this.writer = (ClassFieldWriter)in.readObject();
        }

        public InternalReadAccessor getClassFieldReader() {
            return this.reader;
        }

        public ClassFieldWriter getClassFieldWriter() {
            return this.writer;
        }

        @Override
        public AccessorKey.AccessorType getAccessorType() {
            return AccessorKey.AccessorType.FieldAccessor;
        }
    }

    public static class ClassObjectTypeLookupEntry
    implements BaseLookupEntry {
        ClassObjectType classObjectType;

        public ClassObjectTypeLookupEntry() {
        }

        public ClassObjectTypeLookupEntry(ClassObjectType classObjectType) {
            this.classObjectType = classObjectType;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.classObjectType);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.classObjectType = (ClassObjectType)in.readObject();
        }

        public ClassObjectType getClassObjectType() {
            return this.classObjectType;
        }

        public void setClassObjectType(ClassObjectType classObjectType) {
            this.classObjectType = classObjectType;
        }

        @Override
        public AccessorKey.AccessorType getAccessorType() {
            return AccessorKey.AccessorType.ClassObjectType;
        }
    }

    public static interface BaseLookupEntry
    extends Externalizable {
        public AccessorKey.AccessorType getAccessorType();
    }
}

