/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import org.drools.core.base.RuleNameEndsWithAgendaFilter;
import org.drools.core.base.RuleNameEqualsAgendaFilter;
import org.drools.core.base.RuleNameMatchesAgendaFilter;
import org.drools.core.base.RuleNameStartsWithAgendaFilter;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.api.runtime.rule.Match;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="agenda-filter")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RuleNameSerializationAgendaFilter
implements AgendaFilter {
    protected static final transient Logger logger = LoggerFactory.getLogger(RuleNameSerializationAgendaFilter.class);
    @XmlElement
    @XmlSchemaType(name="string")
    private String matchContent;
    @XmlElement
    @XmlSchemaType(name="boolean")
    private Boolean accept;
    @XmlElement(required=true)
    private AgendaFilterType type;

    public RuleNameSerializationAgendaFilter() {
    }

    public RuleNameSerializationAgendaFilter(AgendaFilter originalAgendaFilter) {
        if (originalAgendaFilter instanceof RuleNameSerializationAgendaFilter) {
            this.matchContent = ((RuleNameSerializationAgendaFilter)originalAgendaFilter).matchContent;
            this.accept = ((RuleNameSerializationAgendaFilter)originalAgendaFilter).accept;
            this.type = ((RuleNameSerializationAgendaFilter)originalAgendaFilter).type;
        } else if (originalAgendaFilter instanceof RuleNameEndsWithAgendaFilter) {
            this.matchContent = ((RuleNameEndsWithAgendaFilter)originalAgendaFilter).getSuffix();
            this.accept = ((RuleNameEndsWithAgendaFilter)originalAgendaFilter).isAccept();
            this.type = AgendaFilterType.ENDS_WITH;
        } else if (originalAgendaFilter instanceof RuleNameEqualsAgendaFilter) {
            this.matchContent = ((RuleNameEqualsAgendaFilter)originalAgendaFilter).getName();
            this.accept = ((RuleNameEqualsAgendaFilter)originalAgendaFilter).isAccept();
            this.type = AgendaFilterType.EQUALS;
        } else if (originalAgendaFilter instanceof RuleNameMatchesAgendaFilter) {
            this.matchContent = ((RuleNameMatchesAgendaFilter)originalAgendaFilter).getPattern().pattern();
            this.accept = ((RuleNameMatchesAgendaFilter)originalAgendaFilter).isAccept();
            this.type = AgendaFilterType.MATCHES;
        } else if (originalAgendaFilter instanceof RuleNameStartsWithAgendaFilter) {
            this.matchContent = ((RuleNameStartsWithAgendaFilter)originalAgendaFilter).getPrefix();
            this.accept = ((RuleNameStartsWithAgendaFilter)originalAgendaFilter).isAccept();
            this.type = AgendaFilterType.STARTS_WITH;
        } else {
            logger.warn(originalAgendaFilter.getClass().getName() + " instance will not be serialized!");
        }
    }

    public static AgendaFilter newFrom(AgendaFilter agendaFilter) {
        return new RuleNameSerializationAgendaFilter(agendaFilter);
    }

    public AgendaFilter getOriginal() {
        AgendaFilter realAgendaFilter = null;
        switch (this.type) {
            case ENDS_WITH: {
                RuleNameEndsWithAgendaFilter filter;
                realAgendaFilter = filter = new RuleNameEndsWithAgendaFilter(this.matchContent, this.accept);
                break;
            }
            case EQUALS: {
                RuleNameEqualsAgendaFilter filter = new RuleNameEqualsAgendaFilter(this.matchContent, this.accept);
                realAgendaFilter = filter;
                break;
            }
            case MATCHES: {
                RuleNameMatchesAgendaFilter filter = new RuleNameMatchesAgendaFilter(this.matchContent, this.accept);
                realAgendaFilter = filter;
                break;
            }
            case STARTS_WITH: {
                RuleNameStartsWithAgendaFilter filter = new RuleNameStartsWithAgendaFilter(this.matchContent, this.accept);
                realAgendaFilter = filter;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown " + AgendaFilter.class.getSimpleName() + " type: " + this.type.name());
            }
        }
        return realAgendaFilter;
    }

    @Override
    public boolean accept(Match match) {
        return this.getOriginal().accept(match);
    }

    public boolean equals(Object obj) {
        if (obj instanceof RuleNameSerializationAgendaFilter) {
            RuleNameSerializationAgendaFilter other = (RuleNameSerializationAgendaFilter)obj;
            if (RuleNameSerializationAgendaFilter.objectEquals(this.accept, other.accept) && RuleNameSerializationAgendaFilter.objectEquals(this.matchContent, other.matchContent) && RuleNameSerializationAgendaFilter.objectEquals((Object)this.type, (Object)other.type)) {
                return true;
            }
        }
        return false;
    }

    private static boolean objectEquals(Object orig, Object other) {
        if (orig == null) {
            return orig == other;
        }
        return orig.equals(other);
    }

    @XmlEnum
    public static enum AgendaFilterType {
        ENDS_WITH,
        EQUALS,
        MATCHES,
        STARTS_WITH;

    }
}

