/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.runtime.process;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.drools.core.xml.jaxb.util.JaxbUnknownAdapter;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.command.ProcessInstanceIdCommand;
import org.kie.internal.command.RegistryContext;
import org.kie.internal.jaxb.CorrelationKeyXmlAdapter;
import org.kie.internal.process.CorrelationAwareProcessRuntime;
import org.kie.internal.process.CorrelationKey;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class SignalEventCommand
implements ExecutableCommand<Void>,
ProcessInstanceIdCommand {
    private static final long serialVersionUID = 2134028686669740220L;
    @XmlAttribute(name="process-instance-id")
    private String processInstanceId;
    @XmlElement(name="correlation-key", required=false)
    @XmlJavaTypeAdapter(value=CorrelationKeyXmlAdapter.class)
    private CorrelationKey correlationKey;
    @XmlAttribute(name="event-type", required=true)
    private String eventType;
    @XmlElement(name="event")
    @XmlJavaTypeAdapter(value=JaxbUnknownAdapter.class)
    private Object event;

    public SignalEventCommand() {
    }

    public SignalEventCommand(String eventType, Object event) {
        this.eventType = eventType;
        this.event = event;
    }

    public SignalEventCommand(String processInstanceId, String eventType, Object event) {
        this.processInstanceId = processInstanceId;
        this.eventType = eventType;
        this.event = event;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Override
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public CorrelationKey getCorrelationKey() {
        return this.correlationKey;
    }

    public void setCorrelationKey(CorrelationKey correlationKey) {
        this.correlationKey = correlationKey;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public Object getEvent() {
        return this.event;
    }

    public void setEvent(Object event) {
        this.event = event;
    }

    @Override
    public Void execute(Context context) {
        KieSession ksession = ((RegistryContext)context).lookup(KieSession.class);
        if (this.processInstanceId == null && this.correlationKey == null) {
            ksession.signalEvent(this.eventType, this.event);
        } else {
            ProcessInstance processInstance = this.correlationKey != null ? ((CorrelationAwareProcessRuntime)((Object)ksession)).getProcessInstance(this.correlationKey) : ksession.getProcessInstance(this.processInstanceId);
            if (processInstance != null) {
                processInstance.signalEvent(this.eventType, this.event);
            }
        }
        return null;
    }

    public String toString() {
        if (this.processInstanceId == null && this.correlationKey == null) {
            return "ksession.signalEvent(" + this.eventType + ", " + this.event + ");";
        }
        if (this.correlationKey != null) {
            return "ksession.signalEvent(" + this.correlationKey + ", " + this.eventType + ", " + this.event + ");";
        }
        return "ksession.signalEvent(" + this.processInstanceId + ", " + this.eventType + ", " + this.event + ");";
    }
}

