/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.management;

import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.StandardMBean;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenMBeanConstructorInfo;
import javax.management.openmbean.OpenMBeanConstructorInfoSupport;
import javax.management.openmbean.OpenMBeanInfoSupport;
import javax.management.openmbean.OpenMBeanOperationInfo;
import javax.management.openmbean.OpenMBeanOperationInfoSupport;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenMBeanParameterInfoSupport;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.drools.core.base.ClassObjectType;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.management.DroolsManagementAgent;
import org.drools.core.management.KieBaseConfigurationMonitor;
import org.drools.core.management.ObjectTypeNodeMonitor;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.ObjectTypeNode;
import org.kie.api.management.KieBaseConfigurationMonitorMBean;
import org.kie.api.management.ObjectTypeNodeMonitorMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnowledgeBaseMonitoring
implements DynamicMBean {
    protected static final transient Logger logger = LoggerFactory.getLogger(KnowledgeBaseMonitoring.class);
    private static final String ATTR_PACKAGES = "Packages";
    private static final String ATTR_GLOBALS = "Globals";
    private static final String ATTR_SESSION_COUNT = "SessionCount";
    private static final String ATTR_ID = "Id";
    private static final String OP_STOP_INTERNAL_MBEANS = "stopInternalMBeans";
    private static final String OP_START_INTERNAL_MBEANS = "startInternalMBeans";
    private InternalKnowledgeBase kbase;
    private ObjectName name;
    private OpenMBeanInfoSupport info;
    private static String[] globalsColNames = new String[]{"name", "class"};
    private static String[] globalsColDescr = new String[]{"Global identifier", "Fully qualified class name"};
    private static OpenType[] globalsColTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING};
    private static CompositeType globalsType;
    private static String[] index;
    private static TabularType globalsTableType;

    public KnowledgeBaseMonitoring(InternalKnowledgeBase kbase) {
        this.kbase = kbase;
        this.name = DroolsManagementAgent.createObjectNameFor(kbase);
        this.initOpenMBeanInfo();
    }

    private void initOpenMBeanInfo() {
        OpenMBeanAttributeInfo[] attributes = new OpenMBeanAttributeInfoSupport[4];
        OpenMBeanConstructorInfo[] constructors = new OpenMBeanConstructorInfoSupport[1];
        OpenMBeanOperationInfo[] operations = new OpenMBeanOperationInfoSupport[2];
        MBeanNotificationInfo[] notifications = new MBeanNotificationInfo[]{};
        try {
            attributes[0] = new OpenMBeanAttributeInfoSupport(ATTR_ID, "Knowledge Base Id", SimpleType.STRING, true, false, false);
            attributes[1] = new OpenMBeanAttributeInfoSupport(ATTR_SESSION_COUNT, "Number of created sessions for this Knowledge Base", SimpleType.LONG, true, false, false);
            attributes[2] = new OpenMBeanAttributeInfoSupport(ATTR_GLOBALS, "List of globals", globalsTableType, true, false, false);
            attributes[3] = new OpenMBeanAttributeInfoSupport(ATTR_PACKAGES, "List of Packages", new ArrayType(1, SimpleType.STRING), true, false, false);
            constructors[0] = new OpenMBeanConstructorInfoSupport("KnowledgeBaseMonitoringMXBean", "Constructs a KnowledgeBaseMonitoringMXBean instance.", new OpenMBeanParameterInfoSupport[0]);
            OpenMBeanParameterInfo[] params = new OpenMBeanParameterInfoSupport[]{};
            operations[0] = new OpenMBeanOperationInfoSupport(OP_START_INTERNAL_MBEANS, "Creates, registers and starts all the dependent MBeans that allow monitor all the details in this KnowledgeBase.", params, SimpleType.VOID, 0);
            operations[1] = new OpenMBeanOperationInfoSupport(OP_STOP_INTERNAL_MBEANS, "Stops and disposes all the dependent MBeans that allow monitor all the details in this KnowledgeBase.", params, SimpleType.VOID, 0);
            this.info = new OpenMBeanInfoSupport(this.getClass().getName(), "Knowledge Base Monitor MXBean", attributes, constructors, operations, notifications);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ObjectName getName() {
        return this.name;
    }

    public TabularData getGlobals() throws OpenDataException {
        TabularDataSupport globalsTable = new TabularDataSupport(globalsTableType);
        for (Map.Entry<String, Class<?>> global : this.kbase.getGlobals().entrySet()) {
            Object[] itemValues = new Object[]{global.getKey(), global.getValue().getName()};
            CompositeDataSupport result = new CompositeDataSupport(globalsType, globalsColNames, itemValues);
            globalsTable.put(result);
        }
        return globalsTable;
    }

    public String getId() {
        return this.kbase.getId();
    }

    public String[] getPackages() {
        return this.kbase.getPackagesMap().keySet().toArray(new String[0]);
    }

    public long getSessionCount() {
        return this.kbase.getWorkingMemoryCounter();
    }

    public void startInternalMBeans() {
        for (EntryPointNode epn : this.kbase.getRete().getEntryPointNodes().values()) {
            for (ObjectTypeNode otn : epn.getObjectTypeNodes().values()) {
                ObjectTypeNodeMonitor otnm = new ObjectTypeNodeMonitor(otn);
                try {
                    StandardMBean adapter = new StandardMBean(otnm, ObjectTypeNodeMonitorMBean.class);
                    ObjectName name = DroolsManagementAgent.createObjectName(this.name.toString() + ",group=EntryPoints,EntryPoint=" + otnm.getNameSufix() + ",ObjectType=" + ((ClassObjectType)otn.getObjectType()).getClassName());
                    DroolsManagementAgent.getInstance().registerMBean(this.kbase, adapter, name);
                }
                catch (NotCompliantMBeanException e) {
                    logger.error("Unable to register ObjectTypeNodeMonitor mbean for OTN " + otn.getObjectType() + " into the platform MBean Server", e);
                }
            }
        }
        KieBaseConfigurationMonitor kbcm = new KieBaseConfigurationMonitor(this.kbase.getConfiguration());
        try {
            StandardMBean adapter = new StandardMBean(kbcm, KieBaseConfigurationMonitorMBean.class);
            ObjectName name = DroolsManagementAgent.createObjectName(this.name.toString() + ",group=Configuration");
            DroolsManagementAgent.getInstance().registerMBean(this.kbase, adapter, name);
        }
        catch (NotCompliantMBeanException e) {
            logger.error("Unable to register KBaseConfigurationMonitor mbean into the platform MBean Server", e);
        }
    }

    public void stopInternalMBeans() {
        DroolsManagementAgent.getInstance().unregisterDependentsMBeansFromOwner(this.kbase);
    }

    @Override
    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attributeName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attributeName cannot be null"), "Cannot invoke a getter of " + this.getClass().getName());
        }
        if (attributeName.equals(ATTR_ID)) {
            return this.getId();
        }
        if (attributeName.equals(ATTR_SESSION_COUNT)) {
            return this.getSessionCount();
        }
        if (attributeName.equals(ATTR_GLOBALS)) {
            try {
                return this.getGlobals();
            }
            catch (OpenDataException e) {
                throw new RuntimeOperationsException(new RuntimeException("Error retrieving globals list", e), "Error retrieving globals list " + e.getMessage());
            }
        }
        if (attributeName.equals(ATTR_PACKAGES)) {
            return this.getPackages();
        }
        throw new AttributeNotFoundException("Cannot find " + attributeName + " attribute ");
    }

    @Override
    public AttributeList getAttributes(String[] attributeNames) {
        AttributeList resultList = new AttributeList();
        if (attributeNames.length == 0) {
            return resultList;
        }
        for (int i = 0; i < attributeNames.length; ++i) {
            try {
                Object value = this.getAttribute(attributeNames[i]);
                resultList.add(new Attribute(attributeNames[i], value));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return resultList;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.info;
    }

    @Override
    public Object invoke(String operationName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (operationName.equals(OP_START_INTERNAL_MBEANS)) {
            this.startInternalMBeans();
        } else if (operationName.equals(OP_STOP_INTERNAL_MBEANS)) {
            this.stopInternalMBeans();
        } else {
            throw new ReflectionException(new NoSuchMethodException(operationName), "Cannot find the operation " + operationName);
        }
        return null;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new AttributeNotFoundException("No attribute can be set in this MBean");
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return new AttributeList();
    }

    static {
        index = new String[]{"name"};
        try {
            globalsType = new CompositeType("globalsType", "Globals row type", globalsColNames, globalsColDescr, globalsColTypes);
            globalsTableType = new TabularType("globalsTableType", "List of globals", globalsType, index);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

