/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.marshalling.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyAcceptor;

public class JavaSerializableResolverStrategy
implements ObjectMarshallingStrategy {
    private ObjectMarshallingStrategyAcceptor acceptor;

    public JavaSerializableResolverStrategy(ObjectMarshallingStrategyAcceptor acceptor) {
        this.acceptor = acceptor;
    }

    @Override
    public Object read(ObjectInputStream os) throws IOException, ClassNotFoundException {
        return os.readObject();
    }

    @Override
    public void write(ObjectOutputStream os, Object object) throws IOException {
        os.writeObject(object);
    }

    @Override
    public boolean accept(Object object) {
        return this.acceptor.accept(object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] marshal(ObjectMarshallingStrategy.Context context, ObjectOutputStream os, Object object) {
        try (ByteArrayOutputStream bs = new ByteArrayOutputStream();){
            os = new ObjectOutputStream(bs);
            this.write(os, object);
            byte[] byArray = bs.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object unmarshal(String dataType, ObjectMarshallingStrategy.Context context, ObjectInputStream is, byte[] object, final ClassLoader classloader) {
        try (ByteArrayInputStream bs = new ByteArrayInputStream(object);){
            is = new ObjectInputStream(bs){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws ClassNotFoundException {
                    return Class.forName(desc.getName(), true, classloader);
                }
            };
            Object object2 = this.read(is);
            return object2;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ObjectMarshallingStrategy.Context createContext() {
        return null;
    }

    public String toString() {
        return "JavaSerializableResolverStrategy{acceptor=" + this.acceptor + '}';
    }
}

