/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.ruleunit;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.rule.EntryPointId;
import org.drools.reflective.util.ClassUtils;
import org.kie.kogito.rules.DataSource;
import org.kie.kogito.rules.RuleUnit;
import org.kie.kogito.rules.RuleUnitData;

public class RuleUnitDescription {
    private final Class<? extends RuleUnitData> ruleUnitClass;
    private final Map<String, String> datasources = new HashMap<String, String>();
    private final Map<String, Class<?>> datasourceTypes = new HashMap();
    private final Map<String, Method> varAccessors = new HashMap<String, Method>();

    public RuleUnitDescription(InternalKnowledgePackage pkg, Class<? extends RuleUnitData> ruleUnitClass) {
        this.ruleUnitClass = ruleUnitClass;
        this.indexUnitVars(pkg);
    }

    public Class<? extends RuleUnitData> getRuleUnitClass() {
        return this.ruleUnitClass;
    }

    public String getRuleUnitName() {
        return this.ruleUnitClass.getName();
    }

    public Optional<EntryPointId> getEntryPointId(String name) {
        return Optional.ofNullable(this.datasources.get(name)).map(ds -> new EntryPointId(name));
    }

    public Optional<Class<?>> getDatasourceType(String name) {
        return Optional.ofNullable(this.datasourceTypes.get(name));
    }

    public Optional<Class<?>> getVarType(String name) {
        return Optional.ofNullable(this.varAccessors.get(name)).map(Method::getReturnType);
    }

    public boolean hasVar(String name) {
        return this.varAccessors.containsKey(name);
    }

    public Collection<String> getUnitVars() {
        return this.varAccessors.keySet();
    }

    public Map<String, Method> getUnitVarAccessors() {
        return this.varAccessors;
    }

    public boolean hasDataSource(String name) {
        return this.datasources.containsKey(name);
    }

    public Object getValue(RuleUnitData ruleUnit, String identifier) {
        Method m = this.varAccessors.get(identifier);
        if (m != null) {
            try {
                return m.invoke((Object)ruleUnit, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private void indexUnitVars(InternalKnowledgePackage pkg) {
        for (Method m : this.ruleUnitClass.getMethods()) {
            String id;
            if (m.getDeclaringClass() == RuleUnit.class || m.getParameterCount() != 0 || (id = ClassUtils.getter2property(m.getName())) == null || id.equals("class")) continue;
            this.indexUnitAccessor(pkg, m, id);
        }
    }

    private void indexUnitAccessor(InternalKnowledgePackage pkg, Method m, String id) {
        this.datasources.put(id, m.getName());
        this.varAccessors.put(id, m);
        Class<?> unitVarType = this.getUnitVarType(m);
        this.datasourceTypes.put(id, unitVarType);
        pkg.addGlobal(id, ClassUtils.convertFromPrimitiveType(m.getReturnType()));
    }

    private Class<?> getUnitVarType(Method m) {
        Class<?> returnClass = m.getReturnType();
        if (returnClass.isArray()) {
            return returnClass.getComponentType();
        }
        if (DataSource.class.isAssignableFrom(returnClass)) {
            return this.getParametricType(m);
        }
        if (Iterable.class.isAssignableFrom(returnClass)) {
            return this.getParametricType(m);
        }
        return returnClass;
    }

    private Class<?> getParametricType(Method m) {
        Type returnType = m.getGenericReturnType();
        return returnType instanceof ParameterizedType ? (Class)((ParameterizedType)returnType).getActualTypeArguments()[0] : Object.class;
    }
}

