/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.ruleunit;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.ruleunit.RuleUnitDescription;
import org.drools.core.ruleunit.RuleUnitDescriptionLoader;
import org.drools.core.ruleunit.State;
import org.kie.kogito.rules.RuleUnitData;

public class RuleUnitDescriptionRegistry {
    private State state = State.UNKNOWN;
    private final Map<String, RuleUnitDescription> ruleUnits = new ConcurrentHashMap<String, RuleUnitDescription>();

    public RuleUnitDescription getDescription(RuleUnitData ruleUnit) {
        RuleUnitDescription ruleUnitDescr = this.ruleUnits.get(RuleUnitDescriptionRegistry.getUnitName(ruleUnit));
        if (ruleUnitDescr == null) {
            throw new IllegalStateException("Unknown RuleUnitDescription: " + RuleUnitDescriptionRegistry.getUnitName(ruleUnit));
        }
        return ruleUnitDescr;
    }

    public Optional<RuleUnitDescription> getDescription(String unitClassName) {
        return Optional.ofNullable(this.ruleUnits.get(unitClassName));
    }

    public Optional<RuleUnitDescription> getDescription(RuleImpl rule) {
        return this.getDescription(rule.getRuleUnitClassName());
    }

    public void add(RuleUnitDescriptionLoader loader) {
        if (loader != null) {
            this.ruleUnits.putAll(loader.getDescriptions());
            this.state = this.state.merge(loader.getState());
        }
    }

    public boolean hasUnits() {
        return !this.ruleUnits.isEmpty();
    }

    public static String getUnitName(RuleUnitData ruleUnit) {
        return ruleUnit.getClass().getName();
    }
}

