/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.ruleunit.impl;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.drools.core.ruleunit.impl.EntryPointDataProcessor;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.time.SessionClock;
import org.kie.kogito.rules.DataSource;
import org.kie.kogito.rules.RuleUnit;
import org.kie.kogito.rules.RuleUnitData;
import org.kie.kogito.rules.RuleUnitInstance;

public class AbstractRuleUnitInstance<T extends RuleUnitData>
implements RuleUnitInstance<T> {
    private final T unitMemory;
    private final RuleUnit<T> unit;
    private final KieSession runtime;

    public AbstractRuleUnitInstance(RuleUnit<T> unit, T unitMemory, KieSession runtime) {
        this.unit = unit;
        this.runtime = runtime;
        this.unitMemory = unitMemory;
        this.bind(runtime, unitMemory);
    }

    @Override
    public int fire() {
        return this.runtime.fireAllRules();
    }

    @Override
    public List<Map<String, Object>> executeQuery(String query, Object ... arguments) {
        this.fire();
        return this.runtime.getQueryResults(query, arguments).toList();
    }

    @Override
    public RuleUnit<T> unit() {
        return this.unit;
    }

    @Override
    public <C extends SessionClock> C getClock() {
        return (C)this.runtime.getSessionClock();
    }

    public T workingMemory() {
        return this.unitMemory;
    }

    protected void bind(KieSession runtime, T workingMemory) {
        try {
            for (Field f : workingMemory.getClass().getDeclaredFields()) {
                f.setAccessible(true);
                Object v = null;
                v = f.get(workingMemory);
                String dataSourceName = f.getName();
                if (v instanceof DataSource) {
                    DataSource o = (DataSource)v;
                    EntryPoint ep = runtime.getEntryPoint(dataSourceName);
                    o.subscribe(new EntryPointDataProcessor(ep));
                }
                try {
                    runtime.setGlobal(dataSourceName, v);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
    }
}

