/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.multimap;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.exceptions.RemoteCacheManagerNotStartedException;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.client.hotrod.impl.multimap.operations.ContainsEntryMultimapOperation;
import org.infinispan.client.hotrod.impl.multimap.operations.ContainsKeyMultimapOperation;
import org.infinispan.client.hotrod.impl.multimap.operations.ContainsValueMultimapOperation;
import org.infinispan.client.hotrod.impl.multimap.operations.GetKeyMultimapOperation;
import org.infinispan.client.hotrod.impl.multimap.operations.GetKeyWithMetadataMultimapOperation;
import org.infinispan.client.hotrod.impl.multimap.operations.MultimapOperationsFactory;
import org.infinispan.client.hotrod.impl.multimap.operations.PutKeyValueMultimapOperation;
import org.infinispan.client.hotrod.impl.multimap.operations.RemoveEntryMultimapOperation;
import org.infinispan.client.hotrod.impl.multimap.operations.RemoveKeyMultimapOperation;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.client.hotrod.marshall.MarshallerUtil;
import org.infinispan.client.hotrod.multimap.MetadataCollection;
import org.infinispan.client.hotrod.multimap.RemoteMultimapCache;
import org.infinispan.commons.marshall.Marshaller;

public class RemoteMultimapCacheImpl<K, V>
implements RemoteMultimapCache<K, V> {
    private static final Log log = LogFactory.getLog(RemoteMultimapCacheImpl.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private RemoteCacheImpl<K, Collection<V>> cache;
    private final RemoteCacheManager remoteCacheManager;
    private MultimapOperationsFactory operationsFactory;
    private Marshaller marshaller;
    private int estimateKeySize;
    private int estimateValueSize;
    private long defaultLifespan = 0L;
    private long defaultMaxIdleTime = 0L;

    public void init() {
        this.operationsFactory = new MultimapOperationsFactory(this.remoteCacheManager.getChannelFactory(), this.cache.getName(), this.remoteCacheManager.getCodec(), this.remoteCacheManager.getConfiguration(), this.cache.getDataFormat(), this.cache.getClientStatistics());
        this.marshaller = this.remoteCacheManager.getMarshaller();
        this.estimateKeySize = this.remoteCacheManager.getConfiguration().keySizeEstimate();
        this.estimateValueSize = this.remoteCacheManager.getConfiguration().valueSizeEstimate();
    }

    public RemoteMultimapCacheImpl(RemoteCacheManager rcm, RemoteCache<K, Collection<V>> cache) {
        if (trace) {
            log.tracef("Creating multimap remote cache: %s", (Object)cache.getName());
        }
        this.cache = (RemoteCacheImpl)cache;
        this.remoteCacheManager = rcm;
    }

    @Override
    public CompletableFuture<Void> put(K key, V value) {
        if (trace) {
            log.tracef("About to add (K,V): (%s, %s) lifespan:%d, maxIdle:%d", key, value, this.defaultLifespan, this.defaultMaxIdleTime);
        }
        this.assertRemoteCacheManagerIsStarted();
        K objectKey = this.isObjectStorage() ? key : null;
        byte[] marshallKey = MarshallerUtil.obj2bytes(this.marshaller, key, true, this.estimateKeySize, this.estimateValueSize);
        byte[] marshallValue = MarshallerUtil.obj2bytes(this.marshaller, value, false, this.estimateKeySize, this.estimateValueSize);
        PutKeyValueMultimapOperation op = this.operationsFactory.newPutKeyValueOperation(objectKey, marshallKey, marshallValue, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
        return op.execute();
    }

    @Override
    public CompletableFuture<Collection<V>> get(K key) {
        if (trace) {
            log.tracef("About to call get (K): (%s)", (Object)key);
        }
        this.assertRemoteCacheManagerIsStarted();
        K objectKey = this.isObjectStorage() ? key : null;
        byte[] marshallKey = MarshallerUtil.obj2bytes(this.marshaller, key, true, this.estimateKeySize, this.estimateValueSize);
        GetKeyMultimapOperation gco = this.operationsFactory.newGetKeyMultimapOperation(objectKey, marshallKey);
        return gco.execute();
    }

    @Override
    public CompletableFuture<MetadataCollection<V>> getWithMetadata(K key) {
        if (trace) {
            log.tracef("About to call getWithMetadata (K): (%s)", (Object)key);
        }
        this.assertRemoteCacheManagerIsStarted();
        K objectKey = this.isObjectStorage() ? key : null;
        byte[] marshallKey = MarshallerUtil.obj2bytes(this.marshaller, key, true, this.estimateKeySize, this.estimateValueSize);
        GetKeyWithMetadataMultimapOperation operation = this.operationsFactory.newGetKeyWithMetadataMultimapOperation(objectKey, marshallKey);
        return operation.execute();
    }

    @Override
    public CompletableFuture<Boolean> remove(K key) {
        if (trace) {
            log.tracef("About to remove (K): (%s)", (Object)key);
        }
        this.assertRemoteCacheManagerIsStarted();
        K objectKey = this.isObjectStorage() ? key : null;
        byte[] marshallKey = MarshallerUtil.obj2bytes(this.marshaller, key, true, this.estimateKeySize, this.estimateValueSize);
        RemoveKeyMultimapOperation removeOperation = this.operationsFactory.newRemoveKeyOperation(objectKey, marshallKey);
        return removeOperation.execute();
    }

    @Override
    public CompletableFuture<Boolean> remove(K key, V value) {
        if (trace) {
            log.tracef("About to remove (K,V): (%s, %s)", (Object)key, (Object)value);
        }
        this.assertRemoteCacheManagerIsStarted();
        K objectKey = this.isObjectStorage() ? key : null;
        byte[] marshallKey = MarshallerUtil.obj2bytes(this.marshaller, key, true, this.estimateKeySize, this.estimateValueSize);
        byte[] marshallValue = MarshallerUtil.obj2bytes(this.marshaller, value, false, this.estimateKeySize, this.estimateValueSize);
        RemoveEntryMultimapOperation removeOperation = this.operationsFactory.newRemoveEntryOperation(objectKey, marshallKey, marshallValue);
        return removeOperation.execute();
    }

    @Override
    public CompletableFuture<Boolean> containsKey(K key) {
        if (trace) {
            log.tracef("About to call contains (K): (%s)", (Object)key);
        }
        this.assertRemoteCacheManagerIsStarted();
        K objectKey = this.isObjectStorage() ? key : null;
        byte[] marshallKey = MarshallerUtil.obj2bytes(this.marshaller, key, true, this.estimateKeySize, this.estimateValueSize);
        ContainsKeyMultimapOperation containsKeyOperation = this.operationsFactory.newContainsKeyOperation(objectKey, marshallKey);
        return containsKeyOperation.execute();
    }

    @Override
    public CompletableFuture<Boolean> containsValue(V value) {
        if (trace) {
            log.tracef("About to call contains (V): (%s)", (Object)value);
        }
        this.assertRemoteCacheManagerIsStarted();
        byte[] marshallValue = MarshallerUtil.obj2bytes(this.marshaller, value, false, this.estimateKeySize, this.estimateValueSize);
        ContainsValueMultimapOperation containsValueOperation = this.operationsFactory.newContainsValueOperation(marshallValue);
        return containsValueOperation.execute();
    }

    @Override
    public CompletableFuture<Boolean> containsEntry(K key, V value) {
        if (trace) {
            log.tracef("About to call contais(K,V): (%s, %s)", (Object)key, (Object)value);
        }
        this.assertRemoteCacheManagerIsStarted();
        K objectKey = this.isObjectStorage() ? key : null;
        byte[] marshallKey = MarshallerUtil.obj2bytes(this.marshaller, key, true, this.estimateKeySize, this.estimateValueSize);
        byte[] marshallValue = MarshallerUtil.obj2bytes(this.marshaller, value, false, this.estimateKeySize, this.estimateValueSize);
        ContainsEntryMultimapOperation containsOperation = this.operationsFactory.newContainsEntryOperation(objectKey, marshallKey, marshallValue);
        return containsOperation.execute();
    }

    @Override
    public CompletableFuture<Long> size() {
        if (trace) {
            log.trace("About to call size");
        }
        this.assertRemoteCacheManagerIsStarted();
        return this.operationsFactory.newSizeOperation().execute();
    }

    @Override
    public boolean supportsDuplicates() {
        return false;
    }

    private void assertRemoteCacheManagerIsStarted() {
        if (!this.remoteCacheManager.isStarted()) {
            String message = "Cannot perform operations on a multimap cache associated with an unstarted RemoteMultimapCacheManager.";
            if (log.isInfoEnabled()) {
                log.unstartedRemoteCacheManager();
            }
            throw new RemoteCacheManagerNotStartedException(message);
        }
    }

    private boolean isObjectStorage() {
        return this.cache.isObjectStorage();
    }
}

