/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.event.ProcessEventSupport;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.marshalling.impl.ProtobufMessages;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.time.TimeUtils;
import org.drools.core.time.impl.ThreadSafeTrackableTimeJobFactoryManager;
import org.jbpm.process.core.event.EventFilter;
import org.jbpm.process.core.event.EventTransformer;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.process.core.timer.BusinessCalendar;
import org.jbpm.process.core.timer.DateTimeUtils;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.ProcessInstanceFactory;
import org.jbpm.process.instance.ProcessInstanceFactoryRegistry;
import org.jbpm.process.instance.ProcessInstanceManager;
import org.jbpm.process.instance.event.DefaultSignalManagerFactory;
import org.jbpm.process.instance.impl.DefaultProcessInstanceManagerFactory;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.node.EventTrigger;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.Trigger;
import org.kie.api.KieBase;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.Process;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.DefaultAgendaEventListener;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.event.rule.RuleFlowGroupDeactivatedEvent;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.EventListener;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.internal.command.RegistryContext;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.kie.internal.utils.CompositeClassLoader;
import org.kie.kogito.jobs.DurationExpirationTime;
import org.kie.kogito.jobs.ExactExpirationTime;
import org.kie.kogito.jobs.ExpirationTime;
import org.kie.kogito.jobs.JobsService;
import org.kie.kogito.jobs.ProcessJobDescription;
import org.kie.kogito.services.uow.CollectingUnitOfWorkFactory;
import org.kie.kogito.services.uow.DefaultUnitOfWorkManager;
import org.kie.kogito.signal.SignalManager;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.kie.services.jobs.impl.InMemoryJobService;
import org.kie.services.time.TimerService;
import org.kie.services.time.impl.CommandServiceTimerJobFactoryManager;

public class ProcessRuntimeImpl
implements InternalProcessRuntime {
    private InternalKnowledgeRuntime kruntime;
    private ProcessInstanceManager processInstanceManager;
    private SignalManager signalManager;
    private JobsService jobService;
    private ProcessEventSupport processEventSupport;
    private UnitOfWorkManager unitOfWorkManager;

    public ProcessRuntimeImpl(InternalKnowledgeRuntime kruntime) {
        this.kruntime = kruntime;
        TimerService timerService = kruntime.getTimerService();
        if (!(timerService.getTimerJobFactoryManager() instanceof CommandServiceTimerJobFactoryManager)) {
            timerService.setTimerJobFactoryManager(new ThreadSafeTrackableTimeJobFactoryManager());
        }
        ((CompositeClassLoader)this.getRootClassLoader()).addClassLoader(this.getClass().getClassLoader());
        this.initProcessInstanceManager();
        this.initSignalManager();
        this.unitOfWorkManager = new DefaultUnitOfWorkManager(new CollectingUnitOfWorkFactory());
        this.jobService = new InMemoryJobService(this, this.unitOfWorkManager);
        this.processEventSupport = new ProcessEventSupport(this.unitOfWorkManager);
        if (this.isActive()) {
            this.initProcessEventListeners();
            this.initStartTimers();
        }
        this.initProcessActivationListener();
    }

    public void initStartTimers() {
        KieBase kbase = this.kruntime.getKieBase();
        Collection<Process> processes = kbase.getProcesses();
        for (Process process : processes) {
            RuleFlowProcess p = (RuleFlowProcess)process;
            List<StartNode> startNodes = p.getTimerStart();
            if (startNodes == null || startNodes.isEmpty()) continue;
            for (StartNode startNode : startNodes) {
                if (startNode == null || startNode.getTimer() == null) continue;
                this.jobService.scheduleProcessJob(ProcessJobDescription.of(this.createTimerInstance(startNode.getTimer(), this.kruntime), p.getId()));
            }
        }
    }

    public ProcessRuntimeImpl(InternalWorkingMemory workingMemory) {
        TimerService timerService = workingMemory.getTimerService();
        if (!(timerService.getTimerJobFactoryManager() instanceof CommandServiceTimerJobFactoryManager)) {
            timerService.setTimerJobFactoryManager(new ThreadSafeTrackableTimeJobFactoryManager());
        }
        this.kruntime = workingMemory.getKnowledgeRuntime();
        this.initProcessInstanceManager();
        this.initSignalManager();
        this.unitOfWorkManager = new DefaultUnitOfWorkManager(new CollectingUnitOfWorkFactory());
        this.jobService = new InMemoryJobService(this, this.unitOfWorkManager);
        this.processEventSupport = new ProcessEventSupport(this.unitOfWorkManager);
        if (this.isActive()) {
            this.initProcessEventListeners();
            this.initStartTimers();
        }
        this.initProcessActivationListener();
    }

    private void initProcessInstanceManager() {
        this.processInstanceManager = new DefaultProcessInstanceManagerFactory().createProcessInstanceManager(this.kruntime);
    }

    private void initSignalManager() {
        this.signalManager = new DefaultSignalManagerFactory().createSignalManager(this.kruntime);
    }

    private ClassLoader getRootClassLoader() {
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)this.kruntime.getKieBase();
        if (kbase != null) {
            return kbase.getRootClassLoader();
        }
        CompositeClassLoader result = new CompositeClassLoader();
        result.addClassLoader(Thread.currentThread().getContextClassLoader());
        return result;
    }

    @Override
    public org.kie.api.runtime.process.ProcessInstance startProcess(String processId) {
        return this.startProcess(processId, null);
    }

    @Override
    public org.kie.api.runtime.process.ProcessInstance startProcess(String processId, Map<String, Object> parameters) {
        return this.startProcess(processId, parameters, null);
    }

    public org.kie.api.runtime.process.ProcessInstance startProcess(String processId, Map<String, Object> parameters, String trigger) {
        org.kie.api.runtime.process.ProcessInstance processInstance = this.createProcessInstance(processId, parameters);
        if (processInstance != null) {
            return this.startProcessInstance(processInstance.getId(), trigger);
        }
        return null;
    }

    @Override
    public org.kie.api.runtime.process.ProcessInstance createProcessInstance(String processId, Map<String, Object> parameters) {
        return this.createProcessInstance(processId, null, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public org.kie.api.runtime.process.ProcessInstance startProcessInstance(String processInstanceId, String trigger) {
        try {
            this.kruntime.startOperation();
            org.kie.api.runtime.process.ProcessInstance processInstance = this.getProcessInstance(processInstanceId);
            ((ProcessInstance)processInstance).configureSLA();
            this.getProcessEventSupport().fireBeforeProcessStarted(processInstance, this.kruntime);
            ((ProcessInstance)processInstance).start(trigger);
            this.getProcessEventSupport().fireAfterProcessStarted(processInstance, this.kruntime);
            org.kie.api.runtime.process.ProcessInstance processInstance2 = processInstance;
            return processInstance2;
        }
        finally {
            this.kruntime.endOperation();
        }
    }

    @Override
    public org.kie.api.runtime.process.ProcessInstance startProcessInstance(String processInstanceId) {
        return this.startProcessInstance(processInstanceId, null);
    }

    @Override
    public org.kie.api.runtime.process.ProcessInstance startProcess(String processId, CorrelationKey correlationKey, Map<String, Object> parameters) {
        org.kie.api.runtime.process.ProcessInstance processInstance = this.createProcessInstance(processId, correlationKey, parameters);
        if (processInstance != null) {
            return this.startProcessInstance(processInstance.getId());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public org.kie.api.runtime.process.ProcessInstance createProcessInstance(String processId, CorrelationKey correlationKey, Map<String, Object> parameters) {
        try {
            this.kruntime.startOperation();
            Process process = this.kruntime.getKieBase().getProcess(processId);
            if (process == null) {
                throw new IllegalArgumentException("Unknown process ID: " + processId);
            }
            ProcessInstance processInstance = this.startProcess(process, correlationKey, parameters);
            return processInstance;
        }
        finally {
            this.kruntime.endOperation();
        }
    }

    @Override
    public org.kie.api.runtime.process.ProcessInstance getProcessInstance(CorrelationKey correlationKey) {
        return this.processInstanceManager.getProcessInstance(correlationKey);
    }

    private ProcessInstance startProcess(Process process, CorrelationKey correlationKey, Map<String, Object> parameters) {
        ProcessInstanceFactory conf = ProcessInstanceFactoryRegistry.INSTANCE.getProcessInstanceFactory(process);
        if (conf == null) {
            throw new IllegalArgumentException("Illegal process type: " + process.getClass());
        }
        return conf.createProcessInstance(process, correlationKey, this.kruntime, parameters);
    }

    @Override
    public ProcessInstanceManager getProcessInstanceManager() {
        return this.processInstanceManager;
    }

    @Override
    public JobsService getJobsService() {
        return this.jobService;
    }

    @Override
    public SignalManager getSignalManager() {
        return this.signalManager;
    }

    @Override
    public Collection<org.kie.api.runtime.process.ProcessInstance> getProcessInstances() {
        return this.processInstanceManager.getProcessInstances();
    }

    @Override
    public org.kie.api.runtime.process.ProcessInstance getProcessInstance(String id) {
        return this.getProcessInstance(id, false);
    }

    @Override
    public org.kie.api.runtime.process.ProcessInstance getProcessInstance(String id, boolean readOnly) {
        return this.processInstanceManager.getProcessInstance(id, readOnly);
    }

    public void removeProcessInstance(org.kie.api.runtime.process.ProcessInstance processInstance) {
        this.processInstanceManager.removeProcessInstance(processInstance);
    }

    public void initProcessEventListeners() {
        for (Process process : this.kruntime.getKieBase().getProcesses()) {
            this.initProcessEventListener(process);
        }
    }

    public void removeProcessEventListeners() {
        for (Process process : this.kruntime.getKieBase().getProcesses()) {
            this.removeProcessEventListener(process);
        }
    }

    private void removeProcessEventListener(Process process) {
        if (process instanceof RuleFlowProcess) {
            String type = (String)((RuleFlowProcess)process).getRuntimeMetaData().get("StartProcessEventType");
            StartProcessEventListener listener = (StartProcessEventListener)((RuleFlowProcess)process).getRuntimeMetaData().get("StartProcessEventListener");
            if (type != null && listener != null) {
                this.signalManager.removeEventListener(type, listener);
            }
        }
    }

    private void initProcessEventListener(Process process) {
        if (process instanceof RuleFlowProcess) {
            for (Node node : ((RuleFlowProcess)process).getNodes()) {
                List<Trigger> triggers;
                StartNode startNode;
                if (!(node instanceof StartNode) || (startNode = (StartNode)node) == null || (triggers = startNode.getTriggers()) == null) continue;
                for (Trigger trigger : triggers) {
                    if (!(trigger instanceof EventTrigger)) continue;
                    List<EventFilter> filters = ((EventTrigger)trigger).getEventFilters();
                    String type = null;
                    for (EventFilter filter : filters) {
                        if (!(filter instanceof EventTypeFilter)) continue;
                        type = ((EventTypeFilter)filter).getType();
                    }
                    StartProcessEventListener listener = new StartProcessEventListener(process.getId(), filters, trigger.getInMappings(), startNode.getEventTransformer());
                    this.signalManager.addEventListener(type, listener);
                    ((RuleFlowProcess)process).getRuntimeMetaData().put("StartProcessEventType", type);
                    ((RuleFlowProcess)process).getRuntimeMetaData().put("StartProcessEventListener", listener);
                }
            }
        }
    }

    @Override
    public ProcessEventSupport getProcessEventSupport() {
        return this.processEventSupport;
    }

    @Override
    public void addEventListener(ProcessEventListener listener) {
        this.processEventSupport.addEventListener(listener);
    }

    @Override
    public void removeEventListener(ProcessEventListener listener) {
        this.processEventSupport.removeEventListener(listener);
    }

    public List<ProcessEventListener> getProcessEventListeners() {
        return this.processEventSupport.getEventListeners();
    }

    private void initProcessActivationListener() {
        this.kruntime.addEventListener(new DefaultAgendaEventListener(){

            @Override
            public void matchCreated(MatchCreatedEvent event) {
                String ruleFlowGroup = ((RuleImpl)event.getMatch().getRule()).getRuleFlowGroup();
                if ("DROOLS_SYSTEM".equals(ruleFlowGroup)) {
                    String ruleName = event.getMatch().getRule().getName();
                    if (ruleName.startsWith("RuleFlowStateNode-")) {
                        int index = ruleName.indexOf(45, 18);
                        index = ruleName.indexOf(45, index + 1);
                        String eventType = ruleName.substring(0, index);
                        ProcessRuntimeImpl.this.kruntime.queueWorkingMemoryAction(new SignalManagerSignalAction(eventType, event));
                    } else if (ruleName.startsWith("RuleFlowStateEventSubProcess-") || ruleName.startsWith("RuleFlowStateEvent-") || ruleName.startsWith("RuleFlow-Milestone-") || ruleName.startsWith("RuleFlow-AdHocComplete-") || ruleName.startsWith("RuleFlow-AdHocActivate-")) {
                        ProcessRuntimeImpl.this.kruntime.queueWorkingMemoryAction(new SignalManagerSignalAction(ruleName, event));
                    }
                } else {
                    String ruleName = event.getMatch().getRule().getName();
                    if (ruleName.startsWith("RuleFlow-Start-")) {
                        String processId = ruleName.replace("RuleFlow-Start-", "");
                        ProcessRuntimeImpl.this.startProcessWithParamsAndTrigger(processId, null, "conditional", true);
                    }
                }
            }
        });
        this.kruntime.addEventListener(new DefaultAgendaEventListener(){

            @Override
            public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
                if (ProcessRuntimeImpl.this.kruntime instanceof StatefulKnowledgeSession) {
                    ProcessRuntimeImpl.this.signalManager.signalEvent("RuleFlowGroup_" + event.getRuleFlowGroup().getName() + "_" + ((StatefulKnowledgeSession)((Object)ProcessRuntimeImpl.this.kruntime)).getIdentifier(), null);
                } else {
                    ProcessRuntimeImpl.this.signalManager.signalEvent("RuleFlowGroup_" + event.getRuleFlowGroup().getName(), null);
                }
            }
        });
    }

    private void startProcessWithParamsAndTrigger(String processId, Map<String, Object> params, String type, boolean dispose) {
        this.startProcess(processId, params, type);
    }

    @Override
    public void abortProcessInstance(String processInstanceId) {
        org.kie.api.runtime.process.ProcessInstance processInstance = this.getProcessInstance(processInstanceId);
        if (processInstance == null) {
            throw new IllegalArgumentException("Could not find process instance for id " + processInstanceId);
        }
        ((ProcessInstance)processInstance).setState(3);
    }

    @Override
    public WorkItemManager getWorkItemManager() {
        return this.kruntime.getWorkItemManager();
    }

    @Override
    public UnitOfWorkManager getUnitOfWorkManager() {
        return this.unitOfWorkManager;
    }

    @Override
    public void signalEvent(String type, Object event) {
        this.signalManager.signalEvent(type, event);
    }

    @Override
    public void signalEvent(String type, Object event, String processInstanceId) {
        this.signalManager.signalEvent(processInstanceId, type, event);
    }

    @Override
    public void setProcessEventSupport(ProcessEventSupport processEventSupport) {
        this.processEventSupport = processEventSupport;
    }

    @Override
    public void dispose() {
        this.processEventSupport.reset();
        this.kruntime = null;
    }

    @Override
    public void clearProcessInstances() {
        this.processInstanceManager.clearProcessInstances();
    }

    @Override
    public void clearProcessInstancesState() {
        this.processInstanceManager.clearProcessInstancesState();
    }

    public boolean isActive() {
        Boolean active = (Boolean)this.kruntime.getEnvironment().get("Active");
        if (active == null) {
            return true;
        }
        return active;
    }

    protected ExpirationTime createTimerInstance(Timer timer, InternalKnowledgeRuntime kruntime) {
        if (kruntime != null && kruntime.getEnvironment().get("jbpm.business.calendar") != null) {
            BusinessCalendar businessCalendar = (BusinessCalendar)kruntime.getEnvironment().get("jbpm.business.calendar");
            long delay = businessCalendar.calculateBusinessTimeAsDuration(timer.getDelay());
            if (timer.getPeriod() == null) {
                return DurationExpirationTime.repeat(delay);
            }
            long period = businessCalendar.calculateBusinessTimeAsDuration(timer.getPeriod());
            return DurationExpirationTime.repeat(delay, period);
        }
        return this.configureTimerInstance(timer);
    }

    private ExpirationTime configureTimerInstance(Timer timer) {
        long duration = -1L;
        switch (timer.getTimeType()) {
            case 2: {
                long[] repeatValues = DateTimeUtils.parseRepeatableDateTime(timer.getDelay());
                if (repeatValues.length == 3) {
                    int parsedReapedCount = (int)repeatValues[0];
                    return DurationExpirationTime.repeat(repeatValues[1], (Long)repeatValues[2], parsedReapedCount);
                }
                long delay = repeatValues[0];
                long period = -1L;
                try {
                    period = TimeUtils.parseTimeString(timer.getPeriod());
                }
                catch (RuntimeException e) {
                    period = repeatValues[0];
                }
                return DurationExpirationTime.repeat(delay, period);
            }
            case 1: {
                duration = DateTimeUtils.parseDuration(timer.getDelay());
                return DurationExpirationTime.after(duration);
            }
            case 3: {
                return ExactExpirationTime.of(timer.getDate());
            }
        }
        throw new UnsupportedOperationException("Not supported timer definition");
    }

    @Override
    public InternalKnowledgeRuntime getInternalKieRuntime() {
        return this.kruntime;
    }

    public class SignalManagerSignalAction
    extends PropagationEntry.AbstractPropagationEntry
    implements WorkingMemoryAction {
        private String type;
        private Object event;

        public SignalManagerSignalAction(String type, Object event) {
            this.type = type;
            this.event = event;
        }

        public SignalManagerSignalAction(MarshallerReaderContext context) throws IOException, ClassNotFoundException {
            this.type = context.readUTF();
            if (context.readBoolean()) {
                this.event = context.readObject();
            }
        }

        @Override
        public void execute(InternalWorkingMemory workingMemory) {
            ProcessRuntimeImpl.this.signalEvent(this.type, this.event);
        }

        @Override
        public void execute(InternalKnowledgeRuntime kruntime) {
            ProcessRuntimeImpl.this.signalEvent(this.type, this.event);
        }

        @Override
        public ProtobufMessages.ActionQueue.Action serialize(MarshallerWriteContext context) throws IOException {
            return null;
        }
    }

    private class StartProcessWithTypeCommand
    implements ExecutableCommand<Void> {
        private static final long serialVersionUID = -8890906804846111698L;
        private String processId;
        private Map<String, Object> params;
        private String type;

        private StartProcessWithTypeCommand(String processId, Map<String, Object> params, String type) {
            this.processId = processId;
            this.params = params;
            this.type = type;
        }

        @Override
        public Void execute(Context context) {
            KieSession ksession = ((RegistryContext)context).lookup(KieSession.class);
            ((ProcessRuntimeImpl)((InternalKnowledgeRuntime)((Object)ksession)).getProcessRuntime()).startProcess(this.processId, this.params, this.type);
            return null;
        }
    }

    private class StartProcessEventListener
    implements EventListener {
        private String processId;
        private List<EventFilter> eventFilters;
        private Map<String, String> inMappings;
        private EventTransformer eventTransformer;

        public StartProcessEventListener(String processId, List<EventFilter> eventFilters, Map<String, String> inMappings, EventTransformer eventTransformer) {
            this.processId = processId;
            this.eventFilters = eventFilters;
            this.inMappings = inMappings;
            this.eventTransformer = eventTransformer;
        }

        @Override
        public String[] getEventTypes() {
            return null;
        }

        @Override
        public void signalEvent(String type, Object event) {
            for (EventFilter filter : this.eventFilters) {
                if (filter.acceptsEvent(type, event)) continue;
                return;
            }
            if (this.eventTransformer != null) {
                event = this.eventTransformer.transformEvent(event);
            }
            HashMap<String, Object> params = null;
            if (this.inMappings != null && !this.inMappings.isEmpty()) {
                params = new HashMap<String, Object>();
                if (this.inMappings.size() == 1) {
                    params.put(this.inMappings.keySet().iterator().next(), event);
                } else {
                    for (Map.Entry<String, String> entry : this.inMappings.entrySet()) {
                        if ("event".equals(entry.getValue())) {
                            params.put(entry.getKey(), event);
                            continue;
                        }
                        params.put(entry.getKey(), entry.getValue());
                    }
                }
            }
            ProcessRuntimeImpl.this.startProcessWithParamsAndTrigger(this.processId, params, type, false);
        }
    }
}

