/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.command;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlSchemaType;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.command.ProcessInstanceIdCommand;
import org.kie.internal.command.RegistryContext;

@XmlAccessorType(value=XmlAccessType.NONE)
public class GetProcessInstanceVariableCommand
implements ExecutableCommand<Object>,
ProcessInstanceIdCommand {
    private static final long serialVersionUID = 6L;
    @XmlAttribute(required=true)
    @XmlSchemaType(name="string")
    private String processInstanceId;
    @XmlAttribute(required=true)
    @XmlSchemaType(name="string")
    private String variableId;

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Override
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getVariableId() {
        return this.variableId;
    }

    public void setVariableId(String variableId) {
        this.variableId = variableId;
    }

    @Override
    public Object execute(Context context) {
        KieSession ksession = ((RegistryContext)context).lookup(KieSession.class);
        if (this.processInstanceId == null) {
            return null;
        }
        ProcessInstance processInstance = ksession.getProcessInstance(this.processInstanceId);
        if (processInstance == null) {
            throw new IllegalArgumentException("Could not find process instance for id " + this.processInstanceId);
        }
        if (processInstance instanceof WorkflowProcessInstance) {
            return ((WorkflowProcessInstance)processInstance).getVariable(this.variableId);
        }
        throw new IllegalStateException("Could not retrieve variable " + this.variableId + " because process instance " + this.processInstanceId + " was inaccessible!");
    }

    public String toString() {
        return "session.getProcessInstanceVariable(" + this.processInstanceId + ", " + this.variableId + ");";
    }
}

