/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.util.MVELSafeHelper;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.core.timer.BusinessCalendar;
import org.jbpm.process.core.timer.DateTimeUtils;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.process.instance.ContextInstance;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.process.instance.impl.ProcessInstanceImpl;
import org.jbpm.util.PatternConstants;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.WorkflowProcess;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.DynamicNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.core.node.EventNodeInterface;
import org.jbpm.workflow.core.node.EventSubProcessNode;
import org.jbpm.workflow.core.node.StateBasedNode;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.impl.CompensationEventListener;
import org.jbpm.workflow.instance.impl.DummyEventListener;
import org.jbpm.workflow.instance.impl.ExtendedNodeInstanceImpl;
import org.jbpm.workflow.instance.impl.NodeInstanceFactory;
import org.jbpm.workflow.instance.impl.NodeInstanceFactoryRegistry;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.jbpm.workflow.instance.impl.NodeInstanceResolverFactory;
import org.jbpm.workflow.instance.impl.ProcessInstanceResolverFactory;
import org.jbpm.workflow.instance.node.CompositeNodeInstance;
import org.jbpm.workflow.instance.node.DynamicNodeInstance;
import org.jbpm.workflow.instance.node.EndNodeInstance;
import org.jbpm.workflow.instance.node.EventBasedNodeInstanceInterface;
import org.jbpm.workflow.instance.node.EventNodeInstance;
import org.jbpm.workflow.instance.node.EventNodeInstanceInterface;
import org.jbpm.workflow.instance.node.EventSubProcessNodeInstance;
import org.jbpm.workflow.instance.node.FaultNodeInstance;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.NodeContainer;
import org.kie.api.runtime.process.EventListener;
import org.kie.internal.process.CorrelationKey;
import org.kie.kogito.jobs.DurationExpirationTime;
import org.kie.kogito.jobs.ProcessInstanceJobDescription;
import org.kie.services.time.TimerInstance;
import org.mvel2.integration.VariableResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WorkflowProcessInstanceImpl
extends ProcessInstanceImpl
implements WorkflowProcessInstance,
NodeInstanceContainer {
    private static final long serialVersionUID = 510L;
    private static final Logger logger = LoggerFactory.getLogger(WorkflowProcessInstanceImpl.class);
    private final List<NodeInstance> nodeInstances = new ArrayList<NodeInstance>();
    private Map<String, List<EventListener>> eventListeners = new HashMap<String, List<EventListener>>();
    private Map<String, List<EventListener>> externalEventListeners = new HashMap<String, List<EventListener>>();
    private List<String> completedNodeIds = new ArrayList<String>();
    private List<String> activatingNodeIds;
    private Map<String, Integer> iterationLevels = new HashMap<String, Integer>();
    private int currentLevel;
    private Object faultData;
    private boolean signalCompletion = true;
    private String deploymentId;
    private String correlationKey;
    private Date startDate;
    private Date endDate;
    private String nodeIdInError;
    private String errorMessage;
    private int slaCompliance = 0;
    private Date slaDueDate;
    private String slaTimerId;
    private String referenceId;

    @Override
    public NodeContainer getNodeContainer() {
        return this.getWorkflowProcess();
    }

    @Override
    public void addNodeInstance(NodeInstance nodeInstance) {
        if (nodeInstance.getId() == null) {
            ((NodeInstanceImpl)nodeInstance).setId(UUID.randomUUID().toString());
        }
        this.nodeInstances.add(nodeInstance);
    }

    @Override
    public int getLevelForNode(String uniqueID) {
        if ("true".equalsIgnoreCase(System.getProperty("jbpm.loop.level.disabled"))) {
            return 1;
        }
        Integer value = this.iterationLevels.get(uniqueID);
        if (value == null && this.currentLevel == 0) {
            value = 1;
        } else if (value == null && this.currentLevel > 0 || value != null && this.currentLevel > 0 && value > this.currentLevel) {
            value = this.currentLevel;
        } else {
            Integer n = value;
            Integer n2 = value = Integer.valueOf(value + 1);
        }
        this.iterationLevels.put(uniqueID, value);
        return value;
    }

    @Override
    public void removeNodeInstance(NodeInstance nodeInstance) {
        if (((NodeInstanceImpl)nodeInstance).isInversionOfControl()) {
            this.getKnowledgeRuntime().delete(this.getKnowledgeRuntime().getFactHandle(nodeInstance));
        }
        this.nodeInstances.remove(nodeInstance);
    }

    @Override
    public Collection<org.kie.api.runtime.process.NodeInstance> getNodeInstances() {
        return new ArrayList<org.kie.api.runtime.process.NodeInstance>(this.getNodeInstances(false));
    }

    @Override
    public Collection<NodeInstance> getNodeInstances(boolean recursive) {
        List<NodeInstance> result = this.nodeInstances;
        if (recursive) {
            result = new ArrayList<NodeInstance>(result);
            for (NodeInstance nodeInstance : this.nodeInstances) {
                if (!(nodeInstance instanceof org.kie.api.runtime.process.NodeInstanceContainer)) continue;
                result.addAll(((NodeInstanceContainer)((Object)nodeInstance)).getNodeInstances(true));
            }
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public NodeInstance getNodeInstance(String nodeInstanceId) {
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (!nodeInstance.getId().equals(nodeInstanceId)) continue;
            return nodeInstance;
        }
        return null;
    }

    @Override
    public NodeInstance getNodeInstance(String nodeInstanceId, boolean recursive) {
        for (NodeInstance nodeInstance : this.getNodeInstances(recursive)) {
            if (!nodeInstance.getId().equals(nodeInstanceId)) continue;
            return nodeInstance;
        }
        return null;
    }

    public List<String> getActiveNodeIds() {
        ArrayList<String> result = new ArrayList<String>();
        this.addActiveNodeIds(this, result);
        return result;
    }

    private void addActiveNodeIds(org.kie.api.runtime.process.NodeInstanceContainer container, List<String> result) {
        for (org.kie.api.runtime.process.NodeInstance nodeInstance : container.getNodeInstances()) {
            result.add(((NodeImpl)nodeInstance.getNode()).getUniqueId());
            if (!(nodeInstance instanceof org.kie.api.runtime.process.NodeInstanceContainer)) continue;
            this.addActiveNodeIds((org.kie.api.runtime.process.NodeInstanceContainer)((Object)nodeInstance), result);
        }
    }

    @Override
    public NodeInstance getFirstNodeInstance(long nodeId) {
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (nodeInstance.getNodeId() != nodeId || nodeInstance.getLevel() != this.getCurrentLevel()) continue;
            return nodeInstance;
        }
        return null;
    }

    public List<NodeInstance> getNodeInstances(long nodeId) {
        ArrayList<NodeInstance> result = new ArrayList<NodeInstance>();
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (nodeInstance.getNodeId() != nodeId) continue;
            result.add(nodeInstance);
        }
        return result;
    }

    public List<NodeInstance> getNodeInstances(long nodeId, List<NodeInstance> currentView) {
        ArrayList<NodeInstance> result = new ArrayList<NodeInstance>();
        for (NodeInstance nodeInstance : currentView) {
            if (nodeInstance.getNodeId() != nodeId) continue;
            result.add(nodeInstance);
        }
        return result;
    }

    public NodeInstance getNodeInstanceByNodeDefinitionId(String nodeDefinitionId, NodeContainer nodeContainer) {
        for (Node node : nodeContainer.getNodes()) {
            NodeInstance ni;
            if (nodeDefinitionId.equals(node.getMetaData().get("UniqueId"))) {
                return this.getNodeInstance(node);
            }
            if (!(node instanceof NodeContainer) || (ni = this.getNodeInstanceByNodeDefinitionId(nodeDefinitionId, (NodeContainer)((Object)node))) == null) continue;
            return ni;
        }
        throw new IllegalArgumentException("Node with definition id " + nodeDefinitionId + " was not found");
    }

    @Override
    public NodeInstance getNodeInstance(Node node) {
        Node actualNode = node;
        NodeInstanceFactory conf = NodeInstanceFactoryRegistry.getInstance(this.getKnowledgeRuntime().getEnvironment()).getProcessNodeInstanceFactory(actualNode);
        if (conf == null) {
            throw new IllegalArgumentException("Illegal node type: " + node.getClass());
        }
        NodeInstanceImpl nodeInstance = (NodeInstanceImpl)conf.getNodeInstance(actualNode, this, this);
        if (nodeInstance == null) {
            throw new IllegalArgumentException("Illegal node type: " + node.getClass());
        }
        if (nodeInstance.isInversionOfControl()) {
            this.getKnowledgeRuntime().insert(nodeInstance);
        }
        return nodeInstance;
    }

    public org.kie.api.definition.process.WorkflowProcess getWorkflowProcess() {
        return (org.kie.api.definition.process.WorkflowProcess)this.getProcess();
    }

    @Override
    public Object getVariable(String name) {
        if (this.getKnowledgeRuntime() == null) {
            List<ContextInstance> variableScopeInstances = this.getContextInstances("VariableScope");
            if (variableScopeInstances != null && variableScopeInstances.size() == 1) {
                for (ContextInstance contextInstance : variableScopeInstances) {
                    Object value = ((VariableScopeInstance)contextInstance).getVariable(name);
                    if (value == null) continue;
                    return value;
                }
            }
            return null;
        }
        VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.getContextInstance("VariableScope");
        if (variableScopeInstance == null) {
            return null;
        }
        return variableScopeInstance.getVariable(name);
    }

    @Override
    public Map<String, Object> getVariables() {
        if (this.getKnowledgeRuntime() == null) {
            List<ContextInstance> variableScopeInstances = this.getContextInstances("VariableScope");
            if (variableScopeInstances == null) {
                return null;
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (ContextInstance contextInstance : variableScopeInstances) {
                Map<String, Object> variables = ((VariableScopeInstance)contextInstance).getVariables();
                result.putAll(variables);
            }
            return result;
        }
        VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.getContextInstance("VariableScope");
        if (variableScopeInstance == null) {
            return null;
        }
        return variableScopeInstance.getVariables();
    }

    @Override
    public void setVariable(String name, Object value) {
        VariableScope variableScope = (VariableScope)((ContextContainer)((Object)this.getProcess())).getDefaultContext("VariableScope");
        VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.getContextInstance("VariableScope");
        if (variableScopeInstance == null) {
            throw new IllegalArgumentException("No variable scope found.");
        }
        variableScope.validateVariable(this.getProcessName(), name, value);
        variableScopeInstance.setVariable(name, value);
    }

    @Override
    public void setState(int state, String outcome, Object faultData) {
        this.faultData = faultData;
        this.setState(state, outcome);
    }

    @Override
    public void setState(int state, String outcome) {
        if (state == 2 || state == 3) {
            this.endDate = new Date();
            if (this.slaCompliance == 1) {
                this.slaCompliance = System.currentTimeMillis() > this.slaDueDate.getTime() ? 3 : (state == 2 ? 2 : 4);
            }
            InternalKnowledgeRuntime kruntime = this.getKnowledgeRuntime();
            InternalProcessRuntime processRuntime = (InternalProcessRuntime)kruntime.getProcessRuntime();
            processRuntime.getProcessEventSupport().fireBeforeProcessCompleted(this, kruntime);
            super.setState(state, outcome);
            while (!this.nodeInstances.isEmpty()) {
                NodeInstance nodeInstance = this.nodeInstances.get(0);
                nodeInstance.cancel();
            }
            if (this.slaTimerId != null && !this.slaTimerId.trim().isEmpty()) {
                processRuntime.getJobsService().cancelJob(this.slaTimerId);
                logger.debug("SLA Timer {} has been canceled", (Object)this.slaTimerId);
            }
            this.removeEventListeners();
            processRuntime.getProcessInstanceManager().removeProcessInstance(this);
            processRuntime.getProcessEventSupport().fireAfterProcessCompleted(this, kruntime);
            if (this.isSignalCompletion()) {
                List<EventListener> listeners = this.eventListeners.get("processInstanceCompleted:" + this.getId());
                if (listeners != null) {
                    for (EventListener listener : listeners) {
                        listener.signalEvent("processInstanceCompleted:" + this.getId(), this);
                    }
                }
                processRuntime.getSignalManager().signalEvent("processInstanceCompleted:" + this.getId(), this);
            }
        } else {
            super.setState(state, outcome);
        }
    }

    @Override
    public void setState(int state) {
        this.setState(state, null);
    }

    @Override
    public void disconnect() {
        this.removeEventListeners();
        this.unregisterExternalEventNodeListeners();
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (!(nodeInstance instanceof EventBasedNodeInstanceInterface)) continue;
            ((EventBasedNodeInstanceInterface)((Object)nodeInstance)).removeEventListeners();
        }
        super.disconnect();
    }

    @Override
    public void reconnect() {
        super.reconnect();
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (!(nodeInstance instanceof EventBasedNodeInstanceInterface)) continue;
            ((EventBasedNodeInstanceInterface)((Object)nodeInstance)).addEventListeners();
        }
        this.registerExternalEventNodeListeners();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("WorkflowProcessInstance");
        sb.append(this.getId());
        sb.append(" [processId=");
        sb.append(this.getProcessId());
        sb.append(",state=");
        sb.append(this.getState());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void start() {
        this.start(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(String trigger) {
        WorkflowProcessInstanceImpl workflowProcessInstanceImpl = this;
        synchronized (workflowProcessInstanceImpl) {
            Node[] nodes;
            this.internalSetStartDate(new Date());
            this.registerExternalEventNodeListeners();
            for (Node node : nodes = this.getNodeContainer().getNodes()) {
                Map<Timer, DroolsAction> timers;
                if (!(node instanceof EventSubProcessNode) || (timers = ((EventSubProcessNode)node).getTimers()) == null || timers.isEmpty()) continue;
                EventSubProcessNodeInstance eventSubprocess = (EventSubProcessNodeInstance)this.getNodeInstance(node);
                eventSubprocess.trigger(null, "DROOLS_DEFAULT");
            }
            super.start(trigger);
        }
    }

    @Override
    public void configureSLA() {
        TimerInstance timer;
        String slaDueDateExpression = (String)this.getProcess().getMetaData().get("customSLADueDate");
        if (slaDueDateExpression != null && (timer = this.configureSLATimer(slaDueDateExpression)) != null) {
            this.slaTimerId = timer.getId();
            this.slaDueDate = new Date(System.currentTimeMillis() + timer.getDelay());
            this.slaCompliance = 1;
            logger.debug("SLA for process instance {} is PENDING with due date {}", (Object)this.getId(), (Object)this.slaDueDate);
        }
    }

    public TimerInstance configureSLATimer(String slaDueDateExpression) {
        if ((slaDueDateExpression = this.resolveVariable(slaDueDateExpression)) == null || slaDueDateExpression.trim().isEmpty()) {
            logger.debug("Sla due date expression resolved to no value '{}'", (Object)slaDueDateExpression);
            return null;
        }
        logger.debug("SLA due date is set to {}", (Object)slaDueDateExpression);
        InternalKnowledgeRuntime kruntime = this.getKnowledgeRuntime();
        long duration = -1L;
        if (kruntime.getEnvironment().get("jbpm.business.calendar") != null) {
            BusinessCalendar businessCalendar = (BusinessCalendar)kruntime.getEnvironment().get("jbpm.business.calendar");
            duration = businessCalendar.calculateBusinessTimeAsDuration(slaDueDateExpression);
        } else {
            duration = DateTimeUtils.parseDuration(slaDueDateExpression);
        }
        TimerInstance timerInstance = new TimerInstance();
        timerInstance.setTimerId(-1L);
        timerInstance.setDelay(duration);
        timerInstance.setPeriod(0L);
        if (this.useTimerSLATracking()) {
            ProcessInstanceJobDescription description = ProcessInstanceJobDescription.of(-1L, DurationExpirationTime.after(duration), this.getId(), this.getProcessId());
            timerInstance.setId(((InternalProcessRuntime)kruntime.getProcessRuntime()).getJobsService().scheduleProcessInstanceJob(description));
        }
        return timerInstance;
    }

    private void registerExternalEventNodeListeners() {
        for (Node node : this.getWorkflowProcess().getNodes()) {
            if (node instanceof EventNode && "external".equals(((EventNode)node).getScope())) {
                this.addEventListener(((EventNode)node).getType(), DummyEventListener.EMPTY_EVENT_LISTENER, true);
                continue;
            }
            if (node instanceof EventSubProcessNode) {
                List<String> events = ((EventSubProcessNode)node).getEvents();
                for (String type : events) {
                    this.addEventListener(type, DummyEventListener.EMPTY_EVENT_LISTENER, true);
                    if (!this.isVariableExpression(type)) continue;
                    this.addEventListener(this.resolveVariable(type), DummyEventListener.EMPTY_EVENT_LISTENER, true);
                }
                continue;
            }
            if (!(node instanceof DynamicNode) || ((DynamicNode)node).getActivationEventName() == null) continue;
            this.addEventListener(((DynamicNode)node).getActivationEventName(), DummyEventListener.EMPTY_EVENT_LISTENER, true);
        }
        if (this.getWorkflowProcess().getMetaData().containsKey("Compensation")) {
            this.addEventListener("Compensation", new CompensationEventListener(this), true);
        }
    }

    private void unregisterExternalEventNodeListeners() {
        for (Node node : this.getWorkflowProcess().getNodes()) {
            if (!(node instanceof EventNode) || !"external".equals(((EventNode)node).getScope())) continue;
            this.externalEventListeners.remove(((EventNode)node).getType());
        }
    }

    private void handleSLAViolation() {
        if (this.slaCompliance == 1) {
            InternalKnowledgeRuntime kruntime = this.getKnowledgeRuntime();
            InternalProcessRuntime processRuntime = (InternalProcessRuntime)kruntime.getProcessRuntime();
            processRuntime.getProcessEventSupport().fireBeforeSLAViolated(this, kruntime);
            logger.debug("SLA violated on process instance {}", (Object)this.getId());
            this.slaCompliance = 3;
            this.slaTimerId = null;
            processRuntime.getProcessEventSupport().fireAfterSLAViolated(this, kruntime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalEvent(String type, Object event) {
        logger.debug("Signal {} received with data {} in process instance {}", type, event, this.getId());
        WorkflowProcessInstanceImpl workflowProcessInstanceImpl = this;
        synchronized (workflowProcessInstanceImpl) {
            TimerInstance timer;
            if (this.getState() != 1) {
                return;
            }
            if ("timerTriggered".equals(type) && (timer = (TimerInstance)event).getId().equals(this.slaTimerId)) {
                this.handleSLAViolation();
                return;
            }
            if ("slaViolation".equals(type)) {
                this.handleSLAViolation();
                return;
            }
            ArrayList<NodeInstance> currentView = new ArrayList<NodeInstance>(this.nodeInstances);
            try {
                this.activatingNodeIds = new ArrayList<String>();
                List<EventListener> listeners = this.eventListeners.get(type);
                if (listeners != null) {
                    for (EventListener listener : listeners) {
                        listener.signalEvent(type, event);
                    }
                }
                if ((listeners = this.externalEventListeners.get(type)) != null) {
                    for (EventListener listener : listeners) {
                        listener.signalEvent(type, event);
                    }
                }
                for (Node node : this.getWorkflowProcess().getNodes()) {
                    ExtendedNodeInstanceImpl eventNodeInstance;
                    if (!(node instanceof EventNodeInterface) || !((EventNodeInterface)((Object)node)).acceptsEvent(type, event, this.getResolver(node, currentView))) continue;
                    if (node instanceof EventNode && ((EventNode)node).getFrom() == null) {
                        eventNodeInstance = (EventNodeInstance)this.getNodeInstance(node);
                        ((EventNodeInstance)eventNodeInstance).signalEvent(type, event);
                        continue;
                    }
                    if (node instanceof EventSubProcessNode && this.resolveVariables(((EventSubProcessNode)node).getEvents()).contains(type)) {
                        eventNodeInstance = (EventSubProcessNodeInstance)this.getNodeInstance(node);
                        ((EventSubProcessNodeInstance)eventNodeInstance).signalEvent(type, event);
                    }
                    if (node instanceof DynamicNode && type.equals(((DynamicNode)node).getActivationEventName())) {
                        DynamicNodeInstance dynamicNodeInstance = (DynamicNodeInstance)this.getNodeInstance(node);
                        dynamicNodeInstance.signalEvent(type, event);
                        continue;
                    }
                    List<NodeInstance> nodeInstances = this.getNodeInstances(node.getId(), currentView);
                    if (nodeInstances == null || nodeInstances.isEmpty()) continue;
                    for (NodeInstance nodeInstance : nodeInstances) {
                        ((EventNodeInstanceInterface)((Object)nodeInstance)).signalEvent(type, event);
                    }
                }
                if (((WorkflowProcess)this.getWorkflowProcess()).isDynamic()) {
                    for (Node node : this.getWorkflowProcess().getNodes()) {
                        if (!type.equals(node.getName()) || !node.getIncomingConnections().isEmpty()) continue;
                        NodeInstance nodeInstance = this.getNodeInstance(node);
                        if (event != null) {
                            HashMap<String, Object> dynamicParams = new HashMap<String, Object>();
                            if (event instanceof Map) {
                                dynamicParams.putAll((Map)event);
                            } else {
                                dynamicParams.put("Data", event);
                            }
                            nodeInstance.setDynamicParameters(dynamicParams);
                        }
                        nodeInstance.trigger(null, "DROOLS_DEFAULT");
                    }
                }
            }
            finally {
                if (this.activatingNodeIds != null) {
                    this.activatingNodeIds.clear();
                    this.activatingNodeIds = null;
                }
            }
        }
    }

    private Function<String, String> getResolver(Node node, List<NodeInstance> currentView) {
        if (node instanceof DynamicNode) {
            return e -> {
                List<NodeInstance> nodeInstances = this.getNodeInstances(node.getId(), currentView);
                if (nodeInstances != null && !nodeInstances.isEmpty()) {
                    StringBuilder st = new StringBuilder();
                    for (NodeInstance ni : nodeInstances) {
                        String result = this.resolveVariable((String)e, new NodeInstanceResolverFactory(ni));
                        st.append(result).append("###");
                    }
                    return st.toString();
                }
                return this.resolveVariable((String)e);
            };
        }
        return this::resolveVariable;
    }

    protected List<String> resolveVariables(List<String> events) {
        return events.stream().map(this::resolveVariable).collect(Collectors.toList());
    }

    private String resolveVariable(String s) {
        return this.resolveVariable(s, new ProcessInstanceResolverFactory(this));
    }

    private String resolveVariable(String s, VariableResolverFactory factory) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        Matcher matcher = PatternConstants.PARAMETER_MATCHER.matcher(s);
        while (matcher.find()) {
            String paramName = matcher.group(1);
            if (replacements.get(paramName) != null) continue;
            Object variableValue = this.getVariable(paramName);
            if (variableValue != null) {
                replacements.put(paramName, variableValue.toString());
                continue;
            }
            try {
                variableValue = MVELSafeHelper.getEvaluator().eval(paramName, factory);
                String variableValueString = variableValue == null ? "" : variableValue.toString();
                replacements.put(paramName, variableValueString);
            }
            catch (Throwable t) {
                logger.error("Could not find variable scope for variable {}", (Object)paramName);
            }
        }
        for (Map.Entry replacement : replacements.entrySet()) {
            s = s.replace("#{" + (String)replacement.getKey() + "}", (CharSequence)replacement.getValue());
        }
        return s;
    }

    @Override
    public void addEventListener(String type, EventListener listener, boolean external) {
        Map<String, List<EventListener>> eventListeners = external ? this.externalEventListeners : this.eventListeners;
        List listeners = eventListeners.computeIfAbsent(type, listenerType -> {
            CopyOnWriteArrayList newListenersList = new CopyOnWriteArrayList();
            if (external) {
                ((InternalProcessRuntime)this.getKnowledgeRuntime().getProcessRuntime()).getSignalManager().addEventListener((String)listenerType, this);
            }
            return newListenersList;
        });
        listeners.add(listener);
    }

    @Override
    public void removeEventListener(String type, EventListener listener, boolean external) {
        Map<String, List<EventListener>> eventListeners = external ? this.externalEventListeners : this.eventListeners;
        List<EventListener> listeners = eventListeners.get(type);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                eventListeners.remove(type);
                if (external) {
                    ((InternalProcessRuntime)this.getKnowledgeRuntime().getProcessRuntime()).getSignalManager().removeEventListener(type, this);
                }
            }
        } else {
            eventListeners.remove(type);
        }
    }

    private void removeEventListeners() {
        for (String type : this.externalEventListeners.keySet()) {
            ((InternalProcessRuntime)this.getKnowledgeRuntime().getProcessRuntime()).getSignalManager().removeEventListener(type, this);
        }
    }

    @Override
    public String[] getEventTypes() {
        return this.externalEventListeners.keySet().stream().map(this::resolveVariable).collect(Collectors.toList()).toArray(new String[this.externalEventListeners.size()]);
    }

    @Override
    public void nodeInstanceCompleted(NodeInstance nodeInstance, String outType) {
        Node nodeInstanceNode = nodeInstance.getNode();
        if (nodeInstanceNode != null) {
            boolean isForCompensation;
            Object compensationBoolObj = nodeInstanceNode.getMetaData().get("isForCompensation");
            boolean bl = isForCompensation = compensationBoolObj != null && (Boolean)compensationBoolObj != false;
            if (isForCompensation) {
                return;
            }
        }
        if (nodeInstance instanceof FaultNodeInstance || nodeInstance instanceof EndNodeInstance || ((WorkflowProcess)this.getWorkflowProcess()).isDynamic() || nodeInstance instanceof CompositeNodeInstance) {
            if (((WorkflowProcess)this.getProcess()).isAutoComplete() && this.canComplete()) {
                this.setState(2);
            }
        } else {
            throw new IllegalArgumentException("Completing a node instance that has no outgoing connection is not supported.");
        }
    }

    private boolean canComplete() {
        if (this.nodeInstances.isEmpty()) {
            return true;
        }
        int eventSubprocessCounter = 0;
        for (NodeInstance nodeInstance : this.nodeInstances) {
            Node node = nodeInstance.getNode();
            if (node instanceof EventSubProcessNode) {
                if (!((EventSubProcessNodeInstance)nodeInstance).getNodeInstances().isEmpty()) continue;
                ++eventSubprocessCounter;
                continue;
            }
            return false;
        }
        return eventSubprocessCounter == this.nodeInstances.size();
    }

    public void addCompletedNodeId(String uniqueId) {
        this.completedNodeIds.add(uniqueId.intern());
    }

    public List<String> getCompletedNodeIds() {
        return new ArrayList<String>(this.completedNodeIds);
    }

    @Override
    public int getCurrentLevel() {
        return this.currentLevel;
    }

    @Override
    public void setCurrentLevel(int currentLevel) {
        this.currentLevel = currentLevel;
    }

    public Map<String, Integer> getIterationLevels() {
        return this.iterationLevels;
    }

    public void addActivatingNodeId(String uniqueId) {
        if (this.activatingNodeIds == null) {
            return;
        }
        this.activatingNodeIds.add(uniqueId.intern());
    }

    public List<String> getActivatingNodeIds() {
        if (this.activatingNodeIds == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(this.activatingNodeIds);
    }

    @Override
    public Object getFaultData() {
        return this.faultData;
    }

    @Override
    public boolean isSignalCompletion() {
        return this.signalCompletion;
    }

    @Override
    public void setSignalCompletion(boolean signalCompletion) {
        this.signalCompletion = signalCompletion;
    }

    @Override
    public String getDeploymentId() {
        return this.deploymentId;
    }

    @Override
    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public String getCorrelationKey() {
        if (this.correlationKey == null && this.getMetaData().get("CorrelationKey") != null) {
            this.correlationKey = ((CorrelationKey)this.getMetaData().get("CorrelationKey")).toExternalForm();
        }
        return this.correlationKey;
    }

    public void setCorrelationKey(String correlationKey) {
        this.correlationKey = correlationKey;
    }

    @Override
    public Date getStartDate() {
        return this.startDate;
    }

    @Override
    public Date getEndDate() {
        return this.endDate;
    }

    public void internalSetStartDate(Date startDate) {
        if (this.startDate == null) {
            this.startDate = startDate;
        }
    }

    protected boolean hasDeploymentId() {
        return this.deploymentId != null && !this.deploymentId.isEmpty();
    }

    protected boolean useAsync(Node node) {
        if (!(node instanceof EventSubProcessNode) && (node instanceof ActionNode || node instanceof StateBasedNode || node instanceof EndNode)) {
            boolean asyncMode = Boolean.parseBoolean((String)node.getMetaData().get("customAsync"));
            if (asyncMode) {
                return asyncMode;
            }
            return Boolean.parseBoolean((String)this.getKnowledgeRuntime().getEnvironment().get("AsyncMode"));
        }
        return false;
    }

    protected boolean useTimerSLATracking() {
        String mode = (String)this.getKnowledgeRuntime().getEnvironment().get("SLATimerMode");
        if (mode == null) {
            return true;
        }
        return Boolean.parseBoolean(mode);
    }

    @Override
    public int getSlaCompliance() {
        return this.slaCompliance;
    }

    public void internalSetSlaCompliance(int slaCompliance) {
        this.slaCompliance = slaCompliance;
    }

    @Override
    public Date getSlaDueDate() {
        return this.slaDueDate;
    }

    public void internalSetSlaDueDate(Date slaDueDate) {
        this.slaDueDate = slaDueDate;
    }

    public String getSlaTimerId() {
        return this.slaTimerId;
    }

    public void internalSetSlaTimerId(String slaTimerId) {
        this.slaTimerId = slaTimerId;
    }

    @Override
    public String getNodeIdInError() {
        return this.nodeIdInError;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    @Override
    public String getReferenceId() {
        return this.referenceId;
    }

    private boolean isVariableExpression(String eventType) {
        if (eventType == null) {
            return false;
        }
        Matcher matcher = PatternConstants.PARAMETER_MATCHER.matcher(eventType);
        return matcher.find();
    }

    @Override
    public void setErrorState(NodeInstance nodeInstanceInError, Exception e) {
        String errorId = UUID.randomUUID().toString();
        this.nodeIdInError = nodeInstanceInError.getNodeDefinitionId();
        Throwable rootException = this.getRootException(e);
        this.errorMessage = errorId + " - " + rootException.getClass().getCanonicalName() + " - " + rootException.getMessage();
        this.setState(5);
        logger.error("Unexpected error (id {}) while executing node {} in process instance {}", errorId, nodeInstanceInError.getNode().getName(), this.getId(), e);
        ((NodeInstanceContainer)nodeInstanceInError.getNodeInstanceContainer()).removeNodeInstance(nodeInstanceInError);
    }

    public void internalSetErrorNodeId(String errorNodeId) {
        this.nodeIdInError = errorNodeId;
    }

    public void internalSetErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    protected Throwable getRootException(Throwable exception) {
        Throwable rootException = exception;
        while (rootException.getCause() != null) {
            rootException = rootException.getCause();
        }
        return rootException;
    }
}

