/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.drools.core.process.instance.WorkItem;
import org.jbpm.process.instance.context.swimlane.SwimlaneContextInstance;
import org.jbpm.process.instance.impl.humantask.HumanTaskWorkItemImpl;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.kie.api.runtime.process.HumanTaskWorkItem;

public class HumanTaskNodeInstance
extends WorkItemNodeInstance {
    private static final long serialVersionUID = 510L;
    private String separator = System.getProperty("org.jbpm.ht.user.separator", ",");
    private static final String ACTOR_ID = "ActorId";
    private static final String GROUP_ID = "GroupId";
    private static final String BUSINESSADMINISTRATOR_ID = "BusinessAdministratorId";
    private static final String BUSINESSADMINISTRATOR_GROUP_ID = "BusinessAdministratorGroupId";
    private static final String EXCLUDED_OWNER_ID = "ExcludedOwnerId";
    protected static final List<String> INTERNAL_FIELDS = Arrays.asList("TaskName", "NodeName", "ActorId", "GroupId", "Priority", "Comment", "Skippable", "Content", "Locale");
    private transient SwimlaneContextInstance swimlaneContextInstance;

    public HumanTaskNode getHumanTaskNode() {
        return (HumanTaskNode)this.getNode();
    }

    @Override
    protected WorkItem newWorkItem() {
        return new HumanTaskWorkItemImpl();
    }

    @Override
    protected WorkItem createWorkItem(WorkItemNode workItemNode) {
        HumanTaskWorkItemImpl workItem = (HumanTaskWorkItemImpl)super.createWorkItem(workItemNode);
        String actorId = this.assignWorkItem(workItem);
        if (actorId != null) {
            workItem.setParameter(ACTOR_ID, actorId);
        }
        workItem.setTaskName((String)workItem.getParameter("NodeName"));
        workItem.setTaskDescription((String)workItem.getParameter("Description"));
        workItem.setTaskPriority((String)workItem.getParameter("Priority"));
        workItem.setReferenceName((String)workItem.getParameter("TaskName"));
        return workItem;
    }

    protected String assignWorkItem(WorkItem workItem) {
        String actorId = null;
        String swimlaneName = this.getHumanTaskNode().getSwimlane();
        SwimlaneContextInstance swimlaneContextInstance = this.getSwimlaneContextInstance(swimlaneName);
        if (swimlaneContextInstance != null) {
            actorId = swimlaneContextInstance.getActorId(swimlaneName);
            workItem.setParameter("SwimlaneActorId", actorId);
        }
        if (actorId == null && (actorId = (String)workItem.getParameter(ACTOR_ID)) != null && swimlaneContextInstance != null && actorId.split(this.separator).length == 1) {
            swimlaneContextInstance.setActorId(swimlaneName, actorId);
            workItem.setParameter("SwimlaneActorId", actorId);
        }
        this.processAssigment(ACTOR_ID, workItem, ((HumanTaskWorkItemImpl)workItem).getPotentialUsers());
        this.processAssigment(GROUP_ID, workItem, ((HumanTaskWorkItemImpl)workItem).getPotentialGroups());
        this.processAssigment(EXCLUDED_OWNER_ID, workItem, ((HumanTaskWorkItemImpl)workItem).getExcludedUsers());
        this.processAssigment(BUSINESSADMINISTRATOR_ID, workItem, ((HumanTaskWorkItemImpl)workItem).getAdminUsers());
        this.processAssigment(BUSINESSADMINISTRATOR_GROUP_ID, workItem, ((HumanTaskWorkItemImpl)workItem).getAdminGroups());
        return (String)workItem.getParameter(ACTOR_ID);
    }

    private SwimlaneContextInstance getSwimlaneContextInstance(String swimlaneName) {
        if (this.swimlaneContextInstance == null) {
            if (swimlaneName == null) {
                return null;
            }
            SwimlaneContextInstance swimlaneContextInstance = (SwimlaneContextInstance)this.resolveContextInstance("SwimlaneScope", swimlaneName);
            if (swimlaneContextInstance == null) {
                throw new IllegalArgumentException("Could not find swimlane context instance");
            }
            this.swimlaneContextInstance = swimlaneContextInstance;
        }
        return this.swimlaneContextInstance;
    }

    @Override
    public void triggerCompleted(WorkItem workItem) {
        String swimlaneName = this.getHumanTaskNode().getSwimlane();
        SwimlaneContextInstance swimlaneContextInstance = this.getSwimlaneContextInstance(swimlaneName);
        if (swimlaneContextInstance != null) {
            String newActorId;
            String string = newActorId = workItem instanceof HumanTaskWorkItem ? ((HumanTaskWorkItem)((Object)workItem)).getActualOwner() : (String)workItem.getParameter(ACTOR_ID);
            if (newActorId != null) {
                swimlaneContextInstance.setActorId(swimlaneName, newActorId);
            }
        }
        super.triggerCompleted(workItem);
    }

    protected void processAssigment(String type, WorkItem workItem, Set<String> store) {
        String value = (String)workItem.getParameter(type);
        if (value != null) {
            for (String item : value.split(this.separator)) {
                store.add(item);
            }
        }
    }
}

