/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import org.drools.core.common.InternalAgenda;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.spi.Activation;
import org.jbpm.workflow.core.node.MilestoneNode;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.node.StateBasedNodeInstance;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.AgendaGroupPoppedEvent;
import org.kie.api.event.rule.AgendaGroupPushedEvent;
import org.kie.api.event.rule.BeforeMatchFiredEvent;
import org.kie.api.event.rule.MatchCancelledEvent;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.event.rule.RuleFlowGroupActivatedEvent;
import org.kie.api.event.rule.RuleFlowGroupDeactivatedEvent;
import org.kie.api.runtime.process.NodeInstance;

public class MilestoneNodeInstance
extends StateBasedNodeInstance
implements AgendaEventListener {
    private static final long serialVersionUID = 510L;

    protected MilestoneNode getMilestoneNode() {
        return (MilestoneNode)this.getNode();
    }

    @Override
    public void internalTrigger(NodeInstance from, String type) {
        super.internalTrigger(from, type);
        if (this.getNodeInstanceContainer().getNodeInstance(this.getId()) == null) {
            return;
        }
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("A MilestoneNode only accepts default incoming connections!");
        }
        String rule = "RuleFlow-Milestone-" + this.getProcessInstance().getProcessId() + "-" + this.getMilestoneNode().getUniqueId();
        boolean isActive = ((InternalAgenda)this.getProcessInstance().getKnowledgeRuntime().getAgenda()).isRuleActiveInRuleFlowGroup("DROOLS_SYSTEM", rule, this.getProcessInstance().getId());
        if (isActive) {
            this.triggerCompleted();
        } else {
            this.addActivationEventListener();
        }
    }

    @Override
    public void addEventListeners() {
        super.addEventListeners();
        this.addActivationEventListener();
    }

    private void addActivationEventListener() {
        this.getProcessInstance().getKnowledgeRuntime().addEventListener(this);
        this.getProcessInstance().addEventListener(this.getActivationEventType(), this, true);
    }

    @Override
    public void removeEventListeners() {
        super.removeEventListeners();
        this.getProcessInstance().getKnowledgeRuntime().removeEventListener(this);
        this.getProcessInstance().removeEventListener(this.getActivationEventType(), this, true);
    }

    private String getActivationEventType() {
        return "RuleFlow-Milestone-" + this.getProcessInstance().getProcessId() + "-" + this.getMilestoneNode().getUniqueId();
    }

    @Override
    public void signalEvent(String type, Object event) {
        if (this.getActivationEventType().equals(type)) {
            if (event instanceof MatchCreatedEvent) {
                this.matchCreated((MatchCreatedEvent)event);
            }
        } else {
            super.signalEvent(type, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void matchCreated(MatchCreatedEvent event) {
        String ruleFlowGroup = ((RuleImpl)event.getMatch().getRule()).getRuleFlowGroup();
        if ("DROOLS_SYSTEM".equals(ruleFlowGroup)) {
            String ruleName = event.getMatch().getRule().getName();
            String milestoneName = "RuleFlow-Milestone-" + this.getProcessInstance().getProcessId() + "-" + this.getMilestoneNode().getUniqueId();
            if (milestoneName.equals(ruleName) && this.checkProcessInstance((Activation)event.getMatch()) && this.checkDeclarationMatch(event.getMatch(), this.getMilestoneNode().getMatchVariable())) {
                WorkflowProcessInstance workflowProcessInstance = this.getProcessInstance();
                synchronized (workflowProcessInstance) {
                    this.removeEventListeners();
                    this.triggerCompleted();
                }
            }
        }
    }

    @Override
    public void matchCancelled(MatchCancelledEvent event) {
    }

    @Override
    public void afterMatchFired(AfterMatchFiredEvent event) {
    }

    @Override
    public void agendaGroupPopped(AgendaGroupPoppedEvent event) {
    }

    @Override
    public void agendaGroupPushed(AgendaGroupPushedEvent event) {
    }

    @Override
    public void beforeMatchFired(BeforeMatchFiredEvent event) {
    }

    @Override
    public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
    }

    @Override
    public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
    }

    @Override
    public void beforeRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
    }

    @Override
    public void beforeRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
    }
}

