/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.infinispan.protostream;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashSet;
import org.infinispan.protostream.MessageMarshaller;
import org.kie.kogito.index.infinispan.protostream.AbstractMarshaller;
import org.kie.kogito.index.model.UserTaskInstance;

public class UserTaskInstanceMarshaller
extends AbstractMarshaller
implements MessageMarshaller<UserTaskInstance> {
    public UserTaskInstanceMarshaller(ObjectMapper mapper) {
        super(mapper);
    }

    @Override
    public UserTaskInstance readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
        UserTaskInstance ut = new UserTaskInstance();
        ut.setId(reader.readString("id"));
        ut.setDescription(reader.readString("description"));
        ut.setName(reader.readString("name"));
        ut.setPriority(reader.readString("priority"));
        ut.setProcessInstanceId(reader.readString("processInstanceId"));
        ut.setProcessId(reader.readString("processId"));
        ut.setRootProcessInstanceId(reader.readString("rootProcessInstanceId"));
        ut.setRootProcessId(reader.readString("rootProcessId"));
        ut.setState(reader.readString("state"));
        ut.setActualOwner(reader.readString("actualOwner"));
        ut.setAdminGroups(reader.readCollection("adminGroups", new HashSet(), String.class));
        ut.setAdminUsers(reader.readCollection("adminUsers", new HashSet(), String.class));
        ut.setCompleted(this.dateToZonedDateTime(reader.readDate("completed")));
        ut.setStarted(this.dateToZonedDateTime(reader.readDate("started")));
        ut.setExcludedUsers(reader.readCollection("excludedUsers", new HashSet(), String.class));
        ut.setPotentialGroups(reader.readCollection("potentialGroups", new HashSet(), String.class));
        ut.setPotentialUsers(reader.readCollection("potentialUsers", new HashSet(), String.class));
        ut.setInputs(this.jsonFromString(reader.readString("inputs")));
        ut.setOutputs(this.jsonFromString(reader.readString("outputs")));
        ut.setReferenceName(reader.readString("referenceName"));
        ut.setLastUpdate(this.dateToZonedDateTime(reader.readDate("lastUpdate")));
        return ut;
    }

    @Override
    public void writeTo(MessageMarshaller.ProtoStreamWriter writer, UserTaskInstance ut) throws IOException {
        writer.writeString("id", ut.getId());
        writer.writeString("description", ut.getDescription());
        writer.writeString("name", ut.getName());
        writer.writeString("priority", ut.getPriority());
        writer.writeString("processInstanceId", ut.getProcessInstanceId());
        writer.writeString("processId", ut.getProcessId());
        writer.writeString("rootProcessInstanceId", ut.getRootProcessInstanceId());
        writer.writeString("rootProcessId", ut.getRootProcessId());
        writer.writeString("state", ut.getState());
        writer.writeString("actualOwner", ut.getActualOwner());
        writer.writeCollection("adminGroups", ut.getAdminGroups(), String.class);
        writer.writeCollection("adminUsers", ut.getAdminUsers(), String.class);
        writer.writeDate("completed", this.zonedDateTimeToDate(ut.getCompleted()));
        writer.writeDate("started", this.zonedDateTimeToDate(ut.getStarted()));
        writer.writeCollection("excludedUsers", ut.getExcludedUsers(), String.class);
        writer.writeCollection("potentialGroups", ut.getPotentialGroups(), String.class);
        writer.writeCollection("potentialUsers", ut.getPotentialUsers(), String.class);
        writer.writeString("inputs", ut.getInputs() == null ? null : ut.getInputs().toString());
        writer.writeString("outputs", ut.getOutputs() == null ? null : ut.getOutputs().toString());
        writer.writeString("referenceName", ut.getReferenceName());
        writer.writeDate("lastUpdate", this.zonedDateTimeToDate(ut.getLastUpdate()));
    }

    @Override
    public Class<? extends UserTaskInstance> getJavaClass() {
        return UserTaskInstance.class;
    }

    @Override
    public String getTypeName() {
        return this.getJavaClass().getName();
    }
}

