/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.json;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Set;
import java.util.function.Function;
import org.kie.kogito.index.event.KogitoUserTaskCloudEvent;
import org.kie.kogito.index.json.JsonUtils;
import org.kie.kogito.index.model.UserTaskInstance;

public class UserTaskInstanceMetaMapper
implements Function<KogitoUserTaskCloudEvent, ObjectNode> {
    @Override
    public ObjectNode apply(KogitoUserTaskCloudEvent event) {
        if (event == null) {
            return null;
        }
        UserTaskInstance ut = (UserTaskInstance)event.getData();
        ObjectNode json = JsonUtils.getObjectMapper().createObjectNode();
        json.put("id", event.getRootProcessInstanceId() == null ? event.getProcessInstanceId() : event.getRootProcessInstanceId());
        json.put("processId", event.getRootProcessId() == null ? event.getProcessId() : event.getRootProcessId());
        ObjectNode kogito = JsonUtils.getObjectMapper().createObjectNode();
        kogito.put("lastUpdate", event.getTime().toInstant().toEpochMilli());
        kogito.withArray("userTasks").add(this.getUserTaskJson(ut));
        json.set("metadata", kogito);
        return json;
    }

    private ObjectNode getUserTaskJson(UserTaskInstance ut) {
        ObjectNode json = JsonUtils.getObjectMapper().createObjectNode();
        json.put("id", ut.getId());
        json.put("processInstanceId", ut.getProcessInstanceId());
        json.put("state", ut.getState());
        if (ut.getDescription() != null) {
            json.put("description", ut.getDescription());
        }
        if (ut.getName() != null) {
            json.put("name", ut.getName());
        }
        if (ut.getPriority() != null) {
            json.put("priority", ut.getPriority());
        }
        if (ut.getActualOwner() != null) {
            json.put("actualOwner", ut.getActualOwner());
        }
        this.mapArray("adminUsers", ut.getAdminUsers(), json);
        this.mapArray("adminGroups", ut.getAdminGroups(), json);
        this.mapArray("excludedUsers", ut.getExcludedUsers(), json);
        this.mapArray("potentialGroups", ut.getPotentialGroups(), json);
        this.mapArray("potentialUsers", ut.getPotentialUsers(), json);
        if (ut.getCompleted() != null) {
            json.put("completed", ut.getCompleted().toInstant().toEpochMilli());
        }
        if (ut.getStarted() != null) {
            json.put("started", ut.getStarted().toInstant().toEpochMilli());
        }
        if (ut.getLastUpdate() != null) {
            json.put("lastUpdate", ut.getLastUpdate().toInstant().toEpochMilli());
        }
        return json;
    }

    private void mapArray(String attribute, Set<String> strings, ObjectNode json) {
        if (strings != null && !strings.isEmpty()) {
            ArrayNode array = json.withArray(attribute);
            strings.forEach(s -> array.add((String)s));
        }
    }
}

