/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.services.event;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import org.kie.kogito.event.DataEvent;

public abstract class AbstractProcessDataEvent<T>
implements DataEvent<T> {
    private static final String SPEC_VERSION = "0.3";
    protected String specversion = "0.3";
    protected String id = UUID.randomUUID().toString();
    protected String source;
    protected String type;
    protected String time;
    protected T data;
    protected String kogitoProcessinstanceId;
    protected String kogitoParentProcessinstanceId;
    protected String kogitoRootProcessinstanceId;
    protected String kogitoProcessId;
    protected String kogitoRootProcessId;
    protected String kogitoProcessinstanceState;
    protected String kogitoReferenceId;
    protected String kogitoAddons;

    public AbstractProcessDataEvent(String source, T body, String kogitoProcessinstanceId, String kogitoParentProcessinstanceId, String kogitoRootProcessinstanceId, String kogitoProcessId, String kogitoRootProcessId, String kogitoProcessinstanceState, String kogitoAddons) {
        this.source = source;
        this.type = this.getClass().getSimpleName();
        this.time = ZonedDateTime.now().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        this.data = body;
        this.kogitoProcessinstanceId = kogitoProcessinstanceId;
        this.kogitoParentProcessinstanceId = kogitoParentProcessinstanceId;
        this.kogitoRootProcessinstanceId = kogitoRootProcessinstanceId;
        this.kogitoProcessId = kogitoProcessId;
        this.kogitoRootProcessId = kogitoRootProcessId;
        this.kogitoProcessinstanceState = kogitoProcessinstanceState;
        this.kogitoAddons = kogitoAddons;
    }

    public AbstractProcessDataEvent(String type, String source, T body, String kogitoProcessinstanceId, String kogitoParentProcessinstanceId, String kogitoRootProcessinstanceId, String kogitoProcessId, String kogitoRootProcessId, String kogitoProcessinstanceState, String kogitoAddons) {
        this.source = source;
        this.type = type;
        this.time = ZonedDateTime.now().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        this.data = body;
        this.kogitoProcessinstanceId = kogitoProcessinstanceId;
        this.kogitoParentProcessinstanceId = kogitoParentProcessinstanceId;
        this.kogitoRootProcessinstanceId = kogitoRootProcessinstanceId;
        this.kogitoProcessId = kogitoProcessId;
        this.kogitoRootProcessId = kogitoRootProcessId;
        this.kogitoProcessinstanceState = kogitoProcessinstanceState;
        this.kogitoAddons = kogitoAddons;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public String getSpecversion() {
        return this.specversion;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getTime() {
        return this.time;
    }

    @Override
    public T getData() {
        return this.data;
    }

    public String getKogitoProcessinstanceId() {
        return this.kogitoProcessinstanceId;
    }

    public String getKogitoParentProcessinstanceId() {
        return this.kogitoParentProcessinstanceId;
    }

    public String getKogitoRootProcessinstanceId() {
        return this.kogitoRootProcessinstanceId;
    }

    public String getKogitoProcessId() {
        return this.kogitoProcessId;
    }

    public String getKogitoRootProcessId() {
        return this.kogitoRootProcessId;
    }

    public String getKogitoProcessinstanceState() {
        return this.kogitoProcessinstanceState;
    }

    public String getKogitoReferenceId() {
        return this.kogitoReferenceId;
    }

    public void setKogitoReferenceId(String kogitoReferenceId) {
        this.kogitoReferenceId = kogitoReferenceId;
    }

    public String getKogitoAddons() {
        return this.kogitoAddons;
    }
}

