/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.vertx;

import graphql.GraphQL;
import io.vertx.core.Handler;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.FaviconHandler;
import io.vertx.ext.web.handler.LoggerHandler;
import io.vertx.ext.web.handler.StaticHandler;
import io.vertx.ext.web.handler.graphql.ApolloWSHandler;
import io.vertx.ext.web.handler.graphql.GraphQLHandler;
import io.vertx.ext.web.handler.graphql.GraphQLHandlerOptions;
import io.vertx.ext.web.handler.graphql.GraphiQLHandler;
import io.vertx.ext.web.handler.graphql.GraphiQLHandlerOptions;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class VertxRouterSetup {
    @Inject
    @ConfigProperty(name="quarkus.oidc.enabled", defaultValue="false")
    Boolean authEnabled;
    @Inject
    GraphQL graphQL;

    void setupRouter(@Observes Router router) {
        if (Boolean.FALSE.equals(this.authEnabled)) {
            router.route("/graphiql/*").handler((Handler)GraphiQLHandler.create((GraphiQLHandlerOptions)new GraphiQLHandlerOptions().setEnabled(true)));
            router.route().handler((Handler)LoggerHandler.create());
            router.route().handler((Handler)StaticHandler.create());
            router.route().handler((Handler)FaviconHandler.create());
            router.route("/").handler(ctx -> ctx.response().putHeader("location", "/graphiql/").setStatusCode(302).end());
        }
        router.route("/graphql").handler((Handler)ApolloWSHandler.create((GraphQL)this.graphQL));
        router.route("/graphql").handler((Handler)GraphQLHandler.create((GraphQL)this.graphQL, (GraphQLHandlerOptions)new GraphQLHandlerOptions()));
    }
}

