/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.infinispan.client.runtime;

import io.quarkus.infinispan.client.runtime.InfinispanClientRuntimeConfig;
import io.quarkus.infinispan.client.runtime.Remote;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.RemoteCounterManagerFactory;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;

@ApplicationScoped
public class InfinispanClientProducer {
    private static final Log log = LogFactory.getLog(InfinispanClientProducer.class);
    public static final String PROTOBUF_FILE_PREFIX = "infinispan.client.hotrod.protofile.";
    public static final String PROTOBUF_INITIALIZERS = "infinispan.client.hotrod.proto-initializers";
    @Inject
    private BeanManager beanManager;
    private Properties properties;
    private RemoteCacheManager cacheManager;
    private InfinispanClientRuntimeConfig infinispanClientRuntimeConfig;

    public void setRuntimeConfig(InfinispanClientRuntimeConfig infinispanClientConfigRuntime) {
        this.infinispanClientRuntimeConfig = infinispanClientConfigRuntime;
    }

    private void initialize() {
        log.debug("Initializing CacheManager");
        Configuration conf = this.properties == null ? new ConfigurationBuilder().build() : this.builderFromProperties(this.properties).build();
        this.cacheManager = new RemoteCacheManager(conf);
        BasicCache protobufMetadataCache = null;
        Set initializers = (Set)this.properties.remove(PROTOBUF_INITIALIZERS);
        if (initializers != null) {
            for (SerializationContextInitializer serializationContextInitializer : initializers) {
                if (protobufMetadataCache == null) {
                    protobufMetadataCache = this.cacheManager.getCache("___protobuf_metadata");
                }
                protobufMetadataCache.put(serializationContextInitializer.getProtoFileName(), serializationContextInitializer.getProtoFile());
            }
        }
        for (Map.Entry entry : this.properties.entrySet()) {
            String keyString;
            Object key = entry.getKey();
            if (!(key instanceof String) || !(keyString = (String)key).startsWith(PROTOBUF_FILE_PREFIX)) continue;
            String fileName = keyString.substring(PROTOBUF_FILE_PREFIX.length());
            String fileContents = (String)entry.getValue();
            if (protobufMetadataCache == null) {
                protobufMetadataCache = this.cacheManager.getCache("___protobuf_metadata");
            }
            protobufMetadataCache.put(fileName, fileContents);
        }
    }

    public static void replaceProperties(Properties properties) throws ClassNotFoundException {
        String marshallerClassName = (String)properties.get("infinispan.client.hotrod.marshaller");
        if (marshallerClassName != null) {
            Class<?> marshallerClass = Class.forName(marshallerClassName);
            properties.put("infinispan.client.hotrod.marshaller", Util.getInstance(marshallerClass));
        } else {
            properties.put("infinispan.client.hotrod.marshaller", new ProtoStreamMarshaller());
        }
    }

    public static void handleProtoStreamRequirements(Properties properties) {
        properties.put("infinispan.client.hotrod.protofile.org/infinispan/protostream/message-wrapping.proto", InfinispanClientProducer.getContents("/org/infinispan/protostream/message-wrapping.proto"));
        String queryProtoFile = "org/infinispan/query/remote/client/query.proto";
        properties.put(PROTOBUF_FILE_PREFIX + queryProtoFile, InfinispanClientProducer.getContents("/" + queryProtoFile));
    }

    private static String getContents(String fileName) {
        InputStream stream = InfinispanClientProducer.class.getResourceAsStream(fileName);
        try (Scanner scanner = new Scanner(stream, "UTF-8");){
            String string = scanner.useDelimiter("\\A").next();
            return string;
        }
    }

    private ConfigurationBuilder builderFromProperties(Properties properties) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        Object marshallerInstance = properties.remove("infinispan.client.hotrod.marshaller");
        if (marshallerInstance != null) {
            if (marshallerInstance instanceof ProtoStreamMarshaller) {
                InfinispanClientProducer.handleProtoStreamMarshaller((ProtoStreamMarshaller)marshallerInstance, properties, this.beanManager);
            }
            builder.marshaller((Marshaller)marshallerInstance);
        }
        if (this.infinispanClientRuntimeConfig != null) {
            this.infinispanClientRuntimeConfig.serverList.ifPresent(v -> properties.put("infinispan.client.hotrod.server_list", v));
            this.infinispanClientRuntimeConfig.clientIntelligence.ifPresent(v -> properties.put("infinispan.client.hotrod.client_intelligence", v));
            this.infinispanClientRuntimeConfig.useAuth.ifPresent(v -> properties.put("infinispan.client.hotrod.use_auth", v));
            this.infinispanClientRuntimeConfig.authUsername.ifPresent(v -> properties.put("infinispan.client.hotrod.auth_username", v));
            this.infinispanClientRuntimeConfig.authPassword.ifPresent(v -> properties.put("infinispan.client.hotrod.auth_password", v));
            this.infinispanClientRuntimeConfig.authRealm.ifPresent(v -> properties.put("infinispan.client.hotrod.auth_realm", v));
            this.infinispanClientRuntimeConfig.authServerName.ifPresent(v -> properties.put("infinispan.client.hotrod.auth_server_name", v));
            this.infinispanClientRuntimeConfig.authClientSubject.ifPresent(v -> properties.put("infinispan.client.hotrod.auth_client_subject", v));
            this.infinispanClientRuntimeConfig.authCallbackHandler.ifPresent(v -> properties.put("infinispan.client.hotrod.auth_callback_handler", v));
            this.infinispanClientRuntimeConfig.saslMechanism.ifPresent(v -> properties.put("infinispan.client.hotrod.sasl_mechanism", v));
        }
        builder.withProperties(properties);
        return builder;
    }

    private static void handleProtoStreamMarshaller(ProtoStreamMarshaller marshaller, Properties properties, BeanManager beanManager) {
        SerializationContext serializationContext = marshaller.getSerializationContext();
        Set initializers = (Set)properties.get(PROTOBUF_INITIALIZERS);
        if (initializers != null) {
            initializers.forEach(sci -> {
                sci.registerSchema(serializationContext);
                sci.registerMarshallers(serializationContext);
            });
        }
        FileDescriptorSource fileDescriptorSource = null;
        for (Map.Entry<Object, Object> property : properties.entrySet()) {
            String keyString;
            Object object = property.getKey();
            if (!(object instanceof String) || !(keyString = (String)object).startsWith(PROTOBUF_FILE_PREFIX)) continue;
            String fileName = keyString.substring(PROTOBUF_FILE_PREFIX.length());
            String fileContents = (String)property.getValue();
            if (fileDescriptorSource == null) {
                fileDescriptorSource = new FileDescriptorSource();
            }
            fileDescriptorSource.addProtoFile(fileName, fileContents);
        }
        if (fileDescriptorSource != null) {
            serializationContext.registerProtoFiles(fileDescriptorSource);
        }
        Set<Bean<?>> protoFileBeans = beanManager.getBeans((Type)((Object)FileDescriptorSource.class), new Annotation[0]);
        for (Bean bean : protoFileBeans) {
            CreationalContext ctx = beanManager.createCreationalContext(bean);
            FileDescriptorSource fds = (FileDescriptorSource)beanManager.getReference(bean, (Type)((Object)FileDescriptorSource.class), ctx);
            serializationContext.registerProtoFiles(fds);
            for (Map.Entry entry : fds.getFileDescriptors().entrySet()) {
                properties.put(PROTOBUF_FILE_PREFIX + (String)entry.getKey(), new String((char[])entry.getValue()));
            }
        }
        Set<Bean<?>> beans = beanManager.getBeans((Type)((Object)BaseMarshaller.class), new Annotation[0]);
        for (Bean<?> bean : beans) {
            CreationalContext<?> ctx = beanManager.createCreationalContext(bean);
            BaseMarshaller messageMarshaller = (BaseMarshaller)beanManager.getReference(bean, (Type)((Object)BaseMarshaller.class), ctx);
            serializationContext.registerMarshaller(messageMarshaller);
        }
    }

    @PreDestroy
    public void destroy() {
        if (this.cacheManager != null) {
            this.cacheManager.stop();
        }
    }

    @io.quarkus.infinispan.client.Remote
    @Remote
    @Produces
    public <K, V> RemoteCache<K, V> getRemoteCache(InjectionPoint injectionPoint, RemoteCacheManager cacheManager) {
        Set<Annotation> annotationSet = injectionPoint.getQualifiers();
        io.quarkus.infinispan.client.Remote remote = this.getRemoteAnnotation(annotationSet);
        if (remote != null && !remote.value().isEmpty()) {
            return cacheManager.getCache(remote.value());
        }
        Remote deprecatedRemote = this.getDeprecatedRemoteAnnotation(annotationSet);
        if (deprecatedRemote != null && !deprecatedRemote.value().isEmpty()) {
            return cacheManager.getCache(deprecatedRemote.value());
        }
        return cacheManager.getCache();
    }

    @Produces
    public CounterManager counterManager() {
        return RemoteCounterManagerFactory.asCounterManager(this.remoteCacheManager());
    }

    @Produces
    public synchronized RemoteCacheManager remoteCacheManager() {
        if (this.cacheManager != null) {
            return this.cacheManager;
        }
        this.initialize();
        return this.cacheManager;
    }

    void configure(Properties properties) {
        this.properties = properties;
    }

    private io.quarkus.infinispan.client.Remote getRemoteAnnotation(Set<Annotation> annotationSet) {
        for (Annotation annotation : annotationSet) {
            if (!(annotation instanceof io.quarkus.infinispan.client.Remote)) continue;
            return (io.quarkus.infinispan.client.Remote)annotation;
        }
        return null;
    }

    private Remote getDeprecatedRemoteAnnotation(Set<Annotation> annotationSet) {
        for (Annotation annotation : annotationSet) {
            if (!(annotation instanceof Remote)) continue;
            return (Remote)annotation;
        }
        return null;
    }
}

