/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.oidc.AccessTokenCredential;
import io.quarkus.oidc.IdTokenCredential;
import io.quarkus.oidc.RefreshToken;
import io.quarkus.oidc.runtime.AbstractOidcAuthenticationMechanism;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.quarkus.vertx.http.runtime.security.AuthenticationRedirectException;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.vertx.core.AsyncResult;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.oauth2.AccessToken;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.CookieImpl;
import java.net.URI;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.logging.Logger;

@ApplicationScoped
public class CodeAuthenticationMechanism
extends AbstractOidcAuthenticationMechanism {
    private static final Logger LOG = Logger.getLogger(CodeAuthenticationMechanism.class);
    private static final String STATE_COOKIE_NAME = "q_auth";
    private static final String SESSION_COOKIE_NAME = "q_session";
    private static final String COOKIE_DELIM = "___";

    private static QuarkusSecurityIdentity augmentIdentity(final SecurityIdentity securityIdentity, String accessToken, String refreshToken) {
        RefreshToken refreshTokenCredential = new RefreshToken(refreshToken);
        return QuarkusSecurityIdentity.builder().setPrincipal(securityIdentity.getPrincipal()).addCredentials(securityIdentity.getCredentials()).addCredential(new AccessTokenCredential(accessToken, refreshTokenCredential)).addCredential(refreshTokenCredential).addRoles(securityIdentity.getRoles()).addAttributes(securityIdentity.getAttributes()).addPermissionChecker(new Function<Permission, CompletionStage<Boolean>>(){

            @Override
            public CompletionStage<Boolean> apply(Permission permission) {
                return securityIdentity.checkPermission(permission);
            }
        }).build();
    }

    @Override
    public CompletionStage<SecurityIdentity> authenticate(RoutingContext context, IdentityProviderManager identityProviderManager) {
        Cookie sessionCookie = context.request().getCookie(SESSION_COOKIE_NAME);
        if (sessionCookie != null) {
            final String[] tokens = sessionCookie.getValue().split(COOKIE_DELIM);
            return this.authenticate(identityProviderManager, new IdTokenCredential(tokens[0])).thenCompose(new Function<SecurityIdentity, CompletionStage<SecurityIdentity>>(){

                @Override
                public CompletionStage<SecurityIdentity> apply(SecurityIdentity securityIdentity) {
                    return CompletableFuture.completedFuture(CodeAuthenticationMechanism.augmentIdentity(securityIdentity, tokens[1], tokens[2]));
                }
            });
        }
        return this.performCodeFlow(identityProviderManager, context);
    }

    @Override
    public CompletionStage<ChallengeData> getChallenge(RoutingContext context) {
        this.removeCookie(context, SESSION_COOKIE_NAME);
        JsonObject params = new JsonObject();
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add("openid");
        this.config.authentication.scopes.ifPresent(scopes::addAll);
        params.put("scopes", new JsonArray(scopes));
        URI absoluteUri = URI.create(context.request().absoluteURI());
        String dynamicPath = this.getDynamicPath(context, absoluteUri);
        params.put("redirect_uri", this.buildCodeRedirectUri(context, absoluteUri, dynamicPath));
        params.put("state", this.generateState(context, dynamicPath));
        ChallengeData challenge = new ChallengeData(HttpResponseStatus.FOUND.code(), HttpHeaders.LOCATION, this.auth.authorizeURL(params));
        return CompletableFuture.completedFuture(challenge);
    }

    private CompletionStage<SecurityIdentity> performCodeFlow(IdentityProviderManager identityProviderManager, RoutingContext context) {
        JsonObject params = new JsonObject();
        String code = context.request().getParam("code");
        if (code == null) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<SecurityIdentity> cf = new CompletableFuture<SecurityIdentity>();
        URI absoluteUri = URI.create(context.request().absoluteURI());
        io.vertx.ext.web.Cookie stateCookie = context.getCookie(STATE_COOKIE_NAME);
        if (stateCookie != null) {
            List<String> values = context.queryParam("state");
            if (values.size() != 1 || !stateCookie.getValue().startsWith(values.get(0))) {
                cf.completeExceptionally(new AuthenticationFailedException());
                return cf;
            }
            if (context.queryParam("pathChecked").isEmpty()) {
                String[] pair = stateCookie.getValue().split(COOKIE_DELIM);
                if (pair.length == 2) {
                    String extraPath = pair[1];
                    String extraQuery = "?pathChecked=true";
                    if (absoluteUri.getRawQuery() != null) {
                        extraQuery = extraQuery + "&" + absoluteUri.getRawQuery();
                    }
                    String localRedirectUri = this.buildLocalRedirectUri(context, absoluteUri, extraPath + extraQuery);
                    LOG.debug("Local redirectUri: " + localRedirectUri);
                    cf.completeExceptionally(new AuthenticationRedirectException(localRedirectUri));
                    return cf;
                }
                this.removeCookie(context, STATE_COOKIE_NAME);
            } else {
                this.removeCookie(context, STATE_COOKIE_NAME);
            }
        } else {
            cf.completeExceptionally(new AuthenticationFailedException());
            return cf;
        }
        params.put("code", code);
        params.put("redirect_uri", this.buildCodeRedirectUri(context, absoluteUri, this.getDynamicPath(context, absoluteUri)));
        this.auth.authenticate(params, (AsyncResult<User> userAsyncResult) -> {
            if (userAsyncResult.failed()) {
                cf.completeExceptionally(new AuthenticationFailedException());
            } else {
                AccessToken result = (AccessToken)AccessToken.class.cast(userAsyncResult.result());
                this.authenticate(identityProviderManager, new IdTokenCredential(result.opaqueIdToken())).whenCompleteAsync((securityIdentity, throwable) -> {
                    if (throwable != null) {
                        cf.completeExceptionally((Throwable)throwable);
                    } else {
                        this.processSuccessfulAuthentication(context, cf, result, (SecurityIdentity)securityIdentity);
                    }
                });
            }
        });
        return cf;
    }

    private void processSuccessfulAuthentication(RoutingContext context, CompletableFuture<SecurityIdentity> cf, AccessToken result, SecurityIdentity securityIdentity) {
        this.removeCookie(context, SESSION_COOKIE_NAME);
        CookieImpl cookie = new CookieImpl(SESSION_COOKIE_NAME, result.opaqueIdToken() + COOKIE_DELIM + result.opaqueAccessToken() + COOKIE_DELIM + result.opaqueRefreshToken());
        cookie.setMaxAge(result.idToken().getInteger("exp").intValue());
        cookie.setSecure(context.request().isSSL());
        cookie.setHttpOnly(true);
        context.response().addCookie(cookie);
        cf.complete(CodeAuthenticationMechanism.augmentIdentity(securityIdentity, result.opaqueAccessToken(), result.opaqueRefreshToken()));
    }

    private String getDynamicPath(RoutingContext context, URI absoluteUri) {
        if (this.config.authentication.redirectPath.isPresent()) {
            String redirectPath = this.config.authentication.redirectPath.get();
            String requestPath = absoluteUri.getRawPath();
            if (requestPath.startsWith(redirectPath) && requestPath.length() > redirectPath.length()) {
                return requestPath.substring(redirectPath.length());
            }
        }
        return null;
    }

    private String generateState(RoutingContext context, String dynamicPath) {
        String uuid;
        String cookieValue = uuid = UUID.randomUUID().toString();
        if (dynamicPath != null) {
            cookieValue = cookieValue + COOKIE_DELIM + dynamicPath;
        }
        CookieImpl cookie = new CookieImpl(STATE_COOKIE_NAME, cookieValue);
        cookie.setHttpOnly(true);
        cookie.setSecure(context.request().isSSL());
        cookie.setMaxAge(1800L);
        context.response().addCookie(cookie);
        return uuid;
    }

    private String buildCodeRedirectUri(RoutingContext context, URI absoluteUri, String dynamicPath) {
        StringBuilder builder = new StringBuilder(context.request().scheme()).append("://").append(absoluteUri.getAuthority());
        String path = dynamicPath != null ? this.config.authentication.redirectPath.get() : absoluteUri.getRawPath();
        return builder.append(path).toString();
    }

    private String buildLocalRedirectUri(RoutingContext context, URI absoluteUri, String extraPath) {
        return context.request().scheme() + "://" + absoluteUri.getAuthority() + absoluteUri.getRawPath() + extraPath;
    }

    private Cookie removeCookie(RoutingContext context, String cookieName) {
        return context.response().removeCookie(cookieName, true);
    }
}

