/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.runtime;

import io.quarkus.security.credential.Credential;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.runtime.SecurityIdentityAssociation;
import java.security.Permission;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;

@RequestScoped
public class SecurityIdentityProxy
implements SecurityIdentity {
    @Inject
    SecurityIdentityAssociation association;

    @Override
    public Principal getPrincipal() {
        return this.association.getIdentity().getPrincipal();
    }

    @Override
    public boolean isAnonymous() {
        return this.association.getIdentity().isAnonymous();
    }

    @Override
    public Set<String> getRoles() {
        return this.association.getIdentity().getRoles();
    }

    @Override
    public boolean hasRole(String role) {
        return this.association.getIdentity().hasRole(role);
    }

    @Override
    public <T extends Credential> T getCredential(Class<T> credentialType) {
        return this.association.getIdentity().getCredential(credentialType);
    }

    @Override
    public Set<Credential> getCredentials() {
        return this.association.getIdentity().getCredentials();
    }

    @Override
    public <T> T getAttribute(String name) {
        return this.association.getIdentity().getAttribute(name);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.association.getIdentity().getAttributes();
    }

    @Override
    public CompletionStage<Boolean> checkPermission(Permission permission) {
        return this.association.getIdentity().checkPermission(permission);
    }

    @Override
    public boolean checkPermissionBlocking(Permission permission) {
        return this.association.getIdentity().checkPermissionBlocking(permission);
    }
}

