/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.security.identity.SecurityIdentity;
import io.vertx.ext.web.RoutingContext;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;

public interface HttpSecurityPolicy {
    public CompletionStage<CheckResult> checkPermission(RoutingContext var1, SecurityIdentity var2, AuthorizationRequestContext var3);

    public static interface AuthorizationRequestContext {
        public CompletionStage<CheckResult> runBlocking(RoutingContext var1, SecurityIdentity var2, BiFunction<RoutingContext, SecurityIdentity, CheckResult> var3);
    }

    public static class CheckResult {
        public static CheckResult DENY = new CheckResult(false);
        public static CheckResult PERMIT = new CheckResult(true);
        private final boolean permitted;
        private final SecurityIdentity augmentedIdentity;

        public CheckResult(boolean permitted) {
            this.permitted = permitted;
            this.augmentedIdentity = null;
        }

        public CheckResult(boolean permitted, SecurityIdentity augmentedIdentity) {
            this.permitted = permitted;
            this.augmentedIdentity = augmentedIdentity;
        }

        public boolean isPermitted() {
            return this.permitted;
        }

        public SecurityIdentity getAugmentedIdentity() {
            return this.augmentedIdentity;
        }
    }
}

