/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.inject;

import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.inject.ConfigExtension;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Provider;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class ConfigInjectionBean<T>
implements Bean<T>,
PassivationCapable {
    private static final Set<Annotation> QUALIFIERS = new HashSet<Annotation>();
    private final BeanManager bm;
    private final Class clazz;
    private Config _config;

    public ConfigInjectionBean(BeanManager bm, Class clazz) {
        this.bm = bm;
        this.clazz = clazz;
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    @Override
    public Class<?> getBeanClass() {
        return ConfigInjectionBean.class;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public T create(CreationalContext<T> context) {
        InjectionPoint ip = (InjectionPoint)this.bm.getInjectableReference(new InjectionPointMetadataInjectionPoint(), context);
        Annotated annotated = ip.getAnnotated();
        ConfigProperty configProperty = annotated.getAnnotation(ConfigProperty.class);
        String key = ConfigExtension.getConfigKey(ip, configProperty);
        String defaultValue = configProperty.defaultValue();
        if (annotated.getBaseType() instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)annotated.getBaseType();
            Type rawType = paramType.getRawType();
            if (rawType instanceof Class && ((Class)rawType).isAssignableFrom(Provider.class) && paramType.getActualTypeArguments().length == 1) {
                Class paramTypeClass = (Class)paramType.getActualTypeArguments()[0];
                return this.getConfig().getValue(key, paramTypeClass);
            }
        } else {
            Class annotatedTypeClass = (Class)annotated.getBaseType();
            if (defaultValue == null || defaultValue.length() == 0) {
                return this.getConfig().getValue(key, annotatedTypeClass);
            }
            Config config = this.getConfig();
            Optional optionalValue = config.getOptionalValue(key, annotatedTypeClass);
            if (optionalValue.isPresent()) {
                return optionalValue.get();
            }
            return ((SmallRyeConfig)config).convert(defaultValue, annotatedTypeClass);
        }
        throw new IllegalStateException("unhandled ConfigProperty");
    }

    public Config getConfig() {
        if (this._config == null) {
            this._config = ConfigProvider.getConfig();
        }
        return this._config;
    }

    @Override
    public void destroy(T instance, CreationalContext<T> context) {
    }

    @Override
    public Set<Type> getTypes() {
        return Collections.singleton(this.clazz);
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return QUALIFIERS;
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return Dependent.class;
    }

    @Override
    public String getName() {
        return "ConfigInjectionBean_" + this.clazz;
    }

    @Override
    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    @Override
    public boolean isAlternative() {
        return false;
    }

    @Override
    public String getId() {
        return "ConfigInjectionBean_" + this.clazz;
    }

    static {
        QUALIFIERS.add(new ConfigPropertyLiteral());
    }

    private static class InjectionPointMetadataInjectionPoint
    implements InjectionPoint {
        private InjectionPointMetadataInjectionPoint() {
        }

        @Override
        public Type getType() {
            return InjectionPoint.class;
        }

        @Override
        public Set<Annotation> getQualifiers() {
            return Collections.singleton(new AnnotationLiteral<Default>(){});
        }

        @Override
        public Bean<?> getBean() {
            return null;
        }

        @Override
        public Member getMember() {
            return null;
        }

        @Override
        public Annotated getAnnotated() {
            return null;
        }

        @Override
        public boolean isDelegate() {
            return false;
        }

        @Override
        public boolean isTransient() {
            return false;
        }
    }

    private static class ConfigPropertyLiteral
    extends AnnotationLiteral<ConfigProperty>
    implements ConfigProperty {
        private ConfigPropertyLiteral() {
        }

        @Override
        public String name() {
            return "";
        }

        @Override
        public String defaultValue() {
            return "";
        }
    }
}

