/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context.propagators.rxjava2;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.BiFunction;
import java.util.concurrent.Executor;
import org.eclipse.microprofile.context.ThreadContext;

public class ContextPropagatorOnCompletableCreateAction
implements BiFunction<Completable, CompletableObserver, CompletableObserver> {
    private ThreadContext threadContext;

    public ContextPropagatorOnCompletableCreateAction(ThreadContext threadContext) {
        this.threadContext = threadContext;
    }

    @Override
    public CompletableObserver apply(Completable completable, CompletableObserver observer) throws Exception {
        return new ContextCapturerCompletable(completable, observer, this.threadContext.currentContextExecutor());
    }

    static final class ContextCapturerCompletable
    implements CompletableObserver {
        private final CompletableObserver source;
        private final Executor contextExecutor;

        public ContextCapturerCompletable(Completable s, CompletableObserver o, Executor contextExecutor) {
            this.source = o;
            this.contextExecutor = contextExecutor;
        }

        @Override
        public void onError(Throwable t) {
            this.contextExecutor.execute(() -> this.source.onError(t));
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.contextExecutor.execute(() -> this.source.onSubscribe(d));
        }

        @Override
        public void onComplete() {
            this.contextExecutor.execute(() -> this.source.onComplete());
        }
    }
}

