/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context.propagators.rxjava2;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.BiFunction;
import java.util.concurrent.Executor;
import org.eclipse.microprofile.context.ThreadContext;

public class ContextPropagatorOnObservableCreateAction
implements BiFunction<Observable, Observer, Observer> {
    private ThreadContext threadContext;

    public ContextPropagatorOnObservableCreateAction(ThreadContext threadContext) {
        this.threadContext = threadContext;
    }

    @Override
    public Observer apply(Observable observable, Observer observer) throws Exception {
        return new ContextCapturerObservable(observable, observer, this.threadContext.currentContextExecutor());
    }

    public class ContextCapturerObservable<T>
    implements Observer<T> {
        private final Observer<T> source;
        private final Executor contextExecutor;

        public ContextCapturerObservable(Observable<T> observable, Observer<T> observer, Executor contextExecutor) {
            this.source = observer;
            this.contextExecutor = contextExecutor;
        }

        @Override
        public void onComplete() {
            this.contextExecutor.execute(() -> this.source.onComplete());
        }

        @Override
        public void onError(Throwable t) {
            this.contextExecutor.execute(() -> this.source.onError(t));
        }

        @Override
        public void onNext(T v) {
            this.contextExecutor.execute(() -> this.source.onNext(v));
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.contextExecutor.execute(() -> this.source.onSubscribe(d));
        }
    }
}

