/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka;

import io.vertx.core.json.JsonObject;
import org.eclipse.microprofile.config.Config;

public class JsonHelper {
    public static JsonObject asJsonObject(Config config) {
        JsonObject json = new JsonObject();
        Iterable<String> propertyNames = config.getPropertyNames();
        for (String key : propertyNames) {
            try {
                int i = config.getValue(key, Integer.class);
                json.put(key, i);
            }
            catch (ClassCastException | IllegalArgumentException i) {
                try {
                    double d = config.getValue(key, Double.class);
                    json.put(key, d);
                }
                catch (ClassCastException | IllegalArgumentException d) {
                    try {
                        String value = config.getValue(key, String.class);
                        if (value.trim().equalsIgnoreCase("false")) {
                            json.put(key, false);
                            continue;
                        }
                        if (value.trim().equalsIgnoreCase("true")) {
                            json.put(key, true);
                            continue;
                        }
                        json.put(key, config.getValue(key, String.class));
                    }
                    catch (ClassCastException classCastException) {}
                }
            }
        }
        return json;
    }
}

