/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.ServerCookie;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.Cookie;
import io.vertx.ext.web.FileUpload;
import io.vertx.ext.web.Locale;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.codec.impl.BodyCodecImpl;
import io.vertx.ext.web.handler.impl.HttpStatusException;
import io.vertx.ext.web.impl.CookieImpl;
import io.vertx.ext.web.impl.HeaderParser;
import io.vertx.ext.web.impl.HttpServerRequestWrapper;
import io.vertx.ext.web.impl.ParsableHeaderValue;
import io.vertx.ext.web.impl.ParsableHeaderValuesContainer;
import io.vertx.ext.web.impl.ParsableLanguageValue;
import io.vertx.ext.web.impl.ParsableMIMEValue;
import io.vertx.ext.web.impl.RouteImpl;
import io.vertx.ext.web.impl.RouterImpl;
import io.vertx.ext.web.impl.RoutingContextImplBase;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class RoutingContextImpl
extends RoutingContextImplBase {
    private final RouterImpl router;
    private Map<String, Object> data;
    private Map<String, String> pathParams;
    private MultiMap queryParams;
    private AtomicInteger handlerSeq = new AtomicInteger();
    private Map<Integer, Handler<Void>> headersEndHandlers;
    private Map<Integer, Handler<Void>> bodyEndHandlers;
    private Throwable failure;
    private int statusCode = -1;
    private String normalisedPath;
    private String acceptableContentType;
    private ParsableHeaderValuesContainer parsedHeaders;
    private Map<String, Cookie> cookies;
    private Buffer body;
    private Set<FileUpload> fileUploads;
    private Session session;
    private User user;
    private static final String DEFAULT_404 = "<html><body><h1>Resource not found</h1></body></html>";

    public RoutingContextImpl(String mountPoint, RouterImpl router, HttpServerRequest request, Set<RouteImpl> routes) {
        super(mountPoint, request, routes);
        this.router = router;
        this.fillParsedHeaders(request);
        if (request.path().length() == 0) {
            this.fail(400);
        } else if (request.path().charAt(0) != '/') {
            this.fail(404);
        }
    }

    private String ensureNotNull(String string) {
        return string == null ? "" : string;
    }

    private void fillParsedHeaders(HttpServerRequest request) {
        String accept = request.getHeader("Accept");
        String acceptCharset = request.getHeader("Accept-Charset");
        String acceptEncoding = request.getHeader("Accept-Encoding");
        String acceptLanguage = request.getHeader("Accept-Language");
        String contentType = this.ensureNotNull(request.getHeader("Content-Type"));
        this.parsedHeaders = new ParsableHeaderValuesContainer(HeaderParser.sort(HeaderParser.convertToParsedHeaderValues(accept, ParsableMIMEValue::new)), HeaderParser.sort(HeaderParser.convertToParsedHeaderValues(acceptCharset, ParsableHeaderValue::new)), HeaderParser.sort(HeaderParser.convertToParsedHeaderValues(acceptEncoding, ParsableHeaderValue::new)), HeaderParser.sort(HeaderParser.convertToParsedHeaderValues(acceptLanguage, ParsableLanguageValue::new)), new ParsableMIMEValue(contentType));
    }

    @Override
    public HttpServerRequest request() {
        return this.request;
    }

    @Override
    public HttpServerResponse response() {
        return this.request.response();
    }

    @Override
    public Throwable failure() {
        return this.failure;
    }

    @Override
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    public boolean failed() {
        return this.failure != null || this.statusCode != -1;
    }

    @Override
    public void next() {
        if (!this.iterateNext()) {
            this.checkHandleNoMatch();
        }
    }

    private void checkHandleNoMatch() {
        if (this.failed()) {
            this.unhandledFailure(this.statusCode, this.failure, this.router);
        } else {
            Handler<RoutingContext> handler = this.router.getErrorHandlerByStatusCode(this.matchFailure);
            this.statusCode = this.matchFailure;
            if (handler == null) {
                this.response().setStatusCode(this.matchFailure);
                if (this.request().method() != HttpMethod.HEAD && this.matchFailure == 404) {
                    this.response().putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"text/html; charset=utf-8").end(DEFAULT_404);
                } else {
                    this.response().end();
                }
            } else {
                handler.handle(this);
            }
        }
    }

    @Override
    public void fail(int statusCode) {
        this.statusCode = statusCode;
        this.doFail();
    }

    @Override
    public void fail(Throwable t) {
        this.fail(-1, t);
    }

    @Override
    public void fail(int statusCode, Throwable throwable) {
        this.statusCode = statusCode;
        this.failure = throwable == null ? new NullPointerException() : throwable;
        this.doFail();
    }

    @Override
    public RoutingContext put(String key, Object obj) {
        this.getData().put(key, obj);
        return this;
    }

    @Override
    public Vertx vertx() {
        return this.router.vertx();
    }

    @Override
    public <T> T get(String key) {
        Object obj = this.getData().get(key);
        return (T)obj;
    }

    @Override
    public <T> T remove(String key) {
        Object obj = this.getData().remove(key);
        return (T)obj;
    }

    @Override
    public Map<String, Object> data() {
        return this.getData();
    }

    @Override
    public String normalisedPath() {
        if (this.normalisedPath == null) {
            String path = this.request.path();
            this.normalisedPath = path == null ? "/" : HttpUtils.normalizePath(path);
        }
        return this.normalisedPath;
    }

    @Override
    public Cookie getCookie(String name) {
        return CookieImpl.wrapIfNecessary((ServerCookie)this.request.getCookie(name));
    }

    @Override
    public RoutingContext addCookie(Cookie cookie) {
        return this.addCookie((io.vertx.core.http.Cookie)cookie);
    }

    @Override
    public RoutingContext addCookie(io.vertx.core.http.Cookie cookie) {
        this.request.response().addCookie(cookie);
        return this;
    }

    @Override
    public Cookie removeCookie(String name, boolean invalidate) {
        ServerCookie cookie = (ServerCookie)this.request.response().removeCookie(name, invalidate);
        return CookieImpl.wrapIfNecessary(cookie);
    }

    @Override
    public int cookieCount() {
        return this.request.cookieCount();
    }

    @Override
    public Set<Cookie> cookies() {
        return this.request.cookieMap().values().stream().map(c -> (ServerCookie)c).map(CookieImpl::wrapIfNecessary).collect(Collectors.toCollection(HashSet::new));
    }

    @Override
    public Map<String, io.vertx.core.http.Cookie> cookieMap() {
        return this.request.cookieMap();
    }

    @Override
    public String getBodyAsString() {
        return this.body != null ? this.body.toString() : null;
    }

    @Override
    public String getBodyAsString(String encoding) {
        return this.body != null ? this.body.toString(encoding) : null;
    }

    @Override
    public JsonObject getBodyAsJson() {
        if (this.body != null && this.body.length() > 1) {
            return BodyCodecImpl.JSON_OBJECT_DECODER.apply(this.body);
        }
        return null;
    }

    @Override
    public JsonArray getBodyAsJsonArray() {
        if (this.body != null && this.body.length() > 1) {
            return BodyCodecImpl.JSON_ARRAY_DECODER.apply(this.body);
        }
        return null;
    }

    @Override
    public Buffer getBody() {
        return this.body;
    }

    @Override
    public void setBody(Buffer body) {
        this.body = body;
    }

    @Override
    public Set<FileUpload> fileUploads() {
        return this.getFileUploads();
    }

    @Override
    public void setSession(Session session) {
        this.session = session;
    }

    @Override
    public Session session() {
        return this.session;
    }

    @Override
    public User user() {
        return this.user;
    }

    @Override
    public void setUser(User user) {
        this.user = user;
    }

    @Override
    public void clearUser() {
        this.user = null;
    }

    @Override
    public String getAcceptableContentType() {
        return this.acceptableContentType;
    }

    @Override
    public void setAcceptableContentType(String contentType) {
        this.acceptableContentType = contentType;
    }

    @Override
    public ParsableHeaderValuesContainer parsedHeaders() {
        return this.parsedHeaders;
    }

    @Override
    public int addHeadersEndHandler(Handler<Void> handler) {
        int seq = this.nextHandlerSeq();
        this.getHeadersEndHandlers().put(seq, handler);
        return seq;
    }

    @Override
    public boolean removeHeadersEndHandler(int handlerID) {
        return this.getHeadersEndHandlers().remove(handlerID) != null;
    }

    @Override
    public int addBodyEndHandler(Handler<Void> handler) {
        int seq = this.nextHandlerSeq();
        this.getBodyEndHandlers().put(seq, handler);
        return seq;
    }

    @Override
    public boolean removeBodyEndHandler(int handlerID) {
        return this.getBodyEndHandlers().remove(handlerID) != null;
    }

    @Override
    public void reroute(HttpMethod method, String path) {
        if (path.charAt(0) != '/') {
            throw new IllegalArgumentException("path must start with '/'");
        }
        ((HttpServerRequestWrapper)this.request).changeTo(method, path);
        this.request.params().clear();
        this.normalisedPath = null;
        this.statusCode = -1;
        this.response().headers().clear();
        if (this.cookies != null) {
            this.cookies.clear();
        }
        if (this.headersEndHandlers != null) {
            this.headersEndHandlers.clear();
        }
        if (this.bodyEndHandlers != null) {
            this.bodyEndHandlers.clear();
        }
        this.failure = null;
        this.restart();
    }

    @Override
    public List<Locale> acceptableLocales() {
        return this.parsedHeaders.acceptLanguage();
    }

    @Override
    public Map<String, String> pathParams() {
        return this.getPathParams();
    }

    @Override
    public @Nullable String pathParam(String name) {
        return this.getPathParams().get(name);
    }

    @Override
    public MultiMap queryParams() {
        return this.getQueryParams();
    }

    @Override
    public @Nullable List<String> queryParam(String query) {
        return this.getQueryParams().getAll(query);
    }

    private MultiMap getQueryParams() {
        if (this.queryParams == null) {
            try {
                this.queryParams = MultiMap.caseInsensitiveMultiMap();
                Map<String, List<String>> decodedParams = new QueryStringDecoder(this.request.uri()).parameters();
                for (Map.Entry<String, List<String>> entry : decodedParams.entrySet()) {
                    this.queryParams.add(entry.getKey(), (Iterable<String>)entry.getValue());
                }
            }
            catch (IllegalArgumentException e) {
                throw new HttpStatusException(400, "Error while decoding query params", e);
            }
        }
        return this.queryParams;
    }

    private Map<String, String> getPathParams() {
        if (this.pathParams == null) {
            this.pathParams = new HashMap<String, String>();
        }
        return this.pathParams;
    }

    private Map<Integer, Handler<Void>> getHeadersEndHandlers() {
        if (this.headersEndHandlers == null) {
            this.headersEndHandlers = new TreeMap(Collections.reverseOrder());
            this.response().headersEndHandler(v -> this.headersEndHandlers.values().forEach(handler -> handler.handle(null)));
        }
        return this.headersEndHandlers;
    }

    private Map<Integer, Handler<Void>> getBodyEndHandlers() {
        if (this.bodyEndHandlers == null) {
            this.bodyEndHandlers = new TreeMap(Collections.reverseOrder());
            this.response().bodyEndHandler(v -> this.bodyEndHandlers.values().forEach(handler -> handler.handle(null)));
        }
        return this.bodyEndHandlers;
    }

    private Set<FileUpload> getFileUploads() {
        if (this.fileUploads == null) {
            this.fileUploads = new HashSet<FileUpload>();
        }
        return this.fileUploads;
    }

    private void doFail() {
        this.iter = this.router.iterator();
        this.currentRoute = null;
        this.next();
    }

    private Map<String, Object> getData() {
        if (this.data == null) {
            this.data = new HashMap<String, Object>();
        }
        return this.data;
    }

    private int nextHandlerSeq() {
        int seq = this.handlerSeq.incrementAndGet();
        if (seq == Integer.MAX_VALUE) {
            throw new IllegalStateException("Too many header/body end handlers!");
        }
        return seq;
    }
}

