/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.http;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.core.http.HttpConnection;
import io.vertx.reactivex.core.http.HttpServerRequest;
import io.vertx.reactivex.core.http.ServerWebSocket;
import io.vertx.reactivex.core.metrics.Measured;
import io.vertx.reactivex.core.net.SocketAddress;
import io.vertx.reactivex.core.streams.ReadStream;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;

@RxGen(value=io.vertx.core.http.HttpServer.class)
public class HttpServer
implements Measured {
    public static final TypeArg<HttpServer> __TYPE_ARG = new TypeArg<HttpServer>(obj -> new HttpServer((io.vertx.core.http.HttpServer)obj), HttpServer::getDelegate);
    private final io.vertx.core.http.HttpServer delegate;
    private ReadStream<HttpServerRequest> cached_0;
    private ReadStream<ServerWebSocket> cached_1;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpServer that = (HttpServer)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpServer(io.vertx.core.http.HttpServer delegate) {
        this.delegate = delegate;
    }

    @Override
    public io.vertx.core.http.HttpServer getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public ReadStream<HttpServerRequest> requestStream() {
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        ReadStream<HttpServerRequest> ret = ReadStream.newInstance(this.delegate.requestStream(), HttpServerRequest.__TYPE_ARG);
        this.cached_0 = ret;
        return ret;
    }

    public HttpServer requestHandler(final Handler<HttpServerRequest> handler) {
        this.delegate.requestHandler(new Handler<io.vertx.core.http.HttpServerRequest>(){

            @Override
            public void handle(io.vertx.core.http.HttpServerRequest event) {
                handler.handle(HttpServerRequest.newInstance(event));
            }
        });
        return this;
    }

    public HttpServer connectionHandler(final Handler<HttpConnection> handler) {
        this.delegate.connectionHandler(new Handler<io.vertx.core.http.HttpConnection>(){

            @Override
            public void handle(io.vertx.core.http.HttpConnection event) {
                handler.handle(HttpConnection.newInstance(event));
            }
        });
        return this;
    }

    public HttpServer exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public ReadStream<ServerWebSocket> websocketStream() {
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        ReadStream<ServerWebSocket> ret = ReadStream.newInstance(this.delegate.websocketStream(), ServerWebSocket.__TYPE_ARG);
        this.cached_1 = ret;
        return ret;
    }

    public HttpServer websocketHandler(final Handler<ServerWebSocket> handler) {
        this.delegate.websocketHandler(new Handler<io.vertx.core.http.ServerWebSocket>(){

            @Override
            public void handle(io.vertx.core.http.ServerWebSocket event) {
                handler.handle(ServerWebSocket.newInstance(event));
            }
        });
        return this;
    }

    public HttpServer listen() {
        this.delegate.listen();
        return this;
    }

    public HttpServer listen(int port, String host) {
        this.delegate.listen(port, host);
        return this;
    }

    public HttpServer listen(int port, String host, final Handler<AsyncResult<HttpServer>> listenHandler) {
        this.delegate.listen(port, host, new Handler<AsyncResult<io.vertx.core.http.HttpServer>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
                if (ar.succeeded()) {
                    listenHandler.handle(Future.succeededFuture(HttpServer.newInstance(ar.result())));
                } else {
                    listenHandler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<HttpServer> rxListen(int port, String host) {
        return AsyncResultSingle.toSingle(handler -> this.listen(port, host, (Handler<AsyncResult<HttpServer>>)handler));
    }

    public HttpServer listen(SocketAddress address, final Handler<AsyncResult<HttpServer>> listenHandler) {
        this.delegate.listen(address.getDelegate(), new Handler<AsyncResult<io.vertx.core.http.HttpServer>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
                if (ar.succeeded()) {
                    listenHandler.handle(Future.succeededFuture(HttpServer.newInstance(ar.result())));
                } else {
                    listenHandler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<HttpServer> rxListen(SocketAddress address) {
        return AsyncResultSingle.toSingle(handler -> this.listen(address, (Handler<AsyncResult<HttpServer>>)handler));
    }

    public HttpServer listen(int port) {
        this.delegate.listen(port);
        return this;
    }

    public HttpServer listen(int port, final Handler<AsyncResult<HttpServer>> listenHandler) {
        this.delegate.listen(port, new Handler<AsyncResult<io.vertx.core.http.HttpServer>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
                if (ar.succeeded()) {
                    listenHandler.handle(Future.succeededFuture(HttpServer.newInstance(ar.result())));
                } else {
                    listenHandler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<HttpServer> rxListen(int port) {
        return AsyncResultSingle.toSingle(handler -> this.listen(port, (Handler<AsyncResult<HttpServer>>)handler));
    }

    public HttpServer listen(final Handler<AsyncResult<HttpServer>> listenHandler) {
        this.delegate.listen(new Handler<AsyncResult<io.vertx.core.http.HttpServer>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
                if (ar.succeeded()) {
                    listenHandler.handle(Future.succeededFuture(HttpServer.newInstance(ar.result())));
                } else {
                    listenHandler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<HttpServer> rxListen() {
        return AsyncResultSingle.toSingle(handler -> this.listen((Handler<AsyncResult<HttpServer>>)handler));
    }

    public void close() {
        this.delegate.close();
    }

    public void close(Handler<AsyncResult<Void>> completionHandler) {
        this.delegate.close(completionHandler);
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable(handler -> this.close((Handler<AsyncResult<Void>>)handler));
    }

    public int actualPort() {
        int ret = this.delegate.actualPort();
        return ret;
    }

    public static HttpServer newInstance(io.vertx.core.http.HttpServer arg) {
        return arg != null ? new HttpServer(arg) : null;
    }
}

