/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.auth.oauth2;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;
import io.vertx.ext.auth.oauth2.OAuth2FlowType;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.ext.auth.AuthProvider;
import io.vertx.reactivex.ext.auth.oauth2.AccessToken;
import io.vertx.reactivex.ext.auth.oauth2.OAuth2RBAC;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;

@RxGen(value=io.vertx.ext.auth.oauth2.OAuth2Auth.class)
public class OAuth2Auth
extends AuthProvider {
    public static final TypeArg<OAuth2Auth> __TYPE_ARG = new TypeArg<OAuth2Auth>(obj -> new OAuth2Auth((io.vertx.ext.auth.oauth2.OAuth2Auth)obj), OAuth2Auth::getDelegate);
    private final io.vertx.ext.auth.oauth2.OAuth2Auth delegate;

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuth2Auth that = (OAuth2Auth)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public OAuth2Auth(io.vertx.ext.auth.oauth2.OAuth2Auth delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    @Override
    public io.vertx.ext.auth.oauth2.OAuth2Auth getDelegate() {
        return this.delegate;
    }

    @Deprecated
    public static OAuth2Auth createKeycloak(Vertx vertx, OAuth2FlowType flow, JsonObject config) {
        OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth.createKeycloak(vertx.getDelegate(), flow, config));
        return ret;
    }

    @Deprecated
    public static OAuth2Auth create(Vertx vertx, OAuth2FlowType flow, OAuth2ClientOptions config) {
        OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth.create(vertx.getDelegate(), flow, config));
        return ret;
    }

    @Deprecated
    public static OAuth2Auth create(Vertx vertx, OAuth2FlowType flow) {
        OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth.create(vertx.getDelegate(), flow));
        return ret;
    }

    public static OAuth2Auth create(Vertx vertx) {
        OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth.create(vertx.getDelegate()));
        return ret;
    }

    public static OAuth2Auth create(Vertx vertx, OAuth2ClientOptions config) {
        OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth.create(vertx.getDelegate(), config));
        return ret;
    }

    public String authorizeURL(JsonObject params) {
        String ret = this.delegate.authorizeURL(params);
        return ret;
    }

    @Deprecated
    public void getToken(JsonObject params, final Handler<AsyncResult<AccessToken>> handler) {
        this.delegate.getToken(params, new Handler<AsyncResult<io.vertx.ext.auth.oauth2.AccessToken>>(){

            @Override
            public void handle(AsyncResult<io.vertx.ext.auth.oauth2.AccessToken> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(AccessToken.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
    }

    @Deprecated
    public Single<AccessToken> rxGetToken(JsonObject params) {
        return AsyncResultSingle.toSingle(handler -> this.getToken(params, (Handler<AsyncResult<AccessToken>>)handler));
    }

    @Deprecated
    public OAuth2Auth decodeToken(String token, final Handler<AsyncResult<AccessToken>> handler) {
        this.delegate.decodeToken(token, new Handler<AsyncResult<io.vertx.ext.auth.oauth2.AccessToken>>(){

            @Override
            public void handle(AsyncResult<io.vertx.ext.auth.oauth2.AccessToken> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(AccessToken.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Single<AccessToken> rxDecodeToken(String token) {
        return AsyncResultSingle.toSingle(handler -> this.decodeToken(token, (Handler<AsyncResult<AccessToken>>)handler));
    }

    public OAuth2Auth introspectToken(String token, final Handler<AsyncResult<AccessToken>> handler) {
        this.delegate.introspectToken(token, new Handler<AsyncResult<io.vertx.ext.auth.oauth2.AccessToken>>(){

            @Override
            public void handle(AsyncResult<io.vertx.ext.auth.oauth2.AccessToken> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(AccessToken.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<AccessToken> rxIntrospectToken(String token) {
        return AsyncResultSingle.toSingle(handler -> this.introspectToken(token, (Handler<AsyncResult<AccessToken>>)handler));
    }

    public OAuth2Auth introspectToken(String token, String tokenType, final Handler<AsyncResult<AccessToken>> handler) {
        this.delegate.introspectToken(token, tokenType, new Handler<AsyncResult<io.vertx.ext.auth.oauth2.AccessToken>>(){

            @Override
            public void handle(AsyncResult<io.vertx.ext.auth.oauth2.AccessToken> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(AccessToken.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<AccessToken> rxIntrospectToken(String token, String tokenType) {
        return AsyncResultSingle.toSingle(handler -> this.introspectToken(token, tokenType, (Handler<AsyncResult<AccessToken>>)handler));
    }

    @Deprecated
    public String getScopeSeparator() {
        String ret = this.delegate.getScopeSeparator();
        return ret;
    }

    public OAuth2FlowType getFlowType() {
        OAuth2FlowType ret = this.delegate.getFlowType();
        return ret;
    }

    public OAuth2Auth loadJWK(Handler<AsyncResult<Void>> handler) {
        this.delegate.loadJWK(handler);
        return this;
    }

    public Completable rxLoadJWK() {
        return AsyncResultCompletable.toCompletable(handler -> this.loadJWK((Handler<AsyncResult<Void>>)handler));
    }

    public OAuth2Auth rbacHandler(OAuth2RBAC rbac) {
        this.delegate.rbacHandler(rbac.getDelegate());
        return this;
    }

    public static OAuth2Auth newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth arg) {
        return arg != null ? new OAuth2Auth(arg) : null;
    }
}

