/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import kafka.controller.ControllerEvent;
import kafka.controller.ControllerEventManager$;
import kafka.controller.ControllerState;
import kafka.controller.ControllerState$Idle$;
import kafka.controller.KafkaController$ShutdownEventThread$;
import kafka.controller.PreemptableControllerEvent;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaTimer;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.ShutdownableThread;
import org.apache.kafka.common.errors.ControllerMovedException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005mu!B\u0011#\u0011\u00039c!B\u0015#\u0011\u0003Q\u0003\"B\u0019\u0002\t\u0003\u0011\u0004bB\u001a\u0002\u0005\u0004%\t\u0001\u000e\u0005\u0007{\u0005\u0001\u000b\u0011B\u001b\u0007\t%\u0012\u0003A\u0010\u0005\t\u000b\u0016\u0011\t\u0011)A\u0005\r\"A\u0011*\u0002B\u0001B\u0003%!\n\u0003\u0005W\u000b\t\u0005\t\u0015!\u0003X\u0011!\u0001WA!A!\u0002\u0013\t\u0007\"B\u0019\u0006\t\u0003!\u0007b\u00026\u0006\u0001\u0004%Ia\u001b\u0005\bY\u0016\u0001\r\u0011\"\u0003n\u0011\u0019\u0001X\u0001)Q\u0005!\"9Q/\u0002b\u0001\n\u00131\bbBA\u0002\u000b\u0001\u0006Ia\u001e\u0005\n\u0003\u000b)!\u0019!C\u0005\u0003\u000fA\u0001\"!\u0005\u0006A\u0003%\u0011\u0011\u0002\u0005\u000b\u0003')!\u0019!C\u0001E\u0005U\u0001\u0002CA&\u000b\u0001\u0006I!a\u0006\t\u0013\u00055SA1A\u0005\n\u0005=\u0003\u0002CA5\u000b\u0001\u0006I!!\u0015\t\u0013\u0005-TA1A\u0005\n\u00055\u0004\u0002CAC\u000b\u0001\u0006I!a\u001c\t\r\u0005\u001dU\u0001\"\u0001l\u0011\u001d\tI)\u0002C\u0001\u0003\u0013Bq!a#\u0006\t\u0003\tI\u0005C\u0004\u0002\u000e\u0016!\t!a$\t\u000f\u0005UU\u0001\"\u0001\u0002\u0018\u001a1\u00111D\u0003\u0001\u0003;AA\"a\u000b\u001e\u0005\u0003\u0005\u000b\u0011BA\u0017\u0003\u0003Ba!M\u000f\u0005\u0002\u0005\r\u0003bBA$;\u0011\u0005\u0013\u0011J\u0001\u0017\u0007>tGO]8mY\u0016\u0014XI^3oi6\u000bg.Y4fe*\u00111\u0005J\u0001\u000bG>tGO]8mY\u0016\u0014(\"A\u0013\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001&A\u0007\u0002E\t12i\u001c8ue>dG.\u001a:Fm\u0016tG/T1oC\u001e,'o\u0005\u0002\u0002WA\u0011AfL\u0007\u0002[)\ta&A\u0003tG\u0006d\u0017-\u0003\u00021[\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u0014\u00023\r{g\u000e\u001e:pY2,'/\u0012<f]R$\u0006N]3bI:\u000bW.Z\u000b\u0002kA\u0011agO\u0007\u0002o)\u0011\u0001(O\u0001\u0005Y\u0006twMC\u0001;\u0003\u0011Q\u0017M^1\n\u0005q:$AB*ue&tw-\u0001\u000eD_:$(o\u001c7mKJ,e/\u001a8u)\"\u0014X-\u00193OC6,\u0007eE\u0002\u0006W}\u0002\"\u0001Q\"\u000e\u0003\u0005S!A\u0011\u0013\u0002\u000f5,GO]5dg&\u0011A)\u0011\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\u0018\u0001D2p]R\u0014x\u000e\u001c7fe&#\u0007C\u0001\u0017H\u0013\tAUFA\u0002J]R\f!C]1uK\u0006sG\rV5nK6+GO]5dgB!1J\u0014)T\u001b\u0005a%BA'.\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u001f2\u00131!T1q!\tA\u0013+\u0003\u0002SE\ty1i\u001c8ue>dG.\u001a:Ti\u0006$X\r\u0005\u0002A)&\u0011Q+\u0011\u0002\u000b\u0017\u000647.\u0019+j[\u0016\u0014\u0018AF3wK:$\bK]8dKN\u001cX\r\u001a'jgR,g.\u001a:\u0011\t1B&,X\u0005\u000336\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0005!Z\u0016B\u0001/#\u0005=\u0019uN\u001c;s_2dWM]#wK:$\bC\u0001\u0017_\u0013\tyVF\u0001\u0003V]&$\u0018aF2p]R\u0014x\u000e\u001c7fe6{g/\u001a3MSN$XM\\3s!\ra#-X\u0005\u0003G6\u0012\u0011BR;oGRLwN\u001c\u0019\u0015\u000b\u00154w\r[5\u0011\u0005!*\u0001\"B#\u000b\u0001\u00041\u0005\"B%\u000b\u0001\u0004Q\u0005\"\u0002,\u000b\u0001\u00049\u0006\"\u00021\u000b\u0001\u0004\t\u0017AB0ti\u0006$X-F\u0001Q\u0003)y6\u000f^1uK~#S-\u001d\u000b\u0003;:Dqa\u001c\u0007\u0002\u0002\u0003\u0007\u0001+A\u0002yIE\nqaX:uCR,\u0007\u0005\u000b\u0002\u000eeB\u0011Af]\u0005\u0003i6\u0012\u0001B^8mCRLG.Z\u0001\baV$Hj\\2l+\u00059\bC\u0001=\u0000\u001b\u0005I(B\u0001>|\u0003\u0015awnY6t\u0015\taX0\u0001\u0006d_:\u001cWO\u001d:f]RT!A`\u001d\u0002\tU$\u0018\u000e\\\u0005\u0004\u0003\u0003I(!\u0004*fK:$(/\u00198u\u0019>\u001c7.\u0001\u0005qkRdunY6!\u0003\u0015\tX/Z;f+\t\tI\u0001E\u0003\u0002\f\u00055!,D\u0001|\u0013\r\tya\u001f\u0002\u0014\u0019&t7.\u001a3CY>\u001c7.\u001b8h#V,W/Z\u0001\u0007cV,W/\u001a\u0011\u0002\rQD'/Z1e+\t\t9\u0002E\u0002\u0002\u001aui\u0011!\u0002\u0002\u0016\u0007>tGO]8mY\u0016\u0014XI^3oiRC'/Z1e'\ri\u0012q\u0004\t\u0005\u0003C\t9#\u0004\u0002\u0002$)\u0019\u0011Q\u0005\u0013\u0002\u000bU$\u0018\u000e\\:\n\t\u0005%\u00121\u0005\u0002\u0013'\",H\u000fZ8x]\u0006\u0014G.\u001a+ie\u0016\fG-\u0001\u0003oC6,\u0007\u0003BA\u0018\u0003{qA!!\r\u0002:A\u0019\u00111G\u0017\u000e\u0005\u0005U\"bAA\u001cM\u00051AH]8pizJ1!a\u000f.\u0003\u0019\u0001&/\u001a3fM&\u0019A(a\u0010\u000b\u0007\u0005mR&\u0003\u0003\u0002,\u0005\u001dB\u0003BA\f\u0003\u000bBq!a\u000b \u0001\u0004\ti#\u0001\u0004e_^{'o\u001b\u000b\u0002;\u00069A\u000f\u001b:fC\u0012\u0004\u0013\u0001\u0002;j[\u0016,\"!!\u0015\u0011\t\u0005M\u0013QM\u0007\u0003\u0003+RA!!\n\u0002X)!\u0011\u0011LA.\u0003\u0019\u0019w.\\7p]*\u0019Q%!\u0018\u000b\t\u0005}\u0013\u0011M\u0001\u0007CB\f7\r[3\u000b\u0005\u0005\r\u0014aA8sO&!\u0011qMA+\u0005\u0011!\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002%\u00154XM\u001c;Rk\u0016,X\rV5nK\"K7\u000f^\u000b\u0003\u0003_\u0002B!!\u001d\u0002\u00026\u0011\u00111\u000f\u0006\u0005\u0003k\n9(\u0001\u0003d_J,'b\u0001\"\u0002z)!\u00111PA?\u0003\u0019I\u0018-\\7fe*\u0011\u0011qP\u0001\u0004G>l\u0017\u0002BAB\u0003g\u0012\u0011\u0002S5ti><'/Y7\u0002'\u00154XM\u001c;Rk\u0016,X\rV5nK\"K7\u000f\u001e\u0011\u0002\u000bM$\u0018\r^3\u0002\u000bM$\u0018M\u001d;\u0002\u000b\rdwn]3\u0002\u0007A,H\u000fF\u0002^\u0003#Ca!a%\u001c\u0001\u0004Q\u0016!B3wK:$\u0018aC2mK\u0006\u0014\u0018I\u001c3QkR$2!XAM\u0011\u0019\t\u0019\n\ba\u00015\u0002")
public class ControllerEventManager
implements KafkaMetricsGroup {
    public final int kafka$controller$ControllerEventManager$$controllerId;
    public final Map<ControllerState, KafkaTimer> kafka$controller$ControllerEventManager$$rateAndTimeMetrics;
    public final Function1<ControllerEvent, BoxedUnit> kafka$controller$ControllerEventManager$$eventProcessedListener;
    public final Function0<BoxedUnit> kafka$controller$ControllerEventManager$$controllerMovedListener;
    private volatile ControllerState kafka$controller$ControllerEventManager$$_state;
    private final ReentrantLock putLock;
    private final LinkedBlockingQueue<ControllerEvent> kafka$controller$ControllerEventManager$$queue;
    private final ControllerEventThread thread;
    private final Time kafka$controller$ControllerEventManager$$time;
    private final Histogram kafka$controller$ControllerEventManager$$eventQueueTimeHist;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String ControllerEventThreadName() {
        return ControllerEventManager$.MODULE$.ControllerEventThreadName();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ControllerEventManager controllerEventManager = this;
        synchronized (controllerEventManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ControllerState kafka$controller$ControllerEventManager$$_state() {
        return this.kafka$controller$ControllerEventManager$$_state;
    }

    public void kafka$controller$ControllerEventManager$$_state_$eq(ControllerState x$1) {
        this.kafka$controller$ControllerEventManager$$_state = x$1;
    }

    private ReentrantLock putLock() {
        return this.putLock;
    }

    public LinkedBlockingQueue<ControllerEvent> kafka$controller$ControllerEventManager$$queue() {
        return this.kafka$controller$ControllerEventManager$$queue;
    }

    public ControllerEventThread thread() {
        return this.thread;
    }

    public Time kafka$controller$ControllerEventManager$$time() {
        return this.kafka$controller$ControllerEventManager$$time;
    }

    public Histogram kafka$controller$ControllerEventManager$$eventQueueTimeHist() {
        return this.kafka$controller$ControllerEventManager$$eventQueueTimeHist;
    }

    public ControllerState state() {
        return this.kafka$controller$ControllerEventManager$$_state();
    }

    public void start() {
        this.thread().start();
    }

    public void close() {
        this.clearAndPut(KafkaController$ShutdownEventThread$.MODULE$);
        this.thread().awaitShutdown();
    }

    public void put(ControllerEvent event) {
        CoreUtils$.MODULE$.inLock(this.putLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.kafka$controller$ControllerEventManager$$queue().put(event));
    }

    public void clearAndPut(ControllerEvent event) {
        CoreUtils$.MODULE$.inLock(this.putLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.kafka$controller$ControllerEventManager$$queue()).asScala()).foreach((Function1 & Serializable & scala.Serializable)evt -> {
                ControllerEventManager.$anonfun$clearAndPut$2(evt);
                return BoxedUnit.UNIT;
            });
            this.kafka$controller$ControllerEventManager$$queue().clear();
            this.put(event);
        });
    }

    public static final /* synthetic */ void $anonfun$clearAndPut$2(ControllerEvent evt) {
        block0: {
            if (!(evt instanceof PreemptableControllerEvent)) break block0;
            ((PreemptableControllerEvent)evt).preempt();
        }
    }

    public ControllerEventManager(int controllerId, Map<ControllerState, KafkaTimer> rateAndTimeMetrics, Function1<ControllerEvent, BoxedUnit> eventProcessedListener, Function0<BoxedUnit> controllerMovedListener) {
        this.kafka$controller$ControllerEventManager$$controllerId = controllerId;
        this.kafka$controller$ControllerEventManager$$rateAndTimeMetrics = rateAndTimeMetrics;
        this.kafka$controller$ControllerEventManager$$eventProcessedListener = eventProcessedListener;
        this.kafka$controller$ControllerEventManager$$controllerMovedListener = controllerMovedListener;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.kafka$controller$ControllerEventManager$$_state = ControllerState$Idle$.MODULE$;
        this.putLock = new ReentrantLock();
        this.kafka$controller$ControllerEventManager$$queue = new LinkedBlockingQueue();
        this.thread = new ControllerEventThread(ControllerEventManager$.MODULE$.ControllerEventThreadName());
        this.kafka$controller$ControllerEventManager$$time = Time.SYSTEM;
        this.kafka$controller$ControllerEventManager$$eventQueueTimeHist = this.newHistogram("EventQueueTimeMs", this.newHistogram$default$2(), this.newHistogram$default$3());
        this.newGauge("EventQueueSize", new Gauge<Object>(this){
            private final /* synthetic */ ControllerEventManager $outer;

            public int value() {
                return this.$outer.kafka$controller$ControllerEventManager$$queue().size();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }

    public class ControllerEventThread
    extends ShutdownableThread {
        @Override
        public void doWork() {
            ControllerEvent controllerEvent = this.kafka$controller$ControllerEventManager$ControllerEventThread$$$outer().kafka$controller$ControllerEventManager$$queue().take();
            if (KafkaController$ShutdownEventThread$.MODULE$.equals(controllerEvent)) {
                this.initiateShutdown();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                Object object;
                Object object2;
                this.kafka$controller$ControllerEventManager$ControllerEventThread$$$outer().kafka$controller$ControllerEventManager$$_state_$eq(controllerEvent.state());
                this.kafka$controller$ControllerEventManager$ControllerEventThread$$$outer().kafka$controller$ControllerEventManager$$eventQueueTimeHist().update(this.kafka$controller$ControllerEventManager$ControllerEventThread$$$outer().kafka$controller$ControllerEventManager$$time().milliseconds() - controllerEvent.enqueueTimeMs());
                try {
                    object2 = ((KafkaTimer)this.kafka$controller$ControllerEventManager$ControllerEventThread$$$outer().kafka$controller$ControllerEventManager$$rateAndTimeMetrics.apply((Object)this.kafka$controller$ControllerEventManager$ControllerEventThread$$$outer().state())).time((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> controllerEvent.process());
                }
                catch (ControllerMovedException e) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Controller moved to another broker when processing ").append(controllerEvent).append(".").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    this.kafka$controller$ControllerEventManager$ControllerEventThread$$$outer().kafka$controller$ControllerEventManager$$controllerMovedListener.apply$mcV$sp();
                    object2 = BoxedUnit.UNIT;
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Error processing event ").append(controllerEvent).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    object2 = BoxedUnit.UNIT;
                }
                try {
                    object = this.kafka$controller$ControllerEventManager$ControllerEventThread$$$outer().kafka$controller$ControllerEventManager$$eventProcessedListener.apply((Object)controllerEvent);
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Error while invoking listener for processed event ").append(controllerEvent).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    object = BoxedUnit.UNIT;
                }
                this.kafka$controller$ControllerEventManager$ControllerEventThread$$$outer().kafka$controller$ControllerEventManager$$_state_$eq(ControllerState$Idle$.MODULE$);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }

        public /* synthetic */ ControllerEventManager kafka$controller$ControllerEventManager$ControllerEventThread$$$outer() {
            return ControllerEventManager.this;
        }

        public ControllerEventThread(String name) {
            if (ControllerEventManager.this == null) {
                throw null;
            }
            super(name, false);
            this.logIdent_$eq(new StringBuilder(38).append("[ControllerEventThread controllerId=").append(ControllerEventManager.this.kafka$controller$ControllerEventManager$$controllerId).append("] ").toString());
        }
    }
}

