/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.common.StateChangeFailedException;
import kafka.controller.Callbacks;
import kafka.controller.Callbacks$;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewReplica$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflineReplica$;
import kafka.controller.OnlineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.controller.StateChangeLogger;
import kafka.controller.TopicDeletionManager;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zookeeper.GetDataResponse;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ControllerMovedException;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.zookeeper.KeeperException;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\u001da\u0001\u0002\u000f\u001e\u0001\tB\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tm\u0001\u0011\t\u0011)A\u0005o!A1\b\u0001B\u0001B\u0003%A\b\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003A\u0011!\u0019\u0005A!A!\u0002\u0013!\u0005\u0002\u0003&\u0001\u0005\u0003\u0005\u000b\u0011B&\t\u0011e\u0003!\u0011!Q\u0001\niCQ!\u0018\u0001\u0005\u0002yCqa\u001a\u0001C\u0002\u0013%\u0001\u000e\u0003\u0004m\u0001\u0001\u0006I!\u001b\u0005\u0006[\u0002!\tA\u001c\u0005\u0006e\u0002!\tA\u001c\u0005\u0006g\u0002!IA\u001c\u0005\u0006i\u0002!\t!\u001e\u0005\n\u0003/\u0001\u0011\u0013!C\u0001\u00033Aq!a\f\u0001\t\u0013\t\t\u0004C\u0004\u0002X\u0001!I!!\u0017\t\u000f\u0005M\u0004\u0001\"\u0003\u0002v!9\u0011\u0011\u0012\u0001\u0005\n\u0005-\u0005bBAP\u0001\u0011\u0005\u0011\u0011\u0015\u0005\b\u0003g\u0003A\u0011AA[\u0011\u001d\t\u0019\r\u0001C\u0001\u0003\u000bDq!!3\u0001\t\u0003\tY\rC\u0004\u0002R\u0002!I!a5\t\u000f\u0005m\u0007\u0001\"\u0003\u0002^\"9\u00111\u001e\u0001\u0005\n\u00055\bbBAz\u0001\u0011%\u0011Q\u001f\u0002\u0014%\u0016\u0004H.[2b'R\fG/Z'bG\"Lg.\u001a\u0006\u0003=}\t!bY8oiJ|G\u000e\\3s\u0015\u0005\u0001\u0013!B6bM.\f7\u0001A\n\u0004\u0001\rJ\u0003C\u0001\u0013(\u001b\u0005)#\"\u0001\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005!*#AB!osJ+g\r\u0005\u0002+[5\t1F\u0003\u0002-?\u0005)Q\u000f^5mg&\u0011af\u000b\u0002\b\u0019><w-\u001b8h\u0003\u0019\u0019wN\u001c4jOB\u0011\u0011\u0007N\u0007\u0002e)\u00111gH\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005U\u0012$aC&bM.\f7i\u001c8gS\u001e\f\u0011c\u001d;bi\u0016\u001c\u0005.\u00198hK2{wmZ3s!\tA\u0014(D\u0001\u001e\u0013\tQTDA\tTi\u0006$Xm\u00115b]\u001e,Gj\\4hKJ\f\u0011cY8oiJ|G\u000e\\3s\u0007>tG/\u001a=u!\tAT(\u0003\u0002?;\t\t2i\u001c8ue>dG.\u001a:D_:$X\r\u001f;\u0002)Q|\u0007/[2EK2,G/[8o\u001b\u0006t\u0017mZ3s!\tA\u0014)\u0003\u0002C;\t!Bk\u001c9jG\u0012+G.\u001a;j_:l\u0015M\\1hKJ\f\u0001B_6DY&,g\u000e\u001e\t\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000f~\t!A_6\n\u0005%3%!D&bM.\f'l[\"mS\u0016tG/\u0001\u0007sKBd\u0017nY1Ti\u0006$X\r\u0005\u0003M#N3V\"A'\u000b\u00059{\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0003!\u0016\n!bY8mY\u0016\u001cG/[8o\u0013\t\u0011VJA\u0002NCB\u0004\"\u0001\u000f+\n\u0005Uk\"a\u0005)beRLG/[8o\u0003:$'+\u001a9mS\u000e\f\u0007C\u0001\u001dX\u0013\tAVD\u0001\u0007SKBd\u0017nY1Ti\u0006$X-\u0001\u000fd_:$(o\u001c7mKJ\u0014%o\\6feJ+\u0017/^3ti\n\u000bGo\u00195\u0011\u0005aZ\u0016B\u0001/\u001e\u0005q\u0019uN\u001c;s_2dWM\u001d\"s_.,'OU3rk\u0016\u001cHOQ1uG\"\fa\u0001P5oSRtD\u0003C0aC\n\u001cG-\u001a4\u0011\u0005a\u0002\u0001\"B\u0018\t\u0001\u0004\u0001\u0004\"\u0002\u001c\t\u0001\u00049\u0004\"B\u001e\t\u0001\u0004a\u0004\"B \t\u0001\u0004\u0001\u0005\"B\"\t\u0001\u0004!\u0005\"\u0002&\t\u0001\u0004Y\u0005\"B-\t\u0001\u0004Q\u0016\u0001D2p]R\u0014x\u000e\u001c7fe&#W#A5\u0011\u0005\u0011R\u0017BA6&\u0005\rIe\u000e^\u0001\u000eG>tGO]8mY\u0016\u0014\u0018\n\u001a\u0011\u0002\u000fM$\u0018M\u001d;vaR\tq\u000e\u0005\u0002%a&\u0011\u0011/\n\u0002\u0005+:LG/\u0001\u0005tQV$Hm\\<o\u0003YIg.\u001b;jC2L'0\u001a*fa2L7-Y*uCR,\u0017A\u00055b]\u0012dWm\u0015;bi\u0016\u001c\u0005.\u00198hKN$ba\u001c<\u0002\n\u00055\u0001\"B<\u000f\u0001\u0004A\u0018\u0001\u0003:fa2L7-Y:\u0011\te\f\u0019a\u0015\b\u0003u~t!a\u001f@\u000e\u0003qT!!`\u0011\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0013bAA\u0001K\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0003\u0003\u000f\u00111aU3r\u0015\r\t\t!\n\u0005\u0007\u0003\u0017q\u0001\u0019\u0001,\u0002\u0017Q\f'oZ3u'R\fG/\u001a\u0005\n\u0003\u001fq\u0001\u0013!a\u0001\u0003#\t\u0011bY1mY\n\f7m[:\u0011\u0007a\n\u0019\"C\u0002\u0002\u0016u\u0011\u0011bQ1mY\n\f7m[:\u00029!\fg\u000e\u001a7f'R\fG/Z\"iC:<Wm\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u0004\u0016\u0005\u0003#\tib\u000b\u0002\u0002 A!\u0011\u0011EA\u0016\u001b\t\t\u0019C\u0003\u0003\u0002&\u0005\u001d\u0012!C;oG\",7m[3e\u0015\r\tI#J\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0017\u0003G\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003Q!w\u000eS1oI2,7\u000b^1uK\u000eC\u0017M\\4fgRIq.a\r\u00028\u0005M\u0013Q\u000b\u0005\u0007\u0003k\u0001\u0002\u0019A5\u0002\u0013I,\u0007\u000f\\5dC&#\u0007bBA\u001d!\u0001\u0007\u00111H\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\b#B=\u0002\u0004\u0005u\u0002\u0003BA \u0003\u001fj!!!\u0011\u000b\t\u0005\r\u0013QI\u0001\u0007G>lWn\u001c8\u000b\u0007\u0001\n9E\u0003\u0003\u0002J\u0005-\u0013AB1qC\u000eDWM\u0003\u0002\u0002N\u0005\u0019qN]4\n\t\u0005E\u0013\u0011\t\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019\tY\u0001\u0005a\u0001-\"9\u0011q\u0002\tA\u0002\u0005E\u0011!\u0006:f[>4XMU3qY&\u001c\u0017m\u001d$s_6L5O\u001d\u000b\u0007\u00037\ny'!\u001d\u0011\u0011\u0005u\u0013QMA\u001f\u0003SrA!a\u0018\u0002bA\u001110J\u0005\u0004\u0003G*\u0013A\u0002)sK\u0012,g-C\u0002S\u0003OR1!a\u0019&!\rA\u00141N\u0005\u0004\u0003[j\"a\u0007'fC\u0012,'/S:s\u0003:$7i\u001c8ue>dG.\u001a:Fa>\u001c\u0007\u000e\u0003\u0004\u00026E\u0001\r!\u001b\u0005\b\u0003s\t\u0002\u0019AA\u001e\u0003]!wNU3n_Z,'+\u001a9mS\u000e\f7O\u0012:p[&\u001b(\u000f\u0006\u0004\u0002x\u0005\u0015\u0015q\u0011\t\nI\u0005e\u00141LA\u001e\u0003{J1!a\u001f&\u0005\u0019!V\u000f\u001d7fgAA\u0011QLA3\u0003{\ty\bE\u0002z\u0003\u0003KA!a!\u0002\b\tIQ\t_2faRLwN\u001c\u0005\u0007\u0003k\u0011\u0002\u0019A5\t\u000f\u0005e\"\u00031\u0001\u0002<\u0005ir-\u001a;U_BL7\rU1si&$\u0018n\u001c8Ti\u0006$Xm\u001d$s_6T6\u000e\u0006\u0003\u0002\u000e\u0006u\u0005#\u0003\u0013\u0002z\u0005=\u00151HA?!!\ti&!\u001a\u0002>\u0005E\u0005\u0003BAJ\u00033k!!!&\u000b\u0007\u0005]u$A\u0002ba&LA!a'\u0002\u0016\naA*Z1eKJ\fe\u000eZ%te\"9\u0011\u0011H\nA\u0002\u0005m\u0012!K5t\u0003RdU-Y:u\u001f:,'+\u001a9mS\u000e\f\u0017J\u001c#fY\u0016$\u0018n\u001c8Ti\u0006\u0014H/\u001a3Ti\u0006$X\r\u0006\u0003\u0002$\u0006%\u0006c\u0001\u0013\u0002&&\u0019\u0011qU\u0013\u0003\u000f\t{w\u000e\\3b]\"9\u00111\u0016\u000bA\u0002\u00055\u0016!\u0002;pa&\u001c\u0007\u0003BA/\u0003_KA!!-\u0002h\t11\u000b\u001e:j]\u001e\fqB]3qY&\u001c\u0017m]%o'R\fG/\u001a\u000b\u0007\u0003o\u000bi,a0\u0011\u000b\u0005u\u0013\u0011X*\n\t\u0005m\u0016q\r\u0002\u0004'\u0016$\bbBAV+\u0001\u0007\u0011Q\u0016\u0005\u0007\u0003\u0003,\u0002\u0019\u0001,\u0002\u000bM$\u0018\r^3\u0002;\u0005\u0014X-\u00117m%\u0016\u0004H.[2bg\u001a{'\u000fV8qS\u000e$U\r\\3uK\u0012$B!a)\u0002H\"9\u00111\u0016\fA\u0002\u00055\u0016aE5t\u0003:L(+\u001a9mS\u000e\f\u0017J\\*uCR,GCBAR\u0003\u001b\fy\rC\u0004\u0002,^\u0001\r!!,\t\r\u0005\u0005w\u00031\u0001W\u0003EI7OV1mS\u0012$&/\u00198tSRLwN\u001c\u000b\u0007\u0003G\u000b).!7\t\r\u0005]\u0007\u00041\u0001T\u0003\u001d\u0011X\r\u001d7jG\u0006Da!a\u0003\u0019\u0001\u00041\u0016a\u00067pON+8mY3tg\u001a,H\u000e\u0016:b]NLG/[8o)%y\u0017q\\Aq\u0003K\fI\u000f\u0003\u0004\u00026e\u0001\r!\u001b\u0005\b\u0003GL\u0002\u0019AA\u001f\u0003%\u0001\u0018M\u001d;ji&|g\u000e\u0003\u0004\u0002hf\u0001\rAV\u0001\nGV\u0014(o\u0015;bi\u0016Da!a\u0003\u001a\u0001\u00041\u0016\u0001\u00067pO&sg/\u00197jIR\u0013\u0018M\\:ji&|g\u000eF\u0003p\u0003_\f\t\u0010\u0003\u0004\u0002Xj\u0001\ra\u0015\u0005\u0007\u0003\u0017Q\u0002\u0019\u0001,\u0002)1|wMR1jY\u0016$7\u000b^1uK\u000eC\u0017M\\4f)%y\u0017q_A}\u0003w\fi\u0010\u0003\u0004\u0002Xn\u0001\ra\u0015\u0005\u0007\u0003O\\\u0002\u0019\u0001,\t\r\u0005-1\u00041\u0001W\u0011\u001d\typ\u0007a\u0001\u0005\u0003\t\u0011\u0001\u001e\t\u0004s\n\r\u0011\u0002\u0002B\u0003\u0003\u000f\u0011\u0011\u0002\u00165s_^\f'\r\\3")
public class ReplicaStateMachine
implements Logging {
    private final StateChangeLogger stateChangeLogger;
    private final ControllerContext controllerContext;
    private final TopicDeletionManager topicDeletionManager;
    private final KafkaZkClient zkClient;
    private final Map<PartitionAndReplica, ReplicaState> replicaState;
    private final ControllerBrokerRequestBatch controllerBrokerRequestBatch;
    private final int controllerId;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ReplicaStateMachine replicaStateMachine = this;
        synchronized (replicaStateMachine) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private int controllerId() {
        return this.controllerId;
    }

    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Initializing replica state");
        this.initializeReplicaState();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Triggering online replica state changes");
        this.handleStateChanges((Seq<PartitionAndReplica>)this.controllerContext.allLiveReplicas().toSeq(), OnlineReplica$.MODULE$, this.handleStateChanges$default$3());
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Started replica state machine with initial state -> ").append($this.replicaState).toString());
    }

    public void shutdown() {
        this.replicaState.clear();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopped replica state machine");
    }

    private void initializeReplicaState() {
        this.controllerContext.allPartitions().foreach((Function1 & Serializable & scala.Serializable)partition -> {
            ReplicaStateMachine.$anonfun$initializeReplicaState$1(this, partition);
            return BoxedUnit.UNIT;
        });
    }

    public void handleStateChanges(Seq<PartitionAndReplica> replicas, ReplicaState targetState, Callbacks callbacks) {
        if (replicas.nonEmpty()) {
            try {
                this.controllerBrokerRequestBatch.newBatch();
                replicas.groupBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.replica())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    ReplicaStateMachine.$anonfun$handleStateChanges$2(this, targetState, callbacks, x0$1);
                    return BoxedUnit.UNIT;
                }, Iterable$.MODULE$.canBuildFrom());
                this.controllerBrokerRequestBatch.sendRequestsToBrokers(this.controllerContext.epoch());
            }
            catch (ControllerMovedException e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("Controller moved to another broker when moving some replicas to ").append(targetState).append(" state").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                throw e;
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Error while moving some replicas to ").append(targetState).append(" state").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            }
        }
    }

    public Callbacks handleStateChanges$default$3() {
        return new Callbacks(Callbacks$.MODULE$.$lessinit$greater$default$1());
    }

    private void doHandleStateChanges(int replicaId, Seq<TopicPartition> partitions, ReplicaState targetState, Callbacks callbacks) {
        Seq replicas = (Seq)partitions.map((Function1 & Serializable & scala.Serializable)partition -> new PartitionAndReplica((TopicPartition)partition, replicaId), Seq$.MODULE$.canBuildFrom());
        replicas.foreach((Function1 & Serializable & scala.Serializable)replica -> (ReplicaState)$this.replicaState.getOrElseUpdate(replica, (Function0 & Serializable & scala.Serializable)() -> NonExistentReplica$.MODULE$));
        Tuple2 tuple2 = replicas.partition((Function1 & Serializable & scala.Serializable)replica -> BoxesRunTime.boxToBoolean((boolean)this.isValidTransition(replica, targetState)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq validReplicas = (Seq)tuple2._1();
        Seq invalidReplicas = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)validReplicas, (Object)invalidReplicas);
        Tuple2 tuple23 = tuple22;
        Seq validReplicas2 = (Seq)tuple23._1();
        Seq invalidReplicas2 = (Seq)tuple23._2();
        invalidReplicas2.foreach((Function1 & Serializable & scala.Serializable)replica -> {
            this.logInvalidTransition(replica, targetState);
            return BoxedUnit.UNIT;
        });
        ReplicaState replicaState = targetState;
        if (NewReplica$.MODULE$.equals(replicaState)) {
            validReplicas2.foreach((Function1 & Serializable & scala.Serializable)replica -> {
                Option option;
                TopicPartition partition = replica.topicPartition();
                Option option2 = $this.controllerContext.partitionLeadershipInfo().get((Object)partition);
                if (option2 instanceof Some) {
                    BoxedUnit boxedUnit;
                    Some some = (Some)option2;
                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.value();
                    if (leaderIsrAndControllerEpoch.leaderAndIsr().leader() == replicaId) {
                        StateChangeFailedException exception = new StateChangeFailedException(new StringBuilder(101).append("Replica ").append(replicaId).append(" for partition ").append(partition).append(" cannot be moved to NewReplica state as it is being requested to become leader").toString());
                        this.logFailedStateChange((PartitionAndReplica)replica, (ReplicaState)$this.replicaState.apply(replica), OfflineReplica$.MODULE$, exception);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        $this.controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId}))), replica.topicPartition(), leaderIsrAndControllerEpoch, $this.controllerContext.partitionReplicaAssignment(replica.topicPartition()), true);
                        this.logSuccessfulTransition(replicaId, partition, (ReplicaState)$this.replicaState.apply(replica), NewReplica$.MODULE$);
                        boxedUnit = $this.replicaState.put(replica, (Object)NewReplica$.MODULE$);
                    }
                    option = boxedUnit;
                } else if (None$.MODULE$.equals(option2)) {
                    this.logSuccessfulTransition(replicaId, partition, (ReplicaState)$this.replicaState.apply(replica), NewReplica$.MODULE$);
                    option = $this.replicaState.put(replica, (Object)NewReplica$.MODULE$);
                } else {
                    throw new MatchError((Object)option2);
                }
                return option;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (OnlineReplica$.MODULE$.equals(replicaState)) {
            validReplicas2.foreach((Function1 & Serializable & scala.Serializable)replica -> {
                TopicPartition partition = replica.topicPartition();
                ReplicaState replicaState = (ReplicaState)$this.replicaState.apply(replica);
                if (NewReplica$.MODULE$.equals(replicaState)) {
                    BoxedUnit boxedUnit;
                    Seq<Object> assignment = $this.controllerContext.partitionReplicaAssignment(partition);
                    if (!assignment.contains((Object)BoxesRunTime.boxToInteger((int)replicaId))) {
                        $this.controllerContext.updatePartitionReplicaAssignment(partition, (Seq<Object>)((Seq)assignment.$colon$plus((Object)BoxesRunTime.boxToInteger((int)replicaId), Seq$.MODULE$.canBuildFrom())));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                } else {
                    Option option = $this.controllerContext.partitionLeadershipInfo().get((Object)partition);
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.value();
                        $this.controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId}))), replica.topicPartition(), leaderIsrAndControllerEpoch, $this.controllerContext.partitionReplicaAssignment(partition), false);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (None$.MODULE$.equals(option)) {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)option);
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                this.logSuccessfulTransition(replicaId, partition, (ReplicaState)$this.replicaState.apply(replica), OnlineReplica$.MODULE$);
                return $this.replicaState.put(replica, (Object)OnlineReplica$.MODULE$);
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (OfflineReplica$.MODULE$.equals(replicaState)) {
            validReplicas2.foreach((Function1 & Serializable & scala.Serializable)replica -> {
                this.controllerBrokerRequestBatch.addStopReplicaRequestForBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId}))), replica.topicPartition(), false, (Function2<AbstractResponse, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$4, x$5) -> {
                    ReplicaStateMachine.$anonfun$doHandleStateChanges$9(x$4, BoxesRunTime.unboxToInt((Object)x$5));
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            Tuple2 tuple24 = validReplicas2.partition((Function1 & Serializable & scala.Serializable)replica -> BoxesRunTime.boxToBoolean((boolean)ReplicaStateMachine.$anonfun$doHandleStateChanges$10(this, replica)));
            if (tuple24 == null) {
                throw new MatchError((Object)tuple24);
            }
            Seq replicasWithLeadershipInfo = (Seq)tuple24._1();
            Seq replicasWithoutLeadershipInfo = (Seq)tuple24._2();
            Tuple2 tuple25 = new Tuple2((Object)replicasWithLeadershipInfo, (Object)replicasWithoutLeadershipInfo);
            Tuple2 tuple26 = tuple25;
            Seq replicasWithLeadershipInfo2 = (Seq)tuple26._1();
            Seq replicasWithoutLeadershipInfo2 = (Seq)tuple26._2();
            scala.collection.immutable.Map<TopicPartition, LeaderIsrAndControllerEpoch> updatedLeaderIsrAndControllerEpochs = this.removeReplicasFromIsr(replicaId, (Seq<TopicPartition>)((Seq)replicasWithLeadershipInfo2.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.topicPartition(), Seq$.MODULE$.canBuildFrom())));
            updatedLeaderIsrAndControllerEpochs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                TopicPartition partition;
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    partition = (TopicPartition)tuple2._1();
                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
                    if (!$this.topicDeletionManager.isTopicQueuedUpForDeletion(partition.topic())) {
                        Seq recipients = (Seq)$this.controllerContext.partitionReplicaAssignment(partition).filterNot((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$8 -> x$8 == replicaId);
                        $this.controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq<Object>)recipients, partition, leaderIsrAndControllerEpoch, $this.controllerContext.partitionReplicaAssignment(partition), false);
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                PartitionAndReplica replica = new PartitionAndReplica(partition, replicaId);
                this.logSuccessfulTransition(replicaId, partition, (ReplicaState)$this.replicaState.apply((Object)replica), OfflineReplica$.MODULE$);
                Option option = $this.replicaState.put((Object)replica, (Object)OfflineReplica$.MODULE$);
                return option;
            });
            replicasWithoutLeadershipInfo2.foreach((Function1 & Serializable & scala.Serializable)replica -> {
                this.logSuccessfulTransition(replicaId, replica.topicPartition(), (ReplicaState)$this.replicaState.apply(replica), OfflineReplica$.MODULE$);
                return $this.replicaState.put(replica, (Object)OfflineReplica$.MODULE$);
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ReplicaDeletionStarted$.MODULE$.equals(replicaState)) {
            validReplicas2.foreach((Function1 & Serializable & scala.Serializable)replica -> {
                ReplicaStateMachine.$anonfun$doHandleStateChanges$15(this, replicaId, callbacks, replica);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ReplicaDeletionIneligible$.MODULE$.equals(replicaState)) {
            validReplicas2.foreach((Function1 & Serializable & scala.Serializable)replica -> {
                this.logSuccessfulTransition(replicaId, replica.topicPartition(), (ReplicaState)$this.replicaState.apply(replica), ReplicaDeletionIneligible$.MODULE$);
                return $this.replicaState.put(replica, (Object)ReplicaDeletionIneligible$.MODULE$);
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ReplicaDeletionSuccessful$.MODULE$.equals(replicaState)) {
            validReplicas2.foreach((Function1 & Serializable & scala.Serializable)replica -> {
                this.logSuccessfulTransition(replicaId, replica.topicPartition(), (ReplicaState)$this.replicaState.apply(replica), ReplicaDeletionSuccessful$.MODULE$);
                return $this.replicaState.put(replica, (Object)ReplicaDeletionSuccessful$.MODULE$);
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (NonExistentReplica$.MODULE$.equals(replicaState)) {
            validReplicas2.foreach((Function1 & Serializable & scala.Serializable)replica -> {
                Seq<Object> currentAssignedReplicas = $this.controllerContext.partitionReplicaAssignment(replica.topicPartition());
                $this.controllerContext.updatePartitionReplicaAssignment(replica.topicPartition(), (Seq<Object>)((Seq)currentAssignedReplicas.filterNot((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$9 -> x$9 == replica.replica())));
                this.logSuccessfulTransition(replicaId, replica.topicPartition(), (ReplicaState)$this.replicaState.apply(replica), NonExistentReplica$.MODULE$);
                return $this.replicaState.remove(replica);
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)replicaState);
        }
    }

    private scala.collection.immutable.Map<TopicPartition, LeaderIsrAndControllerEpoch> removeReplicasFromIsr(int replicaId, Seq<TopicPartition> partitions) {
        scala.collection.immutable.Map results = Predef$.MODULE$.Map().empty();
        Seq remaining = partitions;
        while (remaining.nonEmpty()) {
            Tuple3<scala.collection.immutable.Map<TopicPartition, LeaderIsrAndControllerEpoch>, Seq<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Exception>> tuple3 = this.doRemoveReplicasFromIsr(replicaId, remaining);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            scala.collection.immutable.Map successfulRemovals = (scala.collection.immutable.Map)tuple3._1();
            Seq removalsToRetry = (Seq)tuple3._2();
            scala.collection.immutable.Map failedRemovals = (scala.collection.immutable.Map)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)successfulRemovals, (Object)removalsToRetry, (Object)failedRemovals);
            Tuple3 tuple33 = tuple32;
            scala.collection.immutable.Map successfulRemovals2 = (scala.collection.immutable.Map)tuple33._1();
            Seq removalsToRetry2 = (Seq)tuple33._2();
            scala.collection.immutable.Map failedRemovals2 = (scala.collection.immutable.Map)tuple33._3();
            results = results.$plus$plus((GenTraversableOnce)successfulRemovals2);
            remaining = removalsToRetry2;
            failedRemovals2.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ReplicaStateMachine.$anonfun$removeReplicasFromIsr$1(this, replicaId, x0$1);
                return BoxedUnit.UNIT;
            });
        }
        return results;
    }

    private Tuple3<scala.collection.immutable.Map<TopicPartition, LeaderIsrAndControllerEpoch>, Seq<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Exception>> doRemoveReplicasFromIsr(int replicaId, Seq<TopicPartition> partitions) {
        Tuple3<scala.collection.immutable.Map<TopicPartition, LeaderAndIsr>, Seq<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Exception>> tuple3 = this.getTopicPartitionStatesFromZk(partitions);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        scala.collection.immutable.Map leaderAndIsrs = (scala.collection.immutable.Map)tuple3._1();
        Seq partitionsWithNoLeaderAndIsrInZk = (Seq)tuple3._2();
        scala.collection.immutable.Map failedStateReads = (scala.collection.immutable.Map)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)leaderAndIsrs, (Object)partitionsWithNoLeaderAndIsrInZk, (Object)failedStateReads);
        Tuple3 tuple33 = tuple32;
        scala.collection.immutable.Map leaderAndIsrs2 = (scala.collection.immutable.Map)tuple33._1();
        Seq partitionsWithNoLeaderAndIsrInZk2 = (Seq)tuple33._2();
        scala.collection.immutable.Map failedStateReads2 = (scala.collection.immutable.Map)tuple33._3();
        Tuple2 tuple2 = leaderAndIsrs2.partition((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaStateMachine.$anonfun$doRemoveReplicasFromIsr$1(replicaId, x0$1)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Map leaderAndIsrsWithReplica = (scala.collection.immutable.Map)tuple2._1();
        scala.collection.immutable.Map leaderAndIsrsWithoutReplica = (scala.collection.immutable.Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)leaderAndIsrsWithReplica, (Object)leaderAndIsrsWithoutReplica);
        Tuple2 tuple23 = tuple22;
        scala.collection.immutable.Map leaderAndIsrsWithReplica2 = (scala.collection.immutable.Map)tuple23._1();
        scala.collection.immutable.Map leaderAndIsrsWithoutReplica2 = (scala.collection.immutable.Map)tuple23._2();
        scala.collection.immutable.Map adjustedLeaderAndIsrs = leaderAndIsrsWithReplica2.mapValues((Function1 & Serializable & scala.Serializable)leaderAndIsr -> {
            int newLeader = replicaId == leaderAndIsr.leader() ? LeaderAndIsr$.MODULE$.NoLeader() : leaderAndIsr.leader();
            List adjustedIsr = leaderAndIsr.isr().size() == 1 ? leaderAndIsr.isr() : (List)leaderAndIsr.isr().filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$13 -> x$13 != replicaId);
            return leaderAndIsr.newLeaderAndIsr(newLeader, (List<Object>)adjustedIsr);
        });
        KafkaZkClient.UpdateLeaderAndIsrResult updateLeaderAndIsrResult = this.zkClient.updateLeaderAndIsr((scala.collection.immutable.Map<TopicPartition, LeaderAndIsr>)adjustedLeaderAndIsrs, this.controllerContext.epoch(), this.controllerContext.epochZkVersion());
        if (updateLeaderAndIsrResult == null) {
            throw new MatchError((Object)updateLeaderAndIsrResult);
        }
        scala.collection.immutable.Map<TopicPartition, LeaderAndIsr> successfulUpdates = updateLeaderAndIsrResult.successfulPartitions();
        Seq<TopicPartition> updatesToRetry = updateLeaderAndIsrResult.partitionsToRetry();
        scala.collection.immutable.Map<TopicPartition, Exception> failedUpdates = updateLeaderAndIsrResult.failedPartitions();
        Tuple3 tuple34 = new Tuple3(successfulUpdates, updatesToRetry, failedUpdates);
        Tuple3 tuple35 = tuple34;
        scala.collection.immutable.Map successfulUpdates2 = (scala.collection.immutable.Map)tuple35._1();
        Seq updatesToRetry2 = (Seq)tuple35._2();
        scala.collection.immutable.Map failedUpdates2 = (scala.collection.immutable.Map)tuple35._3();
        scala.collection.immutable.Map exceptionsForPartitionsWithNoLeaderAndIsrInZk = ((TraversableOnce)partitionsWithNoLeaderAndIsrInZk2.flatMap((Function1 & Serializable & scala.Serializable)partition -> {
            Iterable iterable;
            if (!$this.topicDeletionManager.isTopicQueuedUpForDeletion(partition.topic())) {
                StateChangeFailedException exception = new StateChangeFailedException(new StringBuilder(101).append("Failed to change state of replica ").append(replicaId).append(" for partition ").append(partition).append(" since the leader and isr path in zookeeper is empty").toString());
                iterable = Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partition), (Object)exception)));
            } else {
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map leaderIsrAndControllerEpochs = (scala.collection.immutable.Map)leaderAndIsrsWithoutReplica2.$plus$plus((GenTraversableOnce)successfulUpdates2).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            LeaderAndIsr leaderAndIsr = (LeaderAndIsr)tuple2._2();
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, $this.controllerContext.epoch());
            $this.controllerContext.partitionLeadershipInfo().put((Object)partition, (Object)leaderIsrAndControllerEpoch);
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)leaderIsrAndControllerEpoch);
            return tuple22;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        return new Tuple3((Object)leaderIsrAndControllerEpochs, (Object)updatesToRetry2, (Object)failedStateReads2.$plus$plus((GenTraversableOnce)exceptionsForPartitionsWithNoLeaderAndIsrInZk).$plus$plus((GenTraversableOnce)failedUpdates2));
    }

    private Tuple3<scala.collection.immutable.Map<TopicPartition, LeaderAndIsr>, Seq<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Exception>> getTopicPartitionStatesFromZk(Seq<TopicPartition> partitions) {
        Seq<GetDataResponse> seq;
        Map leaderAndIsrs = Map$.MODULE$.empty();
        Buffer partitionsWithNoLeaderAndIsrInZk = (Buffer)Buffer$.MODULE$.empty();
        Map failed = Map$.MODULE$.empty();
        try {
            seq = this.zkClient.getTopicPartitionStatesRaw(partitions);
        }
        catch (Exception e) {
            partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> failed.put(partition, (Object)e));
            return new Tuple3((Object)leaderAndIsrs.toMap(Predef$.MODULE$.$conforms()), (Object)partitionsWithNoLeaderAndIsrInZk, (Object)failed.toMap(Predef$.MODULE$.$conforms()));
        }
        Seq<GetDataResponse> getDataResponses = seq;
        getDataResponses.foreach((Function1 & Serializable & scala.Serializable)getDataResponse -> {
            Object object;
            TopicPartition partition = (TopicPartition)getDataResponse.ctx().get();
            KeeperException.Code code = getDataResponse.resultCode();
            KeeperException.Code code2 = KeeperException.Code.OK;
            if (!(code != null ? !code.equals(code2) : code2 != null)) {
                Option<LeaderIsrAndControllerEpoch> leaderIsrAndControllerEpochOpt = TopicPartitionStateZNode$.MODULE$.decode(getDataResponse.data(), getDataResponse.stat());
                if (leaderIsrAndControllerEpochOpt.isEmpty()) {
                    object = partitionsWithNoLeaderAndIsrInZk.$plus$eq((Object)partition);
                } else {
                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochOpt.get();
                    if (leaderIsrAndControllerEpoch.controllerEpoch() > $this.controllerContext.epoch()) {
                        StateChangeFailedException exception = new StateChangeFailedException(new StringBuilder(64).append("Leader and isr path written by another controller. This probably").append(new StringBuilder(81).append("means the current controller with epoch ").append($this.controllerContext.epoch()).append(" went through a soft failure and another ").toString()).append(new StringBuilder(76).append("controller was elected with epoch ").append(leaderIsrAndControllerEpoch.controllerEpoch()).append(". Aborting state change by this controller").toString()).toString());
                        object = failed.put((Object)partition, (Object)exception);
                    } else {
                        object = leaderAndIsrs.put((Object)partition, (Object)leaderIsrAndControllerEpoch.leaderAndIsr());
                    }
                }
            } else {
                KeeperException.Code code3 = getDataResponse.resultCode();
                KeeperException.Code code4 = KeeperException.Code.NONODE;
                object = !(code3 != null ? !code3.equals(code4) : code4 != null) ? partitionsWithNoLeaderAndIsrInZk.$plus$eq((Object)partition) : failed.put((Object)partition, getDataResponse.resultException().get());
            }
            return object;
        });
        return new Tuple3((Object)leaderAndIsrs.toMap(Predef$.MODULE$.$conforms()), (Object)partitionsWithNoLeaderAndIsrInZk, (Object)failed.toMap(Predef$.MODULE$.$conforms()));
    }

    public boolean isAtLeastOneReplicaInDeletionStartedState(String topic) {
        return this.controllerContext.replicasForTopic(topic).exists((Function1 & Serializable & scala.Serializable)replica -> BoxesRunTime.boxToBoolean((boolean)ReplicaStateMachine.$anonfun$isAtLeastOneReplicaInDeletionStartedState$1(this, replica)));
    }

    public Set<PartitionAndReplica> replicasInState(String topic, ReplicaState state) {
        return ((MapLike)this.replicaState.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaStateMachine.$anonfun$replicasInState$1(topic, state, x0$1)))).keySet().toSet();
    }

    public boolean areAllReplicasForTopicDeleted(String topic) {
        return this.controllerContext.replicasForTopic(topic).forall((Function1 & Serializable & scala.Serializable)replica -> BoxesRunTime.boxToBoolean((boolean)ReplicaStateMachine.$anonfun$areAllReplicasForTopicDeleted$1(this, replica)));
    }

    public boolean isAnyReplicaInState(String topic, ReplicaState state) {
        return this.replicaState.exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaStateMachine.$anonfun$isAnyReplicaInState$1(topic, state, x0$1)));
    }

    private boolean isValidTransition(PartitionAndReplica replica, ReplicaState targetState) {
        return targetState.validPreviousStates().contains(this.replicaState.apply((Object)replica));
    }

    private void logSuccessfulTransition(int replicaId, TopicPartition partition, ReplicaState currState, ReplicaState targetState) {
        this.stateChangeLogger.withControllerEpoch(this.controllerContext.epoch()).trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Changed state of replica ").append(replicaId).append(" for partition ").append(partition).append(" from ").append(currState).append(" to ").append(targetState).toString());
    }

    private void logInvalidTransition(PartitionAndReplica replica, ReplicaState targetState) {
        ReplicaState currState = (ReplicaState)this.replicaState.apply((Object)replica);
        IllegalStateException e = new IllegalStateException(new StringBuilder(27).append("Replica ").append(replica).append(" should be in the ").append(targetState.validPreviousStates().mkString(",")).append(" ").append(new StringBuilder(55).append("states before moving to ").append(targetState).append(" state. Instead it is in ").append(currState).append(" state").toString()).toString());
        this.logFailedStateChange(replica, currState, targetState, e);
    }

    private void logFailedStateChange(PartitionAndReplica replica, ReplicaState currState, ReplicaState targetState, Throwable t) {
        this.stateChangeLogger.withControllerEpoch(this.controllerContext.epoch()).error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Controller ").append(this.controllerId()).append(" epoch ").append($this.controllerContext.epoch()).append(" initiated state change of replica ").append(replica.replica()).append(" ").append(new StringBuilder(31).append("for partition ").append(replica.topicPartition()).append(" from ").append(currState).append(" to ").append(targetState).append(" failed").toString()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
    }

    public static final /* synthetic */ Option $anonfun$initializeReplicaState$2(ReplicaStateMachine $this, TopicPartition partition$1, int replicaId) {
        PartitionAndReplica partitionAndReplica = new PartitionAndReplica(partition$1, replicaId);
        return $this.controllerContext.isReplicaOnline(replicaId, partition$1, $this.controllerContext.isReplicaOnline$default$3()) ? $this.replicaState.put((Object)partitionAndReplica, (Object)OnlineReplica$.MODULE$) : $this.replicaState.put((Object)partitionAndReplica, (Object)ReplicaDeletionIneligible$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$initializeReplicaState$1(ReplicaStateMachine $this, TopicPartition partition) {
        Seq<Object> replicas = $this.controllerContext.partitionReplicaAssignment(partition);
        replicas.foreach((Function1 & Serializable & scala.Serializable)replicaId -> ReplicaStateMachine.$anonfun$initializeReplicaState$2($this, partition, BoxesRunTime.unboxToInt((Object)replicaId)));
    }

    public static final /* synthetic */ void $anonfun$handleStateChanges$2(ReplicaStateMachine $this, ReplicaState targetState$1, Callbacks callbacks$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int replicaId = tuple2._1$mcI$sp();
        Seq replicas = (Seq)tuple2._2();
        Seq partitions = (Seq)replicas.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.topicPartition(), Seq$.MODULE$.canBuildFrom());
        $this.doHandleStateChanges(replicaId, (Seq<TopicPartition>)partitions, targetState$1, callbacks$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$9(AbstractResponse x$4, int x$5) {
    }

    public static final /* synthetic */ boolean $anonfun$doHandleStateChanges$10(ReplicaStateMachine $this, PartitionAndReplica replica) {
        return $this.controllerContext.partitionLeadershipInfo().contains((Object)replica.topicPartition());
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$15(ReplicaStateMachine $this, int replicaId$1, Callbacks callbacks$2, PartitionAndReplica replica) {
        $this.logSuccessfulTransition(replicaId$1, replica.topicPartition(), (ReplicaState)$this.replicaState.apply((Object)replica), ReplicaDeletionStarted$.MODULE$);
        $this.replicaState.put((Object)replica, (Object)ReplicaDeletionStarted$.MODULE$);
        $this.controllerBrokerRequestBatch.addStopReplicaRequestForBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId$1}))), replica.topicPartition(), true, callbacks$2.stopReplicaResponseCallback());
    }

    public static final /* synthetic */ void $anonfun$removeReplicasFromIsr$1(ReplicaStateMachine $this, int replicaId$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition partition = (TopicPartition)tuple2._1();
        Exception e = (Exception)tuple2._2();
        PartitionAndReplica replica = new PartitionAndReplica(partition, replicaId$2);
        $this.logFailedStateChange(replica, (ReplicaState)$this.replicaState.apply((Object)replica), OfflineReplica$.MODULE$, e);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$doRemoveReplicasFromIsr$1(int replicaId$3, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        LeaderAndIsr leaderAndIsr = (LeaderAndIsr)tuple2._2();
        boolean bl = leaderAndIsr.isr().contains((Object)BoxesRunTime.boxToInteger((int)replicaId$3));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$isAtLeastOneReplicaInDeletionStartedState$1(ReplicaStateMachine $this, PartitionAndReplica replica) {
        Object object = $this.replicaState.apply((Object)replica);
        ReplicaDeletionStarted$ replicaDeletionStarted$ = ReplicaDeletionStarted$.MODULE$;
        return !(object != null ? !object.equals(replicaDeletionStarted$) : replicaDeletionStarted$ != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$replicasInState$1(String topic$1, ReplicaState state$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        PartitionAndReplica replica = (PartitionAndReplica)tuple2._1();
        ReplicaState s = (ReplicaState)tuple2._2();
        if (!replica.topic().equals(topic$1)) return false;
        ReplicaState replicaState = s;
        ReplicaState replicaState2 = state$1;
        if (replicaState != null) {
            if (!replicaState.equals(replicaState2)) return false;
            return true;
        }
        if (replicaState2 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$areAllReplicasForTopicDeleted$1(ReplicaStateMachine $this, PartitionAndReplica replica) {
        Object object = $this.replicaState.apply((Object)replica);
        ReplicaDeletionSuccessful$ replicaDeletionSuccessful$ = ReplicaDeletionSuccessful$.MODULE$;
        return !(object != null ? !object.equals(replicaDeletionSuccessful$) : replicaDeletionSuccessful$ != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$isAnyReplicaInState$1(String topic$2, ReplicaState state$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        PartitionAndReplica replica = (PartitionAndReplica)tuple2._1();
        ReplicaState s = (ReplicaState)tuple2._2();
        if (!replica.topic().equals(topic$2)) return false;
        ReplicaState replicaState = s;
        ReplicaState replicaState2 = state$2;
        if (replicaState != null) {
            if (!replicaState.equals(replicaState2)) return false;
            return true;
        }
        if (replicaState2 == null) return true;
        return false;
    }

    public ReplicaStateMachine(KafkaConfig config, StateChangeLogger stateChangeLogger, ControllerContext controllerContext, TopicDeletionManager topicDeletionManager, KafkaZkClient zkClient, Map<PartitionAndReplica, ReplicaState> replicaState, ControllerBrokerRequestBatch controllerBrokerRequestBatch) {
        this.stateChangeLogger = stateChangeLogger;
        this.controllerContext = controllerContext;
        this.topicDeletionManager = topicDeletionManager;
        this.zkClient = zkClient;
        this.replicaState = replicaState;
        this.controllerBrokerRequestBatch = controllerBrokerRequestBatch;
        Logging.$init$(this);
        this.controllerId = config.brokerId();
        this.logIdent_$eq(new StringBuilder(36).append("[ReplicaStateMachine controllerId=").append(this.controllerId()).append("] ").toString());
    }
}

