/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareMode$Disabled$;
import kafka.admin.RackAwareMode$Enforced$;
import kafka.admin.RackAwareMode$Safe$;
import kafka.cluster.Broker;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.log.LogConfig$;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicConfig$Client$;
import kafka.server.DynamicConfig$User$;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicZNode$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.BrokerNotAvailableException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.zookeeper.KeeperException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tEa\u0001\u0002\u0011\"\u0001\u0019B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\u0006q\u0001!\t!\u000f\u0005\u0006y\u0001!\t!\u0010\u0005\bO\u0002\t\n\u0011\"\u0001i\u0011\u001d\u0019\b!%A\u0005\u0002QDQA\u001e\u0001\u0005\u0002]D\u0001\"!\u0005\u0001#\u0003%\t\u0001\u001e\u0005\n\u0003'\u0001\u0011\u0013!C\u0001\u0003+Aq!!\u0007\u0001\t\u0003\tY\u0002C\u0004\u0002.\u0001!\t!a\f\t\u000f\u0005]\u0002\u0001\"\u0003\u0002:!9\u00111\n\u0001\u0005\u0002\u00055\u0003bBA)\u0001\u0011\u0005\u00111\u000b\u0005\n\u0003W\u0002\u0011\u0013!C\u0001\u0003[B\u0011\"!\u001d\u0001#\u0003%\t!a\u001d\t\u0013\u0005]\u0004!%A\u0005\u0002\u0005e\u0004bBA?\u0001\u0011%\u0011q\u0010\u0005\b\u0003#\u0003A\u0011AAJ\u0011\u001d\tY\n\u0001C\u0001\u0003;Cq!a+\u0001\t\u0003\ti\u000bC\u0004\u00026\u0002!\t!a.\t\u000f\u0005}\u0006\u0001\"\u0001\u0002B\"9\u0011q\u0019\u0001\u0005\u0002\u0005%\u0007bBAh\u0001\u0011\u0005\u0011\u0011\u001b\u0005\b\u0003\u001f\u0004A\u0011AAm\u0011\u001d\ty\u000e\u0001C\u0001\u0003CDq!!:\u0001\t\u0013\t9\u000fC\u0004\u0002t\u0002!\t!!>\t\u000f\u0005m\b\u0001\"\u0001\u0002~\"9!\u0011\u0001\u0001\u0005\u0002\t\r\u0001b\u0002B\u0004\u0001\u0011\u0005!\u0011\u0002\u0002\u000e\u0003\u0012l\u0017N\u001c.l\u00072LWM\u001c;\u000b\u0005\t\u001a\u0013A\u0001>l\u0015\u0005!\u0013!B6bM.\f7\u0001A\n\u0004\u0001\u001dj\u0003C\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#AB!osJ+g\r\u0005\u0002/c5\tqF\u0003\u00021G\u0005)Q\u000f^5mg&\u0011!g\f\u0002\b\u0019><w-\u001b8h\u0003!Q8n\u00117jK:$\bCA\u001b7\u001b\u0005\t\u0013BA\u001c\"\u00055Y\u0015MZ6b5.\u001cE.[3oi\u00061A(\u001b8jiz\"\"AO\u001e\u0011\u0005U\u0002\u0001\"B\u001a\u0003\u0001\u0004!\u0014aC2sK\u0006$X\rV8qS\u000e$bAP!O'V{\u0006C\u0001\u0015@\u0013\t\u0001\u0015F\u0001\u0003V]&$\b\"\u0002\"\u0004\u0001\u0004\u0019\u0015!\u0002;pa&\u001c\u0007C\u0001#L\u001d\t)\u0015\n\u0005\u0002GS5\tqI\u0003\u0002IK\u00051AH]8pizJ!AS\u0015\u0002\rA\u0013X\rZ3g\u0013\taUJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0015&BQaT\u0002A\u0002A\u000b!\u0002]1si&$\u0018n\u001c8t!\tA\u0013+\u0003\u0002SS\t\u0019\u0011J\u001c;\t\u000bQ\u001b\u0001\u0019\u0001)\u0002#I,\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000fC\u0004W\u0007A\u0005\t\u0019A,\u0002\u0017Q|\u0007/[2D_:4\u0017n\u001a\t\u00031vk\u0011!\u0017\u0006\u00035n\u000bA!\u001e;jY*\tA,\u0001\u0003kCZ\f\u0017B\u00010Z\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\bA\u000e\u0001\n\u00111\u0001b\u00035\u0011\u0018mY6Bo\u0006\u0014X-T8eKB\u0011!-Z\u0007\u0002G*\u0011AmI\u0001\u0006C\u0012l\u0017N\\\u0005\u0003M\u000e\u0014QBU1dW\u0006;\u0018M]3N_\u0012,\u0017!F2sK\u0006$X\rV8qS\u000e$C-\u001a4bk2$H\u0005N\u000b\u0002S*\u0012qK[\u0016\u0002WB\u0011A.]\u0007\u0002[*\u0011an\\\u0001\nk:\u001c\u0007.Z2lK\u0012T!\u0001]\u0015\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002s[\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002+\r\u0014X-\u0019;f)>\u0004\u0018n\u0019\u0013eK\u001a\fW\u000f\u001c;%kU\tQO\u000b\u0002bU\u0006\u0011r-\u001a;Ce>\\WM]'fi\u0006$\u0017\r^1t)\u0015A\u00181AA\u0003!\rIHP`\u0007\u0002u*\u001110K\u0001\u000bG>dG.Z2uS>t\u0017BA?{\u0005\r\u0019V-\u001d\t\u0003E~L1!!\u0001d\u00059\u0011%o\\6fe6+G/\u00193bi\u0006Dq\u0001\u0019\u0004\u0011\u0002\u0003\u0007\u0011\rC\u0005\u0002\b\u0019\u0001\n\u00111\u0001\u0002\n\u0005Q!M]8lKJd\u0015n\u001d;\u0011\u000b!\nY!a\u0004\n\u0007\u00055\u0011F\u0001\u0004PaRLwN\u001c\t\u0004sr\u0004\u0016\u0001H4fi\n\u0013xn[3s\u001b\u0016$\u0018\rZ1uCN$C-\u001a4bk2$H%M\u0001\u001dO\u0016$(I]8lKJlU\r^1eCR\f7\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\t9BK\u0002\u0002\n)\f\u0011d\u0019:fCR,Gk\u001c9jG^KG\u000f[!tg&<g.\\3oiR9a(!\b\u0002 \u0005\r\u0002\"\u0002\"\n\u0001\u0004\u0019\u0005BBA\u0011\u0013\u0001\u0007q+\u0001\u0004d_:4\u0017n\u001a\u0005\b\u0003KI\u0001\u0019AA\u0014\u0003i\u0001\u0018M\u001d;ji&|gNU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u!\u0019I\u0018\u0011\u0006)\u0002\u0010%\u0019\u00111\u0006>\u0003\u00075\u000b\u0007/A\nwC2LG-\u0019;f)>\u0004\u0018nY\"sK\u0006$X\rF\u0004?\u0003c\t\u0019$!\u000e\t\u000b\tS\u0001\u0019A\"\t\u000f\u0005\u0015\"\u00021\u0001\u0002(!1\u0011\u0011\u0005\u0006A\u0002]\u000bQd\u001e:ji\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:\f5o]5h]6,g\u000e\u001e\u000b\b}\u0005m\u0012QHA!\u0011\u0015\u00115\u00021\u0001D\u0011\u001d\tyd\u0003a\u0001\u0003O\t\u0011C]3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u\u0011\u001d\t\u0019e\u0003a\u0001\u0003\u000b\n\u0001\"[:Va\u0012\fG/\u001a\t\u0004Q\u0005\u001d\u0013bAA%S\t9!i\\8mK\u0006t\u0017a\u00033fY\u0016$X\rV8qS\u000e$2APA(\u0011\u0015\u0011E\u00021\u0001D\u00035\tG\r\u001a)beRLG/[8ogRq\u0011qEA+\u0003/\nY&a\u0018\u0002d\u0005\u001d\u0004\"\u0002\"\u000e\u0001\u0004\u0019\u0005bBA-\u001b\u0001\u0007\u0011qE\u0001\u0013KbL7\u000f^5oO\u0006\u001b8/[4o[\u0016tG\u000f\u0003\u0004\u0002^5\u0001\r\u0001_\u0001\u000bC2d'I]8lKJ\u001c\b\u0002CA1\u001bA\u0005\t\u0019\u0001)\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t\u0011%\ty$\u0004I\u0001\u0002\u0004\t)\u0007E\u0003)\u0003\u0017\t9\u0003C\u0005\u0002j5\u0001\n\u00111\u0001\u0002F\u0005aa/\u00197jI\u0006$Xm\u00148ms\u00069\u0012\r\u001a3QCJ$\u0018\u000e^5p]N$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003_R#\u0001\u00156\u0002/\u0005$G\rU1si&$\u0018n\u001c8tI\u0011,g-Y;mi\u0012*TCAA;U\r\t)G[\u0001\u0018C\u0012$\u0007+\u0019:uSRLwN\\:%I\u00164\u0017-\u001e7uIY*\"!a\u001f+\u0007\u0005\u0015#.A\rwC2LG-\u0019;f%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$Hc\u0002 \u0002\u0002\u0006\r\u0015q\u0011\u0005\b\u0003\u007f\t\u0002\u0019AA\u0014\u0011\u0019\t))\u0005a\u0001!\u0006IR\r\u001f9fGR,GMU3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8s\u0011\u001d\tI)\u0005a\u0001\u0003\u0017\u000b!#\u0019<bS2\f'\r\\3Ce>\\WM]%egB!A)!$Q\u0013\r\ty)\u0014\u0002\u0004'\u0016$\u0018a\u00039beN,'I]8lKJ$B!!&\u0002\u0018B!\u0001&a\u0003Q\u0011\u0019\tIJ\u0005a\u0001\u0007\u00061!M]8lKJ\fQb\u00195b]\u001e,7i\u001c8gS\u001e\u001cHc\u0002 \u0002 \u0006\r\u0016q\u0015\u0005\u0007\u0003C\u001b\u0002\u0019A\"\u0002\u0015\u0015tG/\u001b;z)f\u0004X\r\u0003\u0004\u0002&N\u0001\raQ\u0001\u000bK:$\u0018\u000e^=OC6,\u0007BBAU'\u0001\u0007q+A\u0004d_:4\u0017nZ:\u0002)\rD\u0017M\\4f\u00072LWM\u001c;JI\u000e{gNZ5h)\u0015q\u0014qVAZ\u0011\u0019\t\t\f\u0006a\u0001\u0007\u0006\t2/\u00198ji&TX\rZ\"mS\u0016tG/\u00133\t\r\u0005%F\u00031\u0001X\u0003y\u0019\u0007.\u00198hKV\u001bXM](s+N,'o\u00117jK:$\u0018\nZ\"p]\u001aLw\rF\u0003?\u0003s\u000bi\f\u0003\u0004\u0002<V\u0001\raQ\u0001\u0014g\u0006t\u0017\u000e^5{K\u0012,e\u000e^5us:\u000bW.\u001a\u0005\u0007\u0003S+\u0002\u0019A,\u0002'Y\fG.\u001b3bi\u0016$v\u000e]5d\u0007>tg-[4\u0015\u000by\n\u0019-!2\t\u000b\t3\u0002\u0019A\"\t\r\u0005%f\u00031\u0001X\u0003E\u0019\u0007.\u00198hKR{\u0007/[2D_:4\u0017n\u001a\u000b\u0006}\u0005-\u0017Q\u001a\u0005\u0006\u0005^\u0001\ra\u0011\u0005\u0007\u0003S;\u0002\u0019A,\u0002%\rD\u0017M\\4f\u0005J|7.\u001a:D_:4\u0017n\u001a\u000b\u0006}\u0005M\u0017q\u001b\u0005\b\u0003+D\u0002\u0019AA\b\u0003\u001d\u0011'o\\6feNDa!!+\u0019\u0001\u00049F#\u0002 \u0002\\\u0006u\u0007bBAM3\u0001\u0007\u0011Q\u0013\u0005\u0007\u0003SK\u0002\u0019A,\u0002)Y\fG.\u001b3bi\u0016\u0014%o\\6fe\u000e{gNZ5h)\rq\u00141\u001d\u0005\u0007\u0003SS\u0002\u0019A,\u0002%\rD\u0017M\\4f\u000b:$\u0018\u000e^=D_:4\u0017n\u001a\u000b\b}\u0005%\u0018Q^Ay\u0011\u0019\tYo\u0007a\u0001\u0007\u0006q!o\\8u\u000b:$\u0018\u000e^=UsB,\u0007BBAx7\u0001\u00071)A\fgk2d7+\u00198ji&TX\rZ#oi&$\u0018PT1nK\"1\u0011\u0011V\u000eA\u0002]\u000b\u0011CZ3uG\",e\u000e^5us\u000e{gNZ5h)\u00159\u0016q_A}\u0011\u0019\tY\u000f\ba\u0001\u0007\"1\u00111\u0018\u000fA\u0002\r\u000b!cZ3u\u00032dGk\u001c9jG\u000e{gNZ5hgR\u0011\u0011q \t\u0006s\u0006%2iV\u0001\u0016M\u0016$8\r[!mY\u0016sG/\u001b;z\u0007>tg-[4t)\u0011\tyP!\u0002\t\r\u0005\u0005f\u00041\u0001D\u0003i1W\r^2i\u00032d7\t[5mI\u0016sG/\u001b;z\u0007>tg-[4t)\u0019\tyPa\u0003\u0003\u000e!1\u00111^\u0010A\u0002\rCaAa\u0004 \u0001\u0004\u0019\u0015aD2iS2$WI\u001c;jif$\u0016\u0010]3")
public class AdminZkClient
implements Logging {
    private final KafkaZkClient zkClient;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        AdminZkClient adminZkClient = this;
        synchronized (adminZkClient) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void createTopic(String topic, int partitions, int replicationFactor, Properties topicConfig, RackAwareMode rackAwareMode) {
        Seq<BrokerMetadata> brokerMetadatas = this.getBrokerMetadatas(rackAwareMode, this.getBrokerMetadatas$default$2());
        Map<Object, Seq<Object>> replicaAssignment = AdminUtils$.MODULE$.assignReplicasToBrokers(brokerMetadatas, partitions, replicationFactor, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
        this.createTopicWithAssignment(topic, topicConfig, replicaAssignment);
    }

    public Properties createTopic$default$4() {
        return new Properties();
    }

    public RackAwareMode createTopic$default$5() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public Seq<BrokerMetadata> getBrokerMetadatas(RackAwareMode rackAwareMode, Option<Seq<Object>> brokerList) {
        RackAwareMode rackAwareMode2;
        Seq<Broker> allBrokers = this.zkClient.getAllBrokersInCluster();
        Seq brokers = (Seq)brokerList.map((Function1 & Serializable & scala.Serializable)brokerIds -> (Seq)allBrokers.filter((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)brokerIds.contains((Object)BoxesRunTime.boxToInteger((int)b.id()))))).getOrElse((Function0 & Serializable & scala.Serializable)() -> allBrokers);
        Seq brokersWithRack = (Seq)brokers.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$getBrokerMetadatas$4(x$1)));
        RackAwareMode rackAwareMode3 = rackAwareMode;
        RackAwareMode$Enforced$ rackAwareMode$Enforced$ = RackAwareMode$Enforced$.MODULE$;
        if (!(rackAwareMode3 != null ? !rackAwareMode3.equals(rackAwareMode$Enforced$) : rackAwareMode$Enforced$ != null)) {
            if (brokersWithRack.nonEmpty() && brokersWithRack.size() < brokers.size()) {
                throw new AdminOperationException("Not all brokers have rack information. Add --disable-rack-aware in command line to make replica assignment without rack information.");
            }
        }
        Seq seq = RackAwareMode$Disabled$.MODULE$.equals(rackAwareMode2 = rackAwareMode) ? (Seq)brokers.map((Function1 & Serializable & scala.Serializable)broker -> new BrokerMetadata(broker.id(), (Option<String>)None$.MODULE$), Seq$.MODULE$.canBuildFrom()) : (RackAwareMode$Safe$.MODULE$.equals(rackAwareMode2) && brokersWithRack.size() < brokers.size() ? (Seq)brokers.map((Function1 & Serializable & scala.Serializable)broker -> new BrokerMetadata(broker.id(), (Option<String>)None$.MODULE$), Seq$.MODULE$.canBuildFrom()) : (Seq)brokers.map((Function1 & Serializable & scala.Serializable)broker -> new BrokerMetadata(broker.id(), broker.rack()), Seq$.MODULE$.canBuildFrom()));
        Seq brokerMetadatas = seq;
        return (Seq)brokerMetadatas.sortBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), (Ordering)Ordering.Int$.MODULE$);
    }

    public RackAwareMode getBrokerMetadatas$default$1() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public Option<Seq<Object>> getBrokerMetadatas$default$2() {
        return None$.MODULE$;
    }

    public void createTopicWithAssignment(String topic, Properties config, Map<Object, Seq<Object>> partitionReplicaAssignment) {
        this.validateTopicCreate(topic, partitionReplicaAssignment, config);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Creating topic ").append(topic).append(" with configuration ").append(config).append(" and initial partition ").append(new StringBuilder(11).append("assignment ").append(partitionReplicaAssignment).toString()).toString());
        this.zkClient.setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), topic, config);
        this.writeTopicPartitionAssignment(topic, partitionReplicaAssignment, false);
    }

    public void validateTopicCreate(String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, Properties config) {
        Topic.validate(topic);
        if (this.zkClient.topicExists(topic)) {
            throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
        }
        if (Topic.hasCollisionChars(topic)) {
            Seq<String> allTopics = this.zkClient.getAllTopicsInCluster();
            if (allTopics.contains((Object)topic)) {
                throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
            }
            Seq collidingTopics = (Seq)allTopics.filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$validateTopicCreate$1(topic, x$3)));
            if (collidingTopics.nonEmpty()) {
                throw new InvalidTopicException(new StringBuilder(40).append("Topic '").append(topic).append("' collides with existing topics: ").append(collidingTopics.mkString(", ")).toString());
            }
        }
        if (((TraversableOnce)partitionReplicaAssignment.values().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.size()), Iterable$.MODULE$.canBuildFrom())).toSet().size() != 1) {
            throw new InvalidReplicaAssignmentException("All partitions should have the same number of replicas");
        }
        partitionReplicaAssignment.values().foreach((Function1 & Serializable & scala.Serializable)reps -> {
            AdminZkClient.$anonfun$validateTopicCreate$3(partitionReplicaAssignment, reps);
            return BoxedUnit.UNIT;
        });
        LogConfig$.MODULE$.validate(config);
    }

    private void writeTopicPartitionAssignment(String topic, Map<Object, Seq<Object>> replicaAssignment, boolean isUpdate) {
        try {
            scala.collection.immutable.Map assignment = ((TraversableOnce)replicaAssignment.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int partitionId = tuple2._1$mcI$sp();
                Seq replicas = (Seq)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)new TopicPartition(topic, partitionId), (Object)replicas);
                return tuple22;
            }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            if (!isUpdate) {
                this.zkClient.createTopicAssignment(topic, (scala.collection.immutable.Map<TopicPartition, Seq<Object>>)assignment);
            } else {
                this.zkClient.setTopicAssignment(topic, (scala.collection.immutable.Map<TopicPartition, Seq<Object>>)assignment, this.zkClient.setTopicAssignment$default$3());
            }
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Updated path %s with %s for replica assignment")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TopicZNode$.MODULE$.path(topic), assignment})));
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
        }
        catch (Throwable e2) {
            throw new AdminOperationException(e2.toString());
        }
    }

    public void deleteTopic(String topic) {
        if (this.zkClient.topicExists(topic)) {
            try {
                this.zkClient.createDeleteTopicPath(topic);
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                throw new TopicAlreadyMarkedForDeletionException(new StringOps(Predef$.MODULE$.augmentString("topic %s is already marked for deletion")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
            }
            catch (Throwable e) {
                throw new AdminOperationException(e.getMessage());
            }
        } else {
            throw new UnknownTopicOrPartitionException(new StringBuilder(33).append("Topic `").append(topic).append("` to delete does not exist").toString());
        }
    }

    public Map<Object, Seq<Object>> addPartitions(String topic, Map<Object, Seq<Object>> existingAssignment, Seq<BrokerMetadata> allBrokers, int numPartitions, Option<Map<Object, Seq<Object>>> replicaAssignment, boolean validateOnly) {
        Map proposedAssignment;
        block1: {
            Seq existingAssignmentPartition0 = (Seq)existingAssignment.getOrElse((Object)BoxesRunTime.boxToInteger((int)0), (Function0 & Serializable & scala.Serializable)() -> {
                throw new AdminOperationException(new StringBuilder(80).append("Unexpected existing replica assignment for topic '").append(topic).append("', partition id 0 is missing. ").append(new StringBuilder(12).append("Assignment: ").append(existingAssignment).toString()).toString());
            });
            int partitionsToAdd = numPartitions - existingAssignment.size();
            if (partitionsToAdd <= 0) {
                throw new InvalidPartitionsException(new StringBuilder(60).append("The number of partitions for a topic can only be increased. ").append(new StringBuilder(34).append("Topic ").append(topic).append(" currently has ").append(existingAssignment.size()).append(" partitions, ").toString()).append(new StringBuilder(26).append(numPartitions).append(" would not be an increase.").toString()).toString());
            }
            replicaAssignment.foreach((Function1 & Serializable & scala.Serializable)proposedReplicaAssignment -> {
                this.validateReplicaAssignment((Map<Object, Seq<Object>>)proposedReplicaAssignment, existingAssignmentPartition0.size(), (Set<Object>)((TraversableOnce)allBrokers.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id()), Seq$.MODULE$.canBuildFrom())).toSet());
                return BoxedUnit.UNIT;
            });
            Map proposedAssignmentForNewPartitions = (Map)replicaAssignment.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                int startIndex = package$.MODULE$.max(0, allBrokers.indexWhere((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$addPartitions$5(existingAssignmentPartition0, x$6))));
                return AdminUtils$.MODULE$.assignReplicasToBrokers(allBrokers, partitionsToAdd, existingAssignmentPartition0.size(), startIndex, existingAssignment.size());
            });
            proposedAssignment = existingAssignment.$plus$plus((GenTraversableOnce)proposedAssignmentForNewPartitions);
            if (validateOnly) break block1;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Creating ").append(partitionsToAdd).append(" partitions for '").append(topic).append("' with the following replica assignment: ").append(new StringBuilder(1).append(proposedAssignmentForNewPartitions).append(".").toString()).toString());
            this.writeTopicPartitionAssignment(topic, (Map<Object, Seq<Object>>)proposedAssignment, true);
        }
        return proposedAssignment;
    }

    public int addPartitions$default$4() {
        return 1;
    }

    public Option<Map<Object, Seq<Object>>> addPartitions$default$5() {
        return None$.MODULE$;
    }

    public boolean addPartitions$default$6() {
        return false;
    }

    private void validateReplicaAssignment(Map<Object, Seq<Object>> replicaAssignment, int expectedReplicationFactor, Set<Object> availableBrokerIds) {
        replicaAssignment.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Seq replicas;
            int partitionId;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                partitionId = tuple2._1$mcI$sp();
                replicas = (Seq)tuple2._2();
                if (replicas.isEmpty()) {
                    throw new InvalidReplicaAssignmentException(new StringBuilder(54).append("Cannot have replication factor of 0 for partition id ").append(partitionId).append(".").toString());
                }
                if (replicas.size() != replicas.toSet().size()) {
                    throw new InvalidReplicaAssignmentException(new StringBuilder(53).append("Duplicate brokers not allowed in replica assignment: ").append(new StringBuilder(19).append(replicas.mkString(", ")).append(" for partition id ").append(partitionId).append(".").toString()).toString());
                }
                if (!replicas.toSet().subsetOf((GenSet)availableBrokerIds)) {
                    throw new BrokerNotAvailableException(new StringBuilder(60).append("Some brokers specified for partition id ").append(partitionId).append(" are not available. ").append(new StringBuilder(21).append("Specified brokers: ").append(replicas.mkString(", ")).append(", ").toString()).append(new StringBuilder(20).append("available brokers: ").append(availableBrokerIds.mkString(", ")).append(".").toString()).toString());
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partitionId)), (Object)BoxesRunTime.boxToInteger((int)replicas.size()));
            return tuple22;
        });
        Map badRepFactors = (Map)replicaAssignment.collect((PartialFunction)new scala.Serializable(null, expectedReplicationFactor){
            public static final long serialVersionUID = 0L;
            private final int expectedReplicationFactor$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, Seq<Object>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    int partition = A1._1$mcI$sp();
                    Seq replicas = (Seq)A1._2();
                    if (replicas.size() != this.expectedReplicationFactor$1) {
                        object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)BoxesRunTime.boxToInteger((int)replicas.size()));
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Object, Seq<Object>> x1) {
                Seq replicas;
                Tuple2<Object, Seq<Object>> tuple2 = x1;
                boolean bl = tuple2 != null && (replicas = (Seq)tuple2._2()).size() != this.expectedReplicationFactor$1;
                return bl;
            }
            {
                this.expectedReplicationFactor$1 = expectedReplicationFactor$1;
            }
        }, Map$.MODULE$.canBuildFrom());
        if (badRepFactors.nonEmpty()) {
            Seq sortedBadRepFactors = (Seq)badRepFactors.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$2(x0$2)), (Ordering)Ordering.Int$.MODULE$);
            Seq partitions = (Seq)sortedBadRepFactors.map((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$3(x0$3)), Seq$.MODULE$.canBuildFrom());
            Seq repFactors = (Seq)sortedBadRepFactors.map((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$4(x0$4)), Seq$.MODULE$.canBuildFrom());
            throw new InvalidReplicaAssignmentException(new StringBuilder(52).append("Inconsistent replication factor between partitions, ").append(new StringBuilder(42).append("partition 0 has ").append(expectedReplicationFactor).append(" while partitions [").append(partitions.mkString(", ")).append("] have ").toString()).append(new StringBuilder(37).append("replication factors [").append(repFactors.mkString(", ")).append("], respectively.").toString()).toString());
        }
    }

    public Option<Object> parseBroker(String broker) {
        None$ none$;
        String string = broker;
        String string2 = ConfigEntityName$.MODULE$.Default();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            none$ = None$.MODULE$;
        } else {
            Some some;
            try {
                some = new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(broker)).toInt()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(new StringBuilder(78).append("Error parsing broker ").append(broker).append(". The broker's Entity Name must be a single integer value").toString());
            }
            none$ = some;
        }
        return none$;
    }

    public void changeConfigs(String entityType, String entityName, Properties configs) {
        String string = entityType;
        String string2 = ConfigType$.MODULE$.Topic();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.changeTopicConfig(entityName, configs);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            String string4 = ConfigType$.MODULE$.Client();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                this.changeClientIdConfig(entityName, configs);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                String string6 = ConfigType$.MODULE$.User();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    this.changeUserOrUserClientIdConfig(entityName, configs);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    String string8 = ConfigType$.MODULE$.Broker();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        this.changeBrokerConfig(this.parseBroker(entityName), configs);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new IllegalArgumentException(new StringBuilder(49).append(entityType).append(" is not a known entityType. Should be one of ").append(ConfigType$.MODULE$.Topic()).append(", ").append(ConfigType$.MODULE$.Client()).append(", ").append(ConfigType$.MODULE$.Broker()).toString());
                    }
                }
            }
        }
    }

    public void changeClientIdConfig(String sanitizedClientId, Properties configs) {
        DynamicConfig$Client$.MODULE$.validate(configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Client(), sanitizedClientId, configs);
    }

    public void changeUserOrUserClientIdConfig(String sanitizedEntityName, Properties configs) {
        String string = sanitizedEntityName;
        String string2 = ConfigEntityName$.MODULE$.Default();
        java.util.Map<String, Object> map = !(string == null ? string2 != null : !string.equals(string2)) || sanitizedEntityName.contains("/clients") ? DynamicConfig$Client$.MODULE$.validate(configs) : DynamicConfig$User$.MODULE$.validate(configs);
        this.changeEntityConfig(ConfigType$.MODULE$.User(), sanitizedEntityName, configs);
    }

    public void validateTopicConfig(String topic, Properties configs) {
        Topic.validate(topic);
        if (!this.zkClient.topicExists(topic)) {
            throw new AdminOperationException(new StringOps(Predef$.MODULE$.augmentString("Topic \"%s\" does not exist.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
        }
        LogConfig$.MODULE$.validate(configs);
    }

    public void changeTopicConfig(String topic, Properties configs) {
        this.validateTopicConfig(topic, configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Topic(), topic, configs);
    }

    public void changeBrokerConfig(Seq<Object> brokers, Properties configs) {
        this.validateBrokerConfig(configs);
        brokers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)broker -> this.changeEntityConfig(ConfigType$.MODULE$.Broker(), ((Object)BoxesRunTime.boxToInteger((int)broker)).toString(), configs));
    }

    public void changeBrokerConfig(Option<Object> broker, Properties configs) {
        this.validateBrokerConfig(configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Broker(), (String)broker.map((Function1 & Serializable & scala.Serializable)x$7 -> AdminZkClient.$anonfun$changeBrokerConfig$2(BoxesRunTime.unboxToInt((Object)x$7))).getOrElse((Function0 & Serializable & scala.Serializable)() -> ConfigEntityName$.MODULE$.Default()), configs);
    }

    public void validateBrokerConfig(Properties configs) {
        DynamicConfig$Broker$.MODULE$.validate(configs);
    }

    private void changeEntityConfig(String rootEntityType, String fullSanitizedEntityName, Properties configs) {
        String sanitizedEntityPath = new StringBuilder(0).append(rootEntityType).append('/').append(fullSanitizedEntityName).toString();
        this.zkClient.setOrCreateEntityConfigs(rootEntityType, fullSanitizedEntityName, configs);
        this.zkClient.createConfigChangeNotification(sanitizedEntityPath);
    }

    public Properties fetchEntityConfig(String rootEntityType, String sanitizedEntityName) {
        return this.zkClient.getEntityConfigs(rootEntityType, sanitizedEntityName);
    }

    public Map<String, Properties> getAllTopicConfigs() {
        return ((TraversableOnce)this.zkClient.getAllTopicsInCluster().map((Function1 & Serializable & scala.Serializable)topic -> new Tuple2(topic, (Object)this.fetchEntityConfig(ConfigType$.MODULE$.Topic(), (String)topic)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, Properties> fetchAllEntityConfigs(String entityType) {
        return ((TraversableOnce)this.zkClient.getAllEntitiesWithConfig(entityType).map((Function1 & Serializable & scala.Serializable)entity -> new Tuple2(entity, (Object)this.fetchEntityConfig(entityType, (String)entity)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, Properties> fetchAllChildEntityConfigs(String rootEntityType, String childEntityType) {
        return ((TraversableOnce)((TraversableLike)this.entityPaths$1((Option)None$.MODULE$, rootEntityType).flatMap((Function1 & Serializable & scala.Serializable)entity -> this.entityPaths$1((Option)new Some((Object)new StringBuilder(0).append((String)entity).append('/').append(childEntityType).toString()), rootEntityType), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)entityPath -> new Tuple2(entityPath, (Object)this.fetchEntityConfig(rootEntityType, (String)entityPath)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ boolean $anonfun$getBrokerMetadatas$4(Broker x$1) {
        return x$1.rack().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$validateTopicCreate$1(String topic$2, String x$3) {
        return Topic.hasCollision(topic$2, x$3);
    }

    public static final /* synthetic */ void $anonfun$validateTopicCreate$3(Map partitionReplicaAssignment$2, Seq reps) {
        if (reps.size() != reps.toSet().size()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(36).append("Duplicate replica assignment found: ").append(partitionReplicaAssignment$2).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$addPartitions$5(Seq existingAssignmentPartition0$1, BrokerMetadata x$6) {
        return x$6.id() >= BoxesRunTime.unboxToInt((Object)existingAssignmentPartition0$1.head());
    }

    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$2(Tuple2 x0$2) {
        int partitionId;
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int n = partitionId = tuple2._1$mcI$sp();
        return n;
    }

    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$3(Tuple2 x0$3) {
        int partitionId;
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int n = partitionId = tuple2._1$mcI$sp();
        return n;
    }

    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$4(Tuple2 x0$4) {
        int rf;
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int n = rf = tuple2._2$mcI$sp();
        return n;
    }

    public static final /* synthetic */ String $anonfun$changeBrokerConfig$2(int x$7) {
        return ((Object)BoxesRunTime.boxToInteger((int)x$7)).toString();
    }

    private final Seq entityPaths$1(Option rootPath, String rootEntityType$1) {
        Seq seq;
        String string;
        Option option = rootPath;
        if (option instanceof Some) {
            Some some = (Some)option;
            String path = (String)some.value();
            string = new StringBuilder(0).append(rootEntityType$1).append('/').append(path).toString();
        } else if (None$.MODULE$.equals(option)) {
            string = rootEntityType$1;
        } else {
            throw new MatchError((Object)option);
        }
        String root = string;
        Seq entityNames = this.zkClient.getAllEntitiesWithConfig(root);
        Option option2 = rootPath;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String path = (String)some.value();
            seq = (Seq)entityNames.map((Function1 & Serializable & scala.Serializable)entityName -> new StringBuilder(0).append(path).append('/').append((String)entityName).toString(), Seq$.MODULE$.canBuildFrom());
        } else if (None$.MODULE$.equals(option2)) {
            seq = entityNames;
        } else {
            throw new MatchError((Object)option2);
        }
        return seq;
    }

    public AdminZkClient(KafkaZkClient zkClient) {
        this.zkClient = zkClient;
        Logging.$init$(this);
    }
}

