/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.kie.api.runtime.ClassObjectFilter;
import org.kie.api.runtime.ObjectFilter;

@XmlRootElement(name="class-object-filter")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ClassObjectSerializationFilter
implements ObjectFilter {
    @XmlAttribute(name="string", required=true)
    private String className = null;
    private transient Class filteredClass;

    public ClassObjectSerializationFilter() {
    }

    public ClassObjectSerializationFilter(Class clazz) {
        this.className = clazz.getCanonicalName();
        this.filteredClass = clazz;
    }

    public ClassObjectSerializationFilter(ClassObjectFilter objectFilter) {
        this(objectFilter.getFilteredClass());
    }

    public Class getFilteredClass() {
        return this.filteredClass;
    }

    public void setFilteredClass(Class filteredClass) {
        this.filteredClass = filteredClass;
    }

    @Override
    public boolean accept(Object object) {
        if (this.filteredClass == null) {
            try {
                Class<?> filteredClass;
                this.filteredClass = filteredClass = Class.forName(this.className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Unable to instantiate filter class: " + e.getMessage(), e);
            }
        }
        return this.filteredClass.isAssignableFrom(object.getClass());
    }
}

