/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.accumulators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.core.base.accumulators.AbstractAccumulateFunction;

public class CollectListAccumulateFunction
extends AbstractAccumulateFunction<CollectListData> {
    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public CollectListData createContext() {
        return new CollectListData();
    }

    @Override
    public void init(CollectListData data) {
        data.list.clear();
    }

    @Override
    public void accumulate(CollectListData data, Object value) {
        data.list.add(value);
    }

    @Override
    public void reverse(CollectListData data, Object value) {
        data.list.remove(value);
    }

    @Override
    public Object getResult(CollectListData data) {
        return Collections.unmodifiableList(data.list);
    }

    @Override
    public boolean supportsReverse() {
        return true;
    }

    @Override
    public Class<?> getResultType() {
        return List.class;
    }

    public static class CollectListData
    implements Externalizable {
        public List<Object> list = new ArrayList<Object>();

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.list = (List)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.list);
        }
    }
}

