/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.marshalling.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.SessionConfiguration;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.marshalling.impl.InternalMarshaller;
import org.drools.core.marshalling.impl.KieSessionInitializer;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.marshalling.impl.ProtobufInputMarshaller;
import org.drools.core.marshalling.impl.ProtobufOutputMarshaller;
import org.drools.core.marshalling.impl.ReadSessionResult;
import org.drools.core.marshalling.impl.RuleBaseNodes;
import org.drools.core.marshalling.impl.TimersInputMarshaller;
import org.drools.core.phreak.PhreakTimerNode;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.rule.SlidingTimeWindow;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.marshalling.MarshallingConfiguration;
import org.kie.api.marshalling.ObjectMarshallingStrategyStore;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class ProtobufMarshaller
implements InternalMarshaller {
    protected KieSessionInitializer initializer;
    public static final Map<Integer, TimersInputMarshaller> TIMER_READERS = new HashMap<Integer, TimersInputMarshaller>();
    protected KieBase kbase;
    protected RuleBaseConfiguration ruleBaseConfig;
    protected MarshallingConfiguration marshallingConfig;
    protected ObjectMarshallingStrategyStore strategyStore;

    @Override
    public KieSessionInitializer getInitializer() {
        return this.initializer;
    }

    @Override
    public void setInitializer(KieSessionInitializer initializer) {
        this.initializer = initializer;
    }

    public ProtobufMarshaller(KieBase kbase, MarshallingConfiguration marshallingConfig) {
        this.kbase = kbase;
        this.ruleBaseConfig = RuleBaseConfiguration.getDefaultInstance();
        this.marshallingConfig = marshallingConfig;
        this.strategyStore = this.marshallingConfig.getObjectMarshallingStrategyStore();
    }

    @Override
    public StatefulKnowledgeSession unmarshall(InputStream stream) throws IOException, ClassNotFoundException {
        return this.unmarshall(stream, null, null);
    }

    @Override
    public StatefulKnowledgeSession unmarshall(InputStream stream, KieSessionConfiguration config, Environment environment) throws IOException, ClassNotFoundException {
        return this.unmarshallWithMessage(stream, config, environment).getSession();
    }

    @Override
    public void unmarshall(InputStream stream, KieSession ksession) throws IOException, ClassNotFoundException {
        MarshallerReaderContext context = this.getMarshallerReaderContext(stream, ksession.getEnvironment());
        ProtobufInputMarshaller.readSession((StatefulKnowledgeSessionImpl)ksession, context);
        context.close();
    }

    @Override
    public void marshall(OutputStream stream, KieSession ksession) throws IOException {
        this.marshall(stream, ksession, ksession.getSessionClock().getCurrentTime());
    }

    public void marshall(OutputStream stream, KieSession ksession, long clockTime) throws IOException {
        ((InternalWorkingMemory)((Object)ksession)).flushPropagations();
        MarshallerWriteContext context = new MarshallerWriteContext(stream, (InternalKnowledgeBase)this.kbase, (InternalWorkingMemory)((Object)ksession), RuleBaseNodes.getNodeMap((InternalKnowledgeBase)this.kbase), this.strategyStore, this.marshallingConfig.isMarshallProcessInstances(), this.marshallingConfig.isMarshallWorkItems(), ksession.getEnvironment());
        context.clockTime = clockTime;
        ProtobufOutputMarshaller.writeSession(context);
        context.close();
    }

    @Override
    public MarshallingConfiguration getMarshallingConfiguration() {
        return this.marshallingConfig;
    }

    public ReadSessionResult unmarshallWithMessage(InputStream stream, KieSessionConfiguration config, Environment environment) throws IOException, ClassNotFoundException {
        if (config == null) {
            config = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        }
        if (environment == null) {
            environment = KieServices.get().newEnvironment();
        }
        MarshallerReaderContext context = this.getMarshallerReaderContext(stream, environment);
        int id = ((KnowledgeBaseImpl)this.kbase).nextWorkingMemoryCounter();
        ReadSessionResult readSessionResult = ProtobufInputMarshaller.readSession(context, id, environment, (SessionConfiguration)config, this.initializer);
        context.close();
        if (((SessionConfiguration)config).isKeepReference()) {
            ((KnowledgeBaseImpl)this.kbase).addStatefulSession(readSessionResult.getSession());
        }
        return readSessionResult;
    }

    private MarshallerReaderContext getMarshallerReaderContext(InputStream inputStream, Environment environment) throws IOException {
        return new MarshallerReaderContext(inputStream, (KnowledgeBaseImpl)this.kbase, RuleBaseNodes.getNodeMap((KnowledgeBaseImpl)this.kbase), this.strategyStore, TIMER_READERS, this.marshallingConfig.isMarshallProcessInstances(), this.marshallingConfig.isMarshallWorkItems(), environment);
    }

    static {
        TIMER_READERS.put(3, new SlidingTimeWindow.BehaviorJobContextTimerInputMarshaller());
        TIMER_READERS.put(1, new ObjectTypeNode.ExpireJobContextTimerInputMarshaller());
        TIMER_READERS.put(5, new PhreakTimerNode.TimerNodeTimerInputMarshaller());
    }
}

