/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.time.impl;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.core.time.SelfRemovalJob;
import org.drools.core.time.SelfRemovalJobContext;
import org.kie.services.time.InternalSchedulerService;
import org.kie.services.time.Job;
import org.kie.services.time.JobContext;
import org.kie.services.time.JobHandle;
import org.kie.services.time.Trigger;
import org.kie.services.time.impl.DefaultTimerJobInstance;
import org.kie.services.time.impl.TimerJobFactoryManager;
import org.kie.services.time.impl.TimerJobInstance;

public class ThreadSafeTrackableTimeJobFactoryManager
implements TimerJobFactoryManager {
    protected final Map<Long, TimerJobInstance> timerInstances = new ConcurrentHashMap<Long, TimerJobInstance>();

    protected JobContext createJobContext(JobContext ctx) {
        return new SelfRemovalJobContext(ctx, this.timerInstances);
    }

    @Override
    public TimerJobInstance createTimerJobInstance(Job job, JobContext ctx, Trigger trigger, JobHandle handle, InternalSchedulerService scheduler) {
        ctx.setJobHandle(handle);
        return new DefaultTimerJobInstance(new SelfRemovalJob(job), this.createJobContext(ctx), trigger, handle, scheduler);
    }

    @Override
    public void addTimerJobInstance(TimerJobInstance instance) {
        this.timerInstances.put(instance.getJobHandle().getId(), instance);
    }

    @Override
    public void removeTimerJobInstance(TimerJobInstance instance) {
        this.timerInstances.remove(instance.getJobHandle().getId());
    }

    @Override
    public Collection<TimerJobInstance> getTimerJobInstances() {
        return this.timerInstances.values();
    }
}

