/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.drools.core.common.DroolsObjectInputStream;
import org.drools.core.common.DroolsObjectOutputStream;

public abstract class ClassUtils
extends org.drools.reflective.util.ClassUtils {
    protected ClassUtils() {
    }

    public static <T extends Externalizable> T deepClone(T origin) {
        return origin == null ? null : (T)ClassUtils.deepClone(origin, origin.getClass().getClassLoader());
    }

    public static <T extends Externalizable> T deepClone(T origin, ClassLoader classLoader) {
        return ClassUtils.deepClone(origin, classLoader, Collections.emptyMap());
    }

    public static <T extends Externalizable> T deepClone(T origin, ClassLoader classLoader, Map<String, Object> cloningResources) {
        if (origin == null) {
            return null;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DroolsObjectOutputStream oos = new DroolsObjectOutputStream(baos);
            if (cloningResources != null) {
                cloningResources.forEach((k, v) -> oos.addCustomExtensions((String)k, v));
            }
            oos.writeObject(origin);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            DroolsObjectInputStream ois = new DroolsObjectInputStream(bais, classLoader);
            if (cloningResources != null) {
                cloningResources.forEach((k, v) -> ois.addCustomExtensions((String)k, v));
            }
            Object deepCopy = ois.readObject();
            return (T)((Externalizable)deepCopy);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
    }
}

