/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.asm;

import org.drools.core.util.asm.DumpMethodVisitor;
import org.mvel2.asm.AnnotationVisitor;
import org.mvel2.asm.Attribute;
import org.mvel2.asm.ClassReader;
import org.mvel2.asm.ClassVisitor;
import org.mvel2.asm.FieldVisitor;
import org.mvel2.asm.MethodVisitor;

public class MethodComparator {
    public boolean equivalent(String method1, ClassReader class1, String method2, ClassReader class2) {
        return this.getMethodBytecode(method1, class1).equals(this.getMethodBytecode(method2, class2));
    }

    public String getMethodBytecode(String methodName, ClassReader classReader) {
        Tracer visit = new Tracer(methodName);
        classReader.accept(visit, 2);
        return visit.getText();
    }

    public static String getMethodBytecode(String methodName, byte[] bytes) {
        Tracer visit = new Tracer(methodName);
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept(visit, 2);
        return visit.getText();
    }

    public static boolean compareBytecode(String b1, String b2) {
        return b1.equals(b2);
    }

    static class DummyAnnotationVisitor
    extends AnnotationVisitor {
        public DummyAnnotationVisitor() {
            super(458752);
        }

        @Override
        public void visit(String name, Object value) {
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return new DummyAnnotationVisitor();
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            return new DummyAnnotationVisitor();
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public void visitEnum(String name, String desc, String value) {
        }
    }

    public static class Tracer
    extends ClassVisitor {
        private String methodName;
        private String text;

        public Tracer(String methodName) {
            super(458752);
            this.methodName = methodName;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return new DummyAnnotationVisitor();
        }

        @Override
        public void visitAttribute(Attribute attr) {
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            return null;
        }

        @Override
        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return this.methodName.equals(name) ? new DumpMethodVisitor(this::setText) : null;
        }

        @Override
        public void visitOuterClass(String owner, String name, String desc) {
        }

        @Override
        public void visitSource(String source, String debug) {
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }
    }
}

